/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javaseis.array.LongArrayStorage;

public class JTestLongArrayStorage
extends TestCase {
    private static int MAX_COUNT = 42949672;

    public void testGetArray() {
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Float.TYPE, length);
        int buf_len = max_count / 8;
        float[] la = new float[buf_len];
        try {
            a.getArray(la, 0, buf_len, (long)(1.9375 * (double)max_count));
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void testPutArray() {
        int count = 5000;
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Float.TYPE, length);
        int buf_len = max_count / 8;
        float[] la = new float[buf_len];
        Arrays.fill(la, 0.0f);
        try {
            a.putArray(la, buf_len - count, count, (long)(1.9375 * (double)max_count));
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void testFillByte() {
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Byte.TYPE, length);
        try {
            a.fill((byte)0, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Byte failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void testFillShort() {
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Short.TYPE, length);
        try {
            a.fill((short)0, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Short failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void testFillInt() {
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Integer.TYPE, length);
        try {
            a.fill(0, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Int failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void testFillFloat() {
        int max_count = MAX_COUNT;
        long length = (long)(2.25 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Float.TYPE, length);
        try {
            a.fill(0.0f, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Float failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void tooBigToTestFillLong() {
        int max_count = MAX_COUNT;
        long length = (long)(1.125 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Long.TYPE, length);
        try {
            a.fill(0L, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Long failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public void tooBigToTestFillDouble() {
        int max_count = MAX_COUNT;
        long length = (long)(1.125 * (double)max_count);
        LongArrayStorage a = new LongArrayStorage(Double.TYPE, length);
        try {
            a.fill(0.0, 0L, 1L, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTestLongArrayStorage.assertTrue((String)("Double failure: " + e.getMessage()), (boolean)false);
        }
        a = null;
    }

    public static void main(String[] args) {
        TestRunner.run(JTestLongArrayStorage.class);
    }

    static {
        MAX_COUNT = 42949672;
        LongArrayStorage.TEST_MODE = true;
    }
}

