/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.seiszip;

public class GatedTraceGain {
    private static final int APPLY = 1;
    private static final int REMOVE = -1;
    private static final int FRONT = 0;
    private static final int BACK = 1;
    private static final float RMAXINT = 32766.0f;
    private static final int NSAMPS_PER_GATE = 256;
    private static final int HALF_GATE = 128;
    private int _samplesPerTrace;
    private float _ampMax;
    private short[] _shortGainVals;
    private int _ngates;
    private float[] _aveAmpsWork;
    private float[] _interpolatedAmps = null;

    public static int nGatesPerTrace(int samplesPerTrace) {
        return (samplesPerTrace - 1) / 256 + 1;
    }

    public GatedTraceGain(int samplesPerTrace) {
        this._samplesPerTrace = samplesPerTrace;
        this._ngates = GatedTraceGain.nGatesPerTrace(samplesPerTrace);
        this._shortGainVals = new short[this._ngates];
        this._aveAmpsWork = new float[this._ngates];
        this._interpolatedAmps = new float[samplesPerTrace];
    }

    public void computeGain(float[] trace) {
        int j;
        for (j = 0; j < this._ngates; ++j) {
            int ifirst = this.firstSampleInGate(j);
            int ilast = this.lastSampleInGate(j, this._samplesPerTrace);
            double sum = 0.0;
            int nlive = 0;
            for (int i = ifirst; i <= ilast; ++i) {
                if (trace[i] == 0.0f) continue;
                ++nlive;
                if (trace[i] > 0.0f) {
                    sum += (double)trace[i];
                    continue;
                }
                sum += (double)(-trace[i]);
            }
            this._aveAmpsWork[j] = nlive > 0 ? (float)(sum / (double)nlive) : 0.0f;
        }
        j = 0;
        while (j < this._ngates) {
            float dampingScalar = 1.0f + (float)j / (float)(this._ngates - 1);
            int n = j++;
            this._aveAmpsWork[n] = this._aveAmpsWork[n] * dampingScalar;
        }
        this._ampMax = this._aveAmpsWork[this._ngates - 1];
        for (j = this._ngates - 2; j >= 0; --j) {
            if (this._aveAmpsWork[j] < this._ampMax) {
                this._aveAmpsWork[j] = this._ampMax;
            }
            if (!(this._aveAmpsWork[j] > this._ampMax)) continue;
            this._ampMax = this._aveAmpsWork[j];
        }
        for (j = 0; j < this._ngates; ++j) {
            this._shortGainVals[j] = (short)Math.round(this._aveAmpsWork[j] / this._ampMax * 32766.0f);
            if (this._shortGainVals[j] != 0) continue;
            this._shortGainVals[j] = 1;
        }
        if ((double)this._ampMax == 0.0) {
            this._ampMax = 1.0f;
        }
    }

    private int firstSampleInGate(int jgate) {
        return jgate * 256;
    }

    private int lastSampleInGate(int jgate, int samplesPerTrace) {
        return jgate == GatedTraceGain.nGatesPerTrace(samplesPerTrace) - 1 ? samplesPerTrace - 1 : jgate * 256 + 256 - 1;
    }

    public void applyGain(float[] trace) {
        float[] interpolatedAmps = this.interpolateAveAmps();
        for (int i = 0; i < this._samplesPerTrace; ++i) {
            int n = i;
            trace[n] = trace[n] / interpolatedAmps[i];
        }
    }

    public void removeGain(float[] trace) {
        float[] interpolatedAmps = this.interpolateAveAmps();
        for (int i = 0; i < this._samplesPerTrace; ++i) {
            int n = i;
            trace[n] = trace[n] * interpolatedAmps[i];
        }
    }

    private float[] interpolateAveAmps() {
        int j;
        for (j = 0; j < this._ngates; ++j) {
            this._aveAmpsWork[j] = (float)this._shortGainVals[j] * this._ampMax / 32766.0f;
        }
        for (j = 0; j < this._ngates; ++j) {
            int ifirst = this.firstSampleInGate(j);
            int ilast = this.lastSampleInGate(j, this._samplesPerTrace);
            float ampFirst = this.interpolateAtASample(ifirst, this._samplesPerTrace, this._aveAmpsWork);
            float ampLast = this.interpolateAtASample(ilast, this._samplesPerTrace, this._aveAmpsWork);
            float delta = ifirst == ilast ? 0.0f : (ampLast - ampFirst) / (float)(ilast - ifirst);
            float amp = ampFirst;
            for (int i = ifirst; i <= ilast; ++i) {
                this._interpolatedAmps[i] = amp;
                amp += delta;
            }
        }
        return this._interpolatedAmps;
    }

    private float interpolateAtASample(int isamp, int samplesPerTrace, float[] aveAmpsWork) {
        int upperGate = 0;
        int lowerGate = 0;
        int jgate = isamp / 256;
        int imid = jgate * 256 + 128;
        if (isamp <= imid) {
            upperGate = jgate - 1;
            if (upperGate < 0) {
                return aveAmpsWork[0];
            }
            lowerGate = jgate;
        } else {
            upperGate = jgate;
            lowerGate = jgate + 1;
            if (lowerGate >= this._ngates) {
                return aveAmpsWork[this._ngates - 1];
            }
        }
        int imidUpper = upperGate * 256 + 128;
        int imidLower = lowerGate * 256 + 128;
        float distLower = imidLower - isamp;
        float weightUpper = distLower / (float)(imidLower - imidUpper);
        float weightLower = 1.0f - weightUpper;
        return weightUpper * aveAmpsWork[upperGate] + weightLower * aveAmpsWork[lowerGate];
    }

    public static void main(String[] args) {
        int i;
        int NSAMPS = 1051;
        float[] trace = new float[NSAMPS];
        float[] traceCopy = new float[NSAMPS];
        for (int i2 = 0; i2 < NSAMPS; ++i2) {
            trace[i2] = (float)(NSAMPS - i2) * 1000.0f;
            traceCopy[i2] = trace[i2];
        }
        GatedTraceGain traceGain = new GatedTraceGain(NSAMPS);
        traceGain.computeGain(trace);
        traceGain.applyGain(trace);
        traceGain.removeGain(trace);
        for (i = 0; i < NSAMPS; ++i) {
            assert (Math.abs(trace[i] - traceCopy[i]) / Math.abs(trace[i] + traceCopy[i]) < 0.005f);
        }
        for (i = 0; i < NSAMPS; ++i) {
            trace[i] = 20000.0f + (float)(NSAMPS - i) * 10.0f;
            if (i % 2 != 0) continue;
            trace[i] = -trace[i];
        }
        traceGain = new GatedTraceGain(NSAMPS);
        traceGain.computeGain(trace);
        traceGain.applyGain(trace);
        for (i = 0; i < NSAMPS; ++i) {
            assert (Math.abs((double)Math.abs(trace[i]) - 1.0) < (double)0.04f);
        }
        System.out.println("org.javaseis.seiszip.GatedTraceGain ***** SUCCESS *****\n");
    }
}

