/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.array.ArrayStorage;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.LongArrayStorage;
import org.javaseis.array.MultiArray;
import org.javaseis.array.Transpose;
import org.javaseis.array.TransposeType;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.util.ArrayUtil;

public class DistributedArray
implements IMultiArray {
    private static final Logger LOG = Logger.getLogger(DistributedArray.class.getName());
    private IMultiArray _multiArray;
    private IParallelContext _parallelContext;
    private int _ndim;
    private int _elementCount;
    private Class _classType;
    private int _nParDims;
    private int _pdim;
    private Decomposition _parDecomp;
    private int[] _decompTypes;
    private int[] _globalShape;
    private int[] _padShape;
    private int[] _localShape;
    private int[] _offsetMultiplier;
    private long _globalArrayLength;
    private long _localArrayLength;
    private int _rank;
    private int _size;
    private int _npn;
    private int _np;
    private int _nlive;
    private int _decomp;
    private static int BLOCK = Decomposition.BLOCK;
    private static int CIRCULAR = Decomposition.CIRCULAR;
    private static int NONE = Decomposition.NONE;

    public static DistributedArray constructDistributedArray(int ndim, int elementCount, int[] shape, float[] a, IParallelContext pc) {
        MultiArray ma = new MultiArray();
        ma.setClassType(Float.TYPE);
        ma.setElementCount(elementCount);
        ma.setDimensions(ndim);
        ma.setShape(shape);
        ma.setBackingArray(new ArrayStorage(a));
        return new DistributedArray(ma, pc);
    }

    public static DistributedArray constructDistributedArray(int ndim, int elementCount, int[] shape, float[][] a, IParallelContext pc) {
        MultiArray ma = new MultiArray();
        ma.setClassType(Float.TYPE);
        ma.setElementCount(elementCount);
        ma.setDimensions(ndim);
        ma.setShape(shape);
        LongArrayStorage la = new LongArrayStorage(Float.TYPE, a.length, a[0].length);
        la.setBackingArray(a, Float.TYPE);
        ma.setBackingArray(la);
        return new DistributedArray(ma, pc);
    }

    public Object clone() {
        return new DistributedArray(this);
    }

    public DistributedArray() {
        this._multiArray = null;
        this._parallelContext = null;
        this._nParDims = 0;
        this._pdim = 0;
        this._parDecomp = null;
    }

    public DistributedArray(DistributedArray cloneMe) {
        this.constructDistributedArray(cloneMe._parallelContext, cloneMe._multiArray.getClassType(), cloneMe._multiArray.getDimensions(), cloneMe._multiArray.getElementCount(), cloneMe.getShape(), cloneMe._decompTypes, cloneMe._localArrayLength, cloneMe.getBackingArray().getBackingArrayType());
        this._multiArray.getBackingArray().arraycopy(cloneMe._multiArray.getBackingArray(), 0L, this._multiArray.getBackingArray(), 0L, this._multiArray.getBackingArray().getLength());
        this.setShape(cloneMe.getShape());
    }

    public DistributedArray(IMultiArray a, IParallelContext pc) {
        this._parallelContext = pc;
        this._rank = pc.rank();
        this._size = pc.size();
        this._nParDims = 1;
        this._ndim = a.getDimensions();
        this._pdim = this._ndim - 1;
        this._elementCount = a.getElementCount();
        this._globalShape = a.getShape();
        this._globalShape[this._pdim] = this._size * this._globalShape[this._pdim];
        this._decompTypes = new int[this._ndim];
        Arrays.fill(this._decompTypes, BLOCK);
        this._padShape = (int[])this._globalShape.clone();
        this._localArrayLength = a.getBufferLength();
        this._globalArrayLength = this._localArrayLength * (long)this._size;
        this._multiArray = a;
        this._classType = a.getClassType();
        this.updateShape();
    }

    public DistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int decompType, long maxArrayLength) {
        int[] types = new int[ndim];
        for (int i = 0; i < ndim - 1; ++i) {
            types[i] = decompType;
        }
        this.constructDistributedArray(pc, classType, ndim, elementCount, lengths, types, maxArrayLength, null);
    }

    public DistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int[] decompTypes, long maxArrayLength) {
        this.constructDistributedArray(pc, classType, ndim, elementCount, lengths, decompTypes, maxArrayLength, null);
    }

    public DistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int[] decompTypes, long maxArrayLength, BackingArray.Type type) {
        this.constructDistributedArray(pc, classType, ndim, elementCount, lengths, decompTypes, maxArrayLength, type);
    }

    public DistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int decompType) {
        int[] types = new int[ndim];
        for (int i = 0; i < ndim - 1; ++i) {
            types[i] = decompType;
        }
        this.constructDistributedArray(pc, classType, ndim, elementCount, lengths, types, 0L, null);
    }

    public DistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int[] decompTypes) {
        this.constructDistributedArray(pc, classType, ndim, elementCount, lengths, decompTypes, 0L, null);
    }

    public DistributedArray(IParallelContext pc, int[] lengths) {
        int ndim = lengths.length;
        int[] decompTypes = new int[ndim];
        Arrays.fill(decompTypes, BLOCK);
        this.constructDistributedArray(pc, Float.TYPE, ndim, 1, lengths, decompTypes, 0L, null);
    }

    public DistributedArray(IParallelContext pc, int elementCount, int[] lengths) {
        int ndim = lengths.length;
        int[] decompTypes = new int[ndim];
        Arrays.fill(decompTypes, BLOCK);
        this.constructDistributedArray(pc, Float.TYPE, ndim, elementCount, lengths, decompTypes, 0L, null);
    }

    public DistributedArray(IParallelContext pc, int[] lengths, long maxlen) {
        int ndim = lengths.length;
        int[] decompTypes = new int[ndim];
        Arrays.fill(decompTypes, BLOCK);
        this.constructDistributedArray(pc, Float.TYPE, ndim, 1, lengths, decompTypes, maxlen, null);
    }

    private void constructDistributedArray(IParallelContext pc, Class classType, int ndim, int elementCount, int[] lengths, int[] decompTypes, long maxLocalArrayLength, BackingArray.Type type) {
        MultiArray multiArray;
        this._parallelContext = pc;
        this._rank = pc.rank();
        this._size = pc.size();
        this._nParDims = 1;
        this._pdim = ndim - 1;
        this._globalShape = (int[])lengths.clone();
        this._padShape = (int[])lengths.clone();
        this._decompTypes = (int[])decompTypes.clone();
        this._localShape = (int[])lengths.clone();
        this._localShape[this._pdim] = (int)Decomposition.elementsPerTask(lengths[this._pdim], this._size);
        this._multiArray = new MultiArray(ndim, classType, elementCount, this._localShape);
        if (this._multiArray instanceof MultiArray && type != null) {
            ((MultiArray)this._multiArray).setBackingArrayType(type);
        }
        this._ndim = ndim;
        this._elementCount = elementCount;
        this._classType = classType;
        this.updateShape();
        this._globalArrayLength = MultiArray.arrayLength(ndim, elementCount, this._padShape);
        if (maxLocalArrayLength * (long)this._size > this._globalArrayLength) {
            this._globalArrayLength = maxLocalArrayLength * (long)this._size;
        }
        this._localArrayLength = Decomposition.elementsPerTask(this._globalArrayLength, this._size);
        this._globalArrayLength = this._localArrayLength * (long)this._size;
        if (this._localArrayLength > Integer.MAX_VALUE && this._multiArray instanceof MultiArray && (multiArray = (MultiArray)this._multiArray).getBackingArrayType().equals((Object)BackingArray.Type.JAVA_ARRAY)) {
            multiArray.setBackingArrayType(BackingArray.Type.JAVA_LONG_ARRAY);
        }
        this._multiArray.allocate(this._localArrayLength);
    }

    @Override
    public void setShape(int[] newLengths) {
        this.setShape(this._elementCount, newLengths);
    }

    public void setShape(int elementCount, int[] newLengths) {
        if (DistributedArray.getShapeLength(this._ndim, elementCount, newLengths) > this._globalArrayLength) {
            throw new RuntimeException("New shape exceeds available storage: " + Arrays.toString(this._globalShape) + " -> " + Arrays.toString(newLengths));
        }
        ArrayUtil.arraycopy(newLengths, 0, this._globalShape, 0, this._ndim);
        this._elementCount = elementCount;
        this.updateShape();
    }

    private void updateShape() {
        Decomposition decomp = new Decomposition(this._decompTypes[this._pdim], this._globalShape[this._pdim], this._parallelContext);
        this._localShape = (int[])this._globalShape.clone();
        this._padShape = (int[])this._globalShape.clone();
        for (int i = 0; i < this._ndim; ++i) {
            if (this._decompTypes[i] == NONE) continue;
            this._padShape[i] = (int)Decomposition.paddedLength(this._globalShape[i], this._size);
        }
        this._parDecomp = decomp;
        this._np = decomp.getPaddedLength();
        this._npn = decomp.getElementsPerTask();
        this._nlive = decomp.getLiveElements();
        this._decomp = decomp.getDecompType();
        this._localShape[this._pdim] = this._npn;
        this._multiArray.setElementCount(this._elementCount);
        this._multiArray.setShape(this._localShape);
        this._localShape[this._pdim] = this._nlive;
    }

    public void printShape(String title) {
        this._parallelContext.masterPrint("DistributedArray.printShape: " + title);
        this._parallelContext.serialPrint(this._rank + ": elementCount " + this._elementCount);
        this._parallelContext.serialPrint(this._rank + ":  globalShape " + Arrays.toString(this._globalShape));
        this._parallelContext.serialPrint(this._rank + ":  decompTypes " + Arrays.toString(this._decompTypes));
        this._parallelContext.serialPrint(this._rank + ":     padShape " + Arrays.toString(this._padShape));
        this._parallelContext.serialPrint(this._rank + ":   localShape " + Arrays.toString(this._localShape));
        this._parallelContext.serialPrint(this._rank + ":   multiShape " + Arrays.toString(this._multiArray.getShape()));
        this._parallelContext.serialPrint(this._rank + ":    bufLength " + this._multiArray.getBufferLength());
    }

    public void matchLocalShape() {
        int[] len = this._multiArray.getShape();
        if (len[this._pdim] != this._localShape[this._pdim]) {
            throw new RuntimeException(String.format("Global shape change conflicts with local shape request (%d vs. %d)", len[this._pdim], this._localShape[this._pdim]));
        }
        for (int i = 0; i < this._ndim - 1; ++i) {
            this._globalShape[i] = len[i];
        }
        this.updateShape();
    }

    @Override
    public int[] getShape() {
        return (int[])this._globalShape.clone();
    }

    public int[] getLocalShape() {
        int[] localShape = new int[this.getDimensions()];
        for (int i = 0; i < localShape.length; ++i) {
            localShape[i] = this.getLocalLength(i);
        }
        return localShape;
    }

    public int[] getTransposeShape() {
        return (int[])this._padShape.clone();
    }

    @Override
    public void reshape(int[] lengths) {
        this.reshape(this._elementCount, lengths);
    }

    public void reShape(int[] lengths) {
        this.reshape(lengths);
    }

    @Override
    public void reshape(int elementCount, int[] lengths) {
        int[] currentShape;
        boolean chatty = false;
        if (elementCount == this.getElementCount()) {
            currentShape = this.getShape();
            boolean needReshape = false;
            for (int i = 0; i <= this._pdim; ++i) {
                if (currentShape[i] == lengths[i]) continue;
                needReshape = true;
                break;
            }
            if (!needReshape) {
                return;
            }
        }
        if (this._globalArrayLength < DistributedArray.getShapeLength(this._ndim, elementCount, lengths)) {
            throw new RuntimeException("DistributedArray Length is too short for new shape\n Requested shape: " + Arrays.toString(lengths) + "\n" + " Current shape  : " + Arrays.toString(this._globalShape) + "\n" + " BackingArray length = " + this._globalArrayLength + "\n" + " Requested Length    = " + DistributedArray.getShapeLength(this._ndim, elementCount, lengths));
        }
        if (chatty) {
            this._parallelContext.serialPrint("DistributedArray.reshape on input1:\n Current shape   : " + Arrays.toString(this._globalShape) + "\n" + " Current length  : " + this._globalArrayLength + "\n" + " Requested shape : " + Arrays.toString(lengths) + "\n" + " Requested Length: " + DistributedArray.getShapeLength(this._ndim, elementCount, lengths));
        }
        this.reshapeInner(elementCount, lengths);
        if (chatty) {
            this._parallelContext.serialPrint("Shape after Reshape1: " + Arrays.toString(this._globalShape));
        }
        if ((currentShape = this.getShape())[this._pdim] == lengths[this._pdim] && currentShape[this._pdim - 1] == lengths[this._pdim - 1]) {
            return;
        }
        this.transposeOuter();
        if (chatty) {
            this._parallelContext.serialPrint("Shape after Trans1  : " + Arrays.toString(this._globalShape));
        }
        int[] len = (int[])lengths.clone();
        len[this._pdim - 1] = lengths[this._pdim];
        len[this._pdim] = lengths[this._pdim - 1];
        this.reshapeInner(elementCount, len);
        if (chatty) {
            this._parallelContext.serialPrint("Shape after Reshape2: " + Arrays.toString(this._globalShape));
        }
        this.transposeOuter();
        if (chatty) {
            this._parallelContext.serialPrint("Shape after Trans2  : " + Arrays.toString(this._globalShape));
        }
        this.reshapeInner(elementCount, lengths);
        this.setShape(lengths);
        if (chatty) {
            this._parallelContext.serialPrint("Shape after Reshape3: " + Arrays.toString(this._globalShape));
        }
    }

    public void reshapeInner(int elementCount, int[] lengths) {
        boolean same = true;
        if (elementCount != this._elementCount) {
            same = false;
        }
        for (int i = 0; i < this._ndim - 1; ++i) {
            if (lengths[i] == this._globalShape[i]) continue;
            same = false;
        }
        if (same) {
            return;
        }
        int[] len = (int[])lengths.clone();
        len[this._pdim] = this._multiArray.getLength(this._pdim);
        this._multiArray.reshape(elementCount, len);
        this._elementCount = elementCount;
        len[this._pdim] = this._globalShape[this._pdim];
        this.setShape(len);
    }

    public void printContents() {
        System.out.println("\nFor DistributedArray " + this.toString());
        System.out.println("  parallel dimension= " + this._pdim);
        System.out.println("  classType= " + this._multiArray.getClassType());
        System.out.println("  elementCount= " + this._multiArray.getElementCount());
        System.out.println("  bufferLength= " + this._multiArray.getBufferLength());
        int[] globalShape = this.getShape();
        for (int i = 0; i < globalShape.length; ++i) {
            System.out.println("  globalShape[" + i + "]=" + globalShape[i]);
        }
        int[] localShape = this.getLocalShape();
        for (int i = 0; i < localShape.length; ++i) {
            System.out.println("  " + this._parallelContext.rank() + " localShape[" + i + "]=" + localShape[i]);
        }
        System.out.println("Backing array contents:");
        System.out.println(this.getBackingArray().toString());
        System.out.flush();
    }

    public static int[] getTransposeShape(IParallelContext pc, int ndim, int[] lengths, int[] decompTypes) {
        int[] padShape = new int[ndim];
        int size = pc.size();
        for (int i = 0; i < ndim; ++i) {
            padShape[i] = decompTypes[i] != NONE ? (int)Decomposition.paddedLength(lengths[i], size) : lengths[i];
        }
        return padShape;
    }

    public static long getShapeLength(int ndim, int elementCount, int[] shape) {
        long length = elementCount;
        for (int i = 0; i < ndim; ++i) {
            length *= (long)shape[i];
        }
        return length;
    }

    public IParallelContext getParallelContext() {
        return this._parallelContext;
    }

    public Decomposition getParallelDecomposition() {
        return this._parDecomp;
    }

    public int getParallelDimension() {
        return this._pdim + 1;
    }

    public int[] getDecompTypes() {
        return this._decompTypes;
    }

    public long index(int[] position) {
        long offset = 0L;
        for (int i = this._ndim - 2; i >= 0; --i) {
            offset += (long)this._offsetMultiplier[i] * (long)position[i];
        }
        int il = this.globalToLocal(this._pdim, position[this._pdim]);
        return offset += (long)this._offsetMultiplier[this._pdim] * (long)il;
    }

    public long index(int[] position, int element) {
        return this.index(position) + (long)element;
    }

    public int localToGlobal(int dimension, int index) {
        int iret = 0;
        if (dimension < this._pdim) {
            return index;
        }
        if (this._decomp == BLOCK) {
            iret = index + this._npn * this._rank;
        } else if (this._decomp == CIRCULAR) {
            iret = this._rank + index * this._size;
        }
        return iret;
    }

    public int globalToLocal(int dimension, int index) {
        if (dimension < this._pdim) {
            return index;
        }
        if (this._decomp == BLOCK) {
            return index - this._npn * this._rank;
        }
        return index / this._size;
    }

    public int[] localPosition(int[] position) {
        int[] pos = (int[])position.clone();
        int ipos = 0;
        if (this._decomp == BLOCK) {
            ipos = position[this._pdim] - this._npn * this._rank;
        } else if (this._decomp == CIRCULAR) {
            ipos = position[this._pdim] / this._size;
        }
        assert (ipos >= 0 && ipos < this._localShape[this._pdim]) : "\n  position out of range: " + Arrays.toString(position) + " for _localShape: " + Arrays.toString(this._localShape) + " \n  _rank " + this._rank + " _np " + this._np + " _npn " + this._npn + " _nlive " + this._nlive;
        pos[this._pdim] = ipos;
        return pos;
    }

    @Override
    public int getLength(int index) {
        return this._globalShape[index];
    }

    public int getLocalLength(int index) {
        assert (index >= 0 && index < this._ndim) : "index out of range";
        if (index == this._pdim) {
            return this._nlive;
        }
        return this._globalShape[index];
    }

    public int getGlobalLength(int index) {
        if (index == this._pdim) {
            return this._np;
        }
        return this._multiArray.getLength(index);
    }

    public void tran132() {
        this.transpose(TransposeType.T132);
    }

    public void tran213() {
        this.transpose(TransposeType.T213);
    }

    @Override
    public void transpose(TransposeType type) {
        switch (type) {
            case T12: 
            case T123: 
            case T1234: {
                break;
            }
            case T21: 
            case T2134: {
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                break;
            }
            case T213: {
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                break;
            }
            case T132: {
                this.transposeOuter();
                break;
            }
            case T231: {
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                this.transposeOuter();
                break;
            }
            case T312: {
                this.transposeOuter();
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                break;
            }
            case T321: {
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                this.transposeOuter();
                this._multiArray.transpose(TransposeType.T21);
                this.matchLocalShape();
                break;
            }
            case T1324: {
                this._multiArray.transpose(TransposeType.T132);
                this.matchLocalShape();
                break;
            }
            case T1342: {
                this._multiArray.transpose(TransposeType.T132);
                this.matchLocalShape();
                this.transposeOuter();
                break;
            }
            case T1243: {
                this.transposeOuter();
                break;
            }
            case T1423: {
                this.transposeOuter();
                this._multiArray.transpose(TransposeType.T132);
                this.matchLocalShape();
                break;
            }
            case T4231: {
                this._multiArray.transpose(TransposeType.T231);
                this.matchLocalShape();
                this.transposeOuter();
                this._multiArray.transpose(TransposeType.T312);
                this.matchLocalShape();
                break;
            }
        }
    }

    public void transposeOuter() {
        boolean reshape;
        if (this._ndim < 2) {
            throw new UnsupportedOperationException("DistributedArray.transposeOuter requires 2 or more dimensions");
        }
        int p = this._size;
        int[] oldShape = (int[])this._globalShape.clone();
        int[] newShape = (int[])this._globalShape.clone();
        newShape[this._pdim] = oldShape[this._pdim - 1];
        newShape[this._pdim - 1] = oldShape[this._pdim];
        boolean bl = reshape = this._padShape[this._pdim - 1] != this._globalShape[this._pdim - 1] || this._padShape[this._pdim] != this._globalShape[this._pdim];
        if (reshape) {
            int[] tmpShape = (int[])oldShape.clone();
            tmpShape[this._pdim - 1] = this._padShape[this._pdim - 1];
            tmpShape[this._pdim] = this._padShape[this._pdim];
            this.reshapeInner(this._elementCount, tmpShape);
            this.setShape(tmpShape);
        }
        int n1 = 1;
        for (int i = 0; i < this._ndim - 2; ++i) {
            n1 *= this._globalShape[i];
        }
        int n2 = this._padShape[this._pdim - 1];
        int n2p = n2 / p;
        int n3 = this._padShape[this._pdim];
        int n3p = n3 / p;
        final long nts = 1L * (long)n1 * (long)n2p * (long)n3p * (long)this._elementCount;
        int n12p = n1 * n2p;
        int[] len1 = new int[]{n12p, p, n3p};
        int[] len2 = new int[]{n1, n2p, n3};
        IMultiArray b = this._multiArray.view(3, this._classType, this._elementCount, len1);
        Transpose.transpose132(b);
        if (b.getBackingArray().getBackingArrayType() == BackingArray.Type.JAVA_LONG_ARRAY) {
            final LongArrayStorage input = (LongArrayStorage)b.getBackingArray();
            Serializable[] tiles = new LongArrayStorage[this._size];
            for (int i = 0; i < this._size; ++i) {
                IBackingArray iba = LongArrayStorage.view(input, nts, nts * (long)i);
                tiles[i] = (LongArrayStorage)iba;
                LOG.finer("i=" + i + " offset = " + ((LongArrayStorage)tiles[i]).getOffset() + " length = " + ((LongArrayStorage)tiles[i]).getLength());
            }
            Serializable[] buf = new LongArrayStorage[1];
            IParallelContext.TileProcesssor tp = new IParallelContext.TileProcesssor(){

                @Override
                public void processTile(int offset, Serializable tile) {
                    LongArrayStorage t = (LongArrayStorage)tile;
                    Class<?> className = t.getClassType();
                    if (className.equals(Byte.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            byte value = t.getByte(j);
                            input.putByte(value, (long)offset * nts + j);
                        }
                    } else if (className.equals(Short.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            short value = t.getShort(j);
                            input.putShort(value, (long)offset * nts + j);
                        }
                    } else if (className.equals(Integer.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            int value = t.getInt(j);
                            input.putInt(value, (long)offset * nts + j);
                        }
                    } else if (className.equals(Float.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            float value = t.getFloat(j);
                            input.putFloat(value, (long)offset * nts + j);
                        }
                    } else if (className.equals(Long.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            long value = t.getLong(j);
                            input.putLong(value, (long)offset * nts + j);
                        }
                    } else if (className.equals(Double.TYPE)) {
                        for (long j = 0L; j < nts; ++j) {
                            double value = t.getDouble(j);
                            input.putDouble(value, (long)offset * nts + j);
                        }
                    } else {
                        throw new UnsupportedOperationException("class type " + className + " is not supported");
                    }
                }

                @Override
                public void tileSent(int index) {
                    throw new AssertionError((Object)"This method is never called.");
                }
            };
            this._parallelContext.ttranIncremental(tiles, buf, tp);
        } else if (b.getBackingArray().getBackingArrayType() == BackingArray.Type.JAVA_ARRAY) {
            if (nts > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Tile size exceeds Integer.MAX_VALUE");
            }
            this._parallelContext.ttran((int)nts, b.getBackingArray());
        } else {
            throw new UnsupportedOperationException("Backing array type " + (Object)((Object)b.getBackingArray().getBackingArrayType()) + " is not currently supported");
        }
        b = this._multiArray.view(3, this._classType, this._elementCount, len2);
        Transpose.transpose132(b);
        int tmp = this._globalShape[this._pdim];
        this._globalShape[this._pdim] = this._globalShape[this._pdim - 1];
        this._globalShape[this._pdim - 1] = tmp;
        tmp = this._decompTypes[this._pdim];
        this._decompTypes[this._pdim] = this._decompTypes[this._pdim - 1];
        this._decompTypes[this._pdim - 1] = tmp;
        this.updateShape();
        if (reshape) {
            this.reshapeInner(this._elementCount, newShape);
            this.setShape(newShape);
        }
    }

    @Override
    public void allocate(long maxLength) {
        this._multiArray.allocate(maxLength);
    }

    @Override
    public void allocate() {
        this._multiArray.allocate();
    }

    public void zeroCompletely() {
        IBackingArray a = this.getBackingArray();
        Class cls = this.getClassType();
        if (cls == Byte.TYPE) {
            a.fill((byte)0, 0L, 1L, a.getBackingArrayLength());
        } else if (cls == Integer.TYPE) {
            a.fill(0, 0L, 1L, a.getBackingArrayLength());
        } else if (cls == Long.TYPE) {
            a.fill(0L, 0L, 1L, a.getBackingArrayLength());
        } else if (cls == Float.TYPE) {
            a.fill(0.0f, 0L, 1L, a.getBackingArrayLength());
        } else if (cls == Double.TYPE) {
            a.fill(0.0, 0L, 1L, a.getBackingArrayLength());
        } else {
            throw new IllegalArgumentException("can't handle class type " + cls);
        }
    }

    @Override
    public <T> void fill(T value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(byte value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(short value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(int value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(long value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(float value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public void fill(double value, int[] position, int count) {
        this._multiArray.fill(value, this.localPosition(position), count);
    }

    @Override
    public IBackingArray getBackingArray() {
        return this._multiArray.getBackingArray();
    }

    @Override
    public long getBufferLength() {
        return this._multiArray.getBufferLength() * (long)this._size;
    }

    @Override
    public byte getByte(int[] position, int element) {
        return this._multiArray.getByte(this.localPosition(position), element);
    }

    @Override
    public byte getByte(int[] position) {
        return this._multiArray.getByte(this.localPosition(position));
    }

    @Override
    public Class getClassType() {
        return this._multiArray.getClassType();
    }

    @Override
    public int getDimensions() {
        return this._multiArray.getDimensions();
    }

    @Override
    public double getDouble(int[] position, int element) {
        return this._multiArray.getByte(this.localPosition(position), element);
    }

    @Override
    public double getDouble(int[] position) {
        return this._multiArray.getByte(this.localPosition(position));
    }

    @Override
    public int getElementCount() {
        return this._multiArray.getElementCount();
    }

    @Override
    public float getFloat(int[] position, int element) {
        return this._multiArray.getFloat(this.localPosition(position), element);
    }

    @Override
    public float getFloat(int[] position) {
        return this._multiArray.getFloat(this.localPosition(position));
    }

    @Override
    public <T> void getFrame(T[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(byte[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(short[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(int[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(float[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(long[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(double[][] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public <T> void getFrame(T[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(byte[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(short[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(int[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(float[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(long[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public void getFrame(double[] buf, int[] position) {
        this._multiArray.getFrame(buf, this.localPosition(position));
    }

    @Override
    public int getInt(int[] position, int element) {
        return this._multiArray.getInt(this.localPosition(position), element);
    }

    @Override
    public int getInt(int[] position) {
        return this._multiArray.getInt(this.localPosition(position));
    }

    @Override
    public long getLong(int[] position, int element) {
        return this._multiArray.getInt(this.localPosition(position), element);
    }

    @Override
    public long getLong(int[] position) {
        return this._multiArray.getLong(this.localPosition(position));
    }

    @Override
    public <T> T getObject(int[] position, int element) {
        return this._multiArray.getObject(this.localPosition(position), element);
    }

    @Override
    public <T> T getObject(int[] position) {
        return this._multiArray.getObject(this.localPosition(position));
    }

    @Override
    public <T> void getSample(T[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(byte[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(short[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(int[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(long[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(float[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public void getSample(double[] buf, int[] position) {
        this._multiArray.getSample(buf, this.localPosition(position));
    }

    @Override
    public short getShort(int[] position, int element) {
        return this._multiArray.getShort(this.localPosition(position), element);
    }

    @Override
    public short getShort(int[] position) {
        return this._multiArray.getShort(this.localPosition(position));
    }

    public void getSubTrace(float[] buf, int[] position, int offset, int length) {
        MultiArray a = (MultiArray)this._multiArray;
        a.getSubTrace(buf, this.localPosition(position), offset, length);
    }

    @Override
    public <T> void getTrace(T[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(byte[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(short[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(int[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(float[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(long[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public void getTrace(double[] buf, int[] position) {
        this._multiArray.getTrace(buf, this.localPosition(position));
    }

    @Override
    public <T> void putFrame(T[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(byte[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(short[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(int[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(float[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(long[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(double[] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public <T> void putFrame(T[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(byte[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(short[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(int[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(float[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(long[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public void putFrame(double[][] buf, int[] position) {
        this._multiArray.putFrame(buf, this.localPosition(position));
    }

    @Override
    public <T> void putSample(T[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(byte[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(short[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(int[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(long[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(float[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(double[] buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public <T> void putSample(T buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(byte buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(short buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(int buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(long buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(float buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public void putSample(double buf, int[] position, int element) {
        this._multiArray.putSample(buf, this.localPosition(position), element);
    }

    @Override
    public <T> void putSample(T buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(byte buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(short buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(int buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(long buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public void putSample(float buf, int[] position) {
        int[] pos = this.localPosition(position);
        if (pos[this._pdim] < 0 || pos[this._pdim] >= this._localShape[this._pdim]) {
            throw new RuntimeException("Position " + Arrays.toString(pos) + " Out of range " + Arrays.toString(this._localShape));
        }
        this._multiArray.putSample(buf, pos);
    }

    @Override
    public void putSample(double buf, int[] position) {
        this._multiArray.putSample(buf, this.localPosition(position));
    }

    @Override
    public <T> void putTrace(T[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(byte[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(short[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(int[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(float[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(long[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void putTrace(double[] buf, int[] position) {
        this._multiArray.putTrace(buf, this.localPosition(position));
    }

    @Override
    public void setBackingArray(IBackingArray buf) {
        this._multiArray.setBackingArray(buf);
    }

    @Override
    public void setClassType(Class classType) {
        this._multiArray.setClassType(classType);
        this._classType = classType;
    }

    @Override
    public void setDimensions(int ndim) {
        this._multiArray.setDimensions(ndim);
        this._ndim = ndim;
    }

    @Override
    public void setElementCount(int elementCount) {
        this._multiArray.setElementCount(elementCount);
        this._elementCount = elementCount;
    }

    public DistributedArray distributedView() {
        DistributedArray aView = new DistributedArray(this._multiArray.view(), this._parallelContext);
        return aView;
    }

    @Override
    public IMultiArray view() {
        return new DistributedArray(this._multiArray.view(), this._parallelContext);
    }

    @Override
    public IMultiArray view(int ndim, int[] position) {
        return new DistributedArray(this._multiArray.view(ndim, position), this._parallelContext);
    }

    @Override
    public IMultiArray view(int ndim, Class classType, int elementCount, int[] lengths) {
        return new DistributedArray(this._multiArray.view(ndim, classType, elementCount, lengths), this._parallelContext);
    }

    public IMultiArray getMultiArray() {
        return this._multiArray;
    }

    public static int makeLegalForTranspose(int len, int numTasks) {
        int rem = len % numTasks;
        if (rem == 0) {
            return len;
        }
        return len + numTasks - rem;
    }

    public void makeLegalForTranspose() {
        int numTasks = this.getParallelContext().size();
        if (numTasks == 1) {
            return;
        }
        int[] shape = this.getShape();
        int ndim = this.getDimensions();
        for (int i = 0; i < ndim; ++i) {
            int rem = shape[i] % numTasks;
            if (rem == 0) continue;
            shape[i] = shape[i] + numTasks - rem;
        }
        this.reshape(shape);
    }

    @Override
    public long getFrameLength() {
        return 0L;
    }

    @Override
    public long getHypercubeLength() {
        return 0L;
    }

    @Override
    public long getOffset(int[] position) {
        return 0L;
    }

    @Override
    public long getTotalFrameCount() {
        return 0L;
    }

    @Override
    public long getTotalHypercubeCount() {
        return 0L;
    }

    @Override
    public long getTotalSampleCount() {
        return 0L;
    }

    @Override
    public long getTotalTraceCount() {
        return 0L;
    }

    @Override
    public long getTotalVolumeCount() {
        return 0L;
    }

    @Override
    public long getVolumeLength() {
        return 0L;
    }

    public void getSubArray(int[] ipos, int[] size, float[] subarray) {
        IBackingArray ia = this.getBackingArray();
        ArrayStorage ib = new ArrayStorage(subarray);
        long woff = 0L;
        long ioff = 0L;
        long count = size[0];
        int[] pos = new int[3];
        for (int k = 0; k < size[2]; ++k) {
            pos[2] = ipos[2] + k;
            for (int j = 0; j < size[1]; ++j) {
                pos[1] = ipos[1] + j;
                ioff = this.getOffset(pos);
                ib.arraycopy(ia, ioff, ib, woff, count);
                woff += count;
            }
        }
    }
}

