/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.nio.ByteOrder;
import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javaseis.io.TraceMap;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class JTestTraceMap
extends TestCase {
    public void test3D() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test3D(3L, folder, "w");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 12L ? 1 : 0) != 0);
        this.test3D(3L, folder, "wb");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 12L ? 1 : 0) != 0);
    }

    public void test4D() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test4D(5L, 3L, folder, "w");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 60L ? 1 : 0) != 0);
        this.test4D(5L, 3L, folder, "wb");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 60L ? 1 : 0) != 0);
    }

    public void test5D() throws SeisException {
        String folder = TestUtil.getFolder("TestMap-Test");
        this.test5D(2L, 5L, 3L, folder, "w");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 120L ? 1 : 0) != 0);
        this.test5D(2L, 5L, 3L, folder, "wb");
        JTestTraceMap.assertTrue((JTestTraceMap.getSizeAndRemove(folder) == 120L ? 1 : 0) != 0);
    }

    private void test5D(long nHyperCubes, long nVolumes, long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int ifrm;
        int ivol;
        int numDiminsions = 5;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[4] = nHyperCubes;
        axisLengths[3] = nVolumes;
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        int ihcube = 0;
        while ((long)ihcube < nHyperCubes) {
            ivol = 0;
            while ((long)ivol < nVolumes) {
                ifrm = 0;
                while ((long)ifrm < nFrames) {
                    fold = ihcube + ivol + ifrm;
                    position[4] = ihcube;
                    position[3] = ivol;
                    position[2] = ifrm++;
                    tm.putFold(position, fold);
                    int foldReturned = tm.getFold(position);
                    JTestTraceMap.assertEquals((int)fold, (int)foldReturned);
                }
                ++ivol;
            }
            ++ihcube;
        }
        tm.close();
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        ihcube = 0;
        while ((long)ihcube < nHyperCubes) {
            ivol = 0;
            while ((long)ivol < nVolumes) {
                ifrm = 0;
                while ((long)ifrm < nFrames) {
                    position[4] = ihcube;
                    position[3] = ivol;
                    position[2] = ifrm;
                    fold = tm.getFold(position);
                    JTestTraceMap.assertTrue((fold == ihcube + ivol + ifrm ? 1 : 0) != 0);
                    ++ifrm;
                }
                ++ivol;
            }
            ++ihcube;
        }
        System.out.println("SUCCESS 5D");
    }

    private void test4D(long nVolumes, long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int ifrm;
        int numDiminsions = 4;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[3] = nVolumes;
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        int ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                fold = ivol + ifrm;
                position[3] = ivol;
                position[2] = ifrm++;
                tm.putFold(position, fold);
                int foldReturned = tm.getFold(position);
                JTestTraceMap.assertEquals((int)fold, (int)foldReturned);
            }
            ++ivol;
        }
        tm.close();
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        ivol = 0;
        while ((long)ivol < nVolumes) {
            ifrm = 0;
            while ((long)ifrm < nFrames) {
                position[3] = ivol;
                position[2] = ifrm;
                fold = tm.getFold(position);
                JTestTraceMap.assertTrue((fold == ivol + ifrm ? 1 : 0) != 0);
                ++ifrm;
            }
            ++ivol;
        }
        System.out.println("SUCCESS 4D");
    }

    private void test3D(long nFrames, String path, String writeMode) throws SeisException {
        int fold;
        int numDiminsions = 3;
        long[] axisLengths = new long[numDiminsions];
        axisLengths[2] = nFrames;
        int[] position = new int[numDiminsions];
        Arrays.fill(position, 0);
        TraceMap tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, writeMode);
        tm.intializeTraceMapOnDisk();
        int ifrm = 0;
        while ((long)ifrm < nFrames) {
            fold = ifrm;
            position[2] = ifrm++;
            tm.putFold(position, fold);
            int foldReturned = tm.getFold(position);
            JTestTraceMap.assertEquals((int)fold, (int)foldReturned);
        }
        ifrm = 0;
        while ((long)ifrm < nFrames) {
            position[2] = ifrm;
            fold = tm.getFold(position);
            JTestTraceMap.assertTrue((fold == ifrm ? 1 : 0) != 0);
            int[] position4 = new int[4];
            Arrays.fill(position4, -1);
            position4[2] = position[2];
            int fold4 = tm.getFold(position4);
            JTestTraceMap.assertTrue((fold4 == ifrm ? 1 : 0) != 0);
            int[] position5 = new int[5];
            Arrays.fill(position5, -1);
            position5[2] = position[2];
            int fold5 = tm.getFold(position5);
            JTestTraceMap.assertTrue((fold5 == ifrm ? 1 : 0) != 0);
            ++ifrm;
        }
        tm.close();
        tm = new TraceMap(axisLengths, ByteOrder.LITTLE_ENDIAN, path, "r");
        ifrm = 0;
        while ((long)ifrm < nFrames) {
            position[2] = ifrm;
            fold = tm.getFold(position);
            JTestTraceMap.assertTrue((fold == ifrm ? 1 : 0) != 0);
            ++ifrm;
        }
        System.out.println("SUCCESS 3D");
    }

    private static long getSizeAndRemove(String path) {
        File f = new File(path, "TraceMap");
        if (!f.exists()) {
            return -1L;
        }
        long size = f.length();
        f.delete();
        return size;
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run(JTestTraceMap.class);
    }
}

