/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import org.javaseis.array.beta.DecompositionType;

public class ParallelDecomposition {
    private DecompositionType type;
    private long numElements;
    private int elementsPerTask;
    private int liveElements;
    private int[] indexRange;
    private final int size;
    private final int rank;

    public ParallelDecomposition(DecompositionType type, long numElements, int numTasks, int taskNumber) {
        if (numElements < 1L) {
            throw new IllegalArgumentException("numElements is invalid " + numElements);
        }
        if (numTasks < 1) {
            throw new IllegalArgumentException("numTasks is invalid " + numTasks);
        }
        if (taskNumber < 0) {
            throw new IllegalArgumentException("taskNumber is invalid " + taskNumber);
        }
        if (type == DecompositionType.BLOCK) {
            this.setBlockDecomp(numElements, numTasks, taskNumber);
        } else {
            this.setCircularDecomp(numElements, numTasks, taskNumber);
        }
        this.size = numTasks;
        this.rank = taskNumber;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DecompositionType = " + (Object)((Object)this.type));
        buf.append(" number of elements = " + this.numElements + "\n");
        buf.append(" number of elements per task = " + this.elementsPerTask + "\n");
        buf.append(" number of live elements on this task = " + this.liveElements + "\n");
        buf.append(" number of tasks = " + this.size + "\n");
        buf.append(" rank of this task = " + this.rank);
        return buf.toString();
    }

    public ParallelDecomposition(ParallelDecomposition decomp) {
        this.type = decomp.type;
        this.elementsPerTask = decomp.elementsPerTask;
        this.numElements = decomp.numElements;
        this.liveElements = decomp.liveElements;
        this.indexRange = (int[])decomp.indexRange.clone();
        this.size = decomp.size;
        this.rank = decomp.rank;
    }

    private void setBlockDecomp(long numElements, int numTasks, int taskNumber) {
        long nlive;
        long npn;
        long nrem = numElements % (long)numTasks;
        if (nrem > 0L) {
            npn = numElements / (long)numTasks + 1L;
            long nfull = numElements / npn;
            if ((long)taskNumber >= nfull) {
                nlive = numElements - npn * (long)taskNumber;
                if (nlive < 0L) {
                    nlive = 0L;
                }
            } else {
                nlive = npn;
            }
        } else {
            nlive = npn = numElements / (long)numTasks;
            long nfull = numTasks;
        }
        this.type = DecompositionType.BLOCK;
        this.numElements = numElements;
        this.checkOverflow(numElements, npn, numTasks, taskNumber);
        this.elementsPerTask = (int)npn;
        this.liveElements = (int)nlive;
        this.indexRange = new int[3];
        if (nlive > 0L) {
            this.indexRange[0] = (int)(npn * (long)taskNumber);
            this.indexRange[1] = (int)((long)this.indexRange[0] + nlive - 1L);
            this.indexRange[2] = 1;
        } else {
            this.indexRange[0] = 0;
            this.indexRange[1] = -1;
            this.indexRange[2] = 0;
        }
    }

    private void checkOverflow(long numElements, long elementsPerTask, int numTasks, int taskNumber) {
        if (elementsPerTask > Integer.MAX_VALUE) {
            throw new IllegalStateException("Number of elements " + numElements + " and number of tasks " + numTasks + " creates more than Integer.MAX_VALUE number of elements per task");
        }
        if (elementsPerTask * (long)taskNumber > Integer.MAX_VALUE) {
            throw new IllegalStateException("Index range[0] on task " + taskNumber + " will overflow");
        }
    }

    private void setCircularDecomp(long numElements, int numTasks, int taskNumber) {
        long nlive;
        long npn;
        long nrem = numElements % (long)numTasks;
        if (nrem == 0L) {
            nlive = npn = numElements / (long)numTasks;
        } else {
            npn = 1L + numElements / (long)numTasks;
            nlive = (long)taskNumber >= nrem ? npn - 1L : npn;
        }
        this.type = DecompositionType.CIRCULAR;
        this.numElements = numElements;
        this.checkOverflow(numElements, npn, numTasks, taskNumber);
        this.elementsPerTask = (int)npn;
        this.liveElements = (int)nlive;
        this.indexRange = new int[3];
        if (nlive > 0L) {
            this.indexRange[0] = taskNumber;
            this.indexRange[1] = (int)((long)this.indexRange[0] + (nlive - 1L) * (long)numTasks);
            this.indexRange[2] = numTasks;
        } else {
            this.indexRange[0] = 0;
            this.indexRange[1] = 0;
            this.indexRange[2] = 0;
        }
    }

    public DecompositionType getDecompType() {
        return this.type;
    }

    public long getLength() {
        return this.numElements;
    }

    public long getPaddedLength() {
        return this.elementsPerTask * this.size;
    }

    public int getElementsPerTask() {
        return this.elementsPerTask;
    }

    public int getLiveElements() {
        return this.liveElements;
    }

    public int localToGlobal(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Local index value of " + index + " is out of range");
        }
        if (index > this.elementsPerTask - 1) {
            throw new IndexOutOfBoundsException("Local index value of " + index + " is greater than the number of elements per task");
        }
        if (index > this.liveElements - 1) {
            throw new IndexOutOfBoundsException("Local index value of " + index + " is greater than the number of live elements on task " + this.rank);
        }
        int iret = 0;
        if (this.type == DecompositionType.BLOCK) {
            iret = index + this.getElementsPerTask() * this.rank;
        } else if (this.type == DecompositionType.CIRCULAR) {
            iret = this.rank + index * this.size;
        }
        if (iret < 0 || (long)iret > this.numElements) {
            throw new IllegalStateException("Computation of global index at " + index + " returned a value " + iret + " outside the possible range\n" + this.toString());
        }
        return iret;
    }

    public int globalToLocal(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Global index value of " + index + " is out of range\n" + this.toString());
        }
        if ((long)index > this.numElements - 1L) {
            throw new IndexOutOfBoundsException("Global index value of " + index + " is out of range\n" + this.toString());
        }
        if (index < this.indexRange[0]) {
            throw new IndexOutOfBoundsException("Glocal index value of " + index + " is not valid on task = " + this.rank + "\n" + this.toString());
        }
        if (index > this.indexRange[1]) {
            throw new IndexOutOfBoundsException("Glocal index value of " + index + " is not valid on task = " + this.rank + "\n" + this.toString());
        }
        int iret = 0;
        if (this.type == DecompositionType.BLOCK) {
            iret = index - this.getElementsPerTask() * this.rank;
        } else if (this.type == DecompositionType.CIRCULAR) {
            iret = index / this.size;
        }
        return iret;
    }

    public int[] localPosition(int[] globalPosition) {
        int[] localPosition = (int[])globalPosition.clone();
        localPosition[localPosition.length - 1] = this.globalToLocal(globalPosition[globalPosition.length - 1]);
        return localPosition;
    }

    public int[] globalPosition(int[] localPosition) {
        int[] globalPosition = (int[])localPosition.clone();
        globalPosition[localPosition.length - 1] = this.localToGlobal(globalPosition[globalPosition.length - 1]);
        return globalPosition;
    }

    public int getTaskIndex(long elementIndex) {
        if (this.type == DecompositionType.BLOCK) {
            return (int)(elementIndex / (long)this.elementsPerTask);
        }
        if (this.type == DecompositionType.CIRCULAR) {
            return (int)(elementIndex % (long)this.elementsPerTask);
        }
        throw new IllegalStateException("getTaskIndex is not supported for decomposition type " + (Object)((Object)this.type));
    }

    public boolean isGlobalPositionOnTask(int[] globalPosition) {
        int taskIndex = this.getTaskIndex(globalPosition[globalPosition.length - 1]);
        return this.rank == taskIndex;
    }

    public int[] getIndexRange() {
        return (int[])this.indexRange.clone();
    }
}

