/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class Userdata
implements FlexlmConstants,
FlexlmInternalConstants {
    private Feature feature;
    private String userName;
    private String hostName;
    private String display;
    private byte[] checkoutData;
    private int nCheckedOut;
    private long time;
    private String version;
    private long linger;
    private int handle;
    private int flags;
    private boolean isReservation;
    private boolean isUserRes;
    private boolean isHostRes;
    private boolean isDisplayRes;
    private boolean isGroupRes;
    private boolean isHostGroupRes;
    private boolean isInternetRes;
    private boolean isBorrowed;
    private boolean isBundleRes;
    private boolean isProjectRes;
    private boolean isUnknownRes;
    private boolean isQueued;
    private static final int LINGERISBORROW = 1024;

    public Userdata(Feature feature, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, long l, byte[] byArray5, long l2, int n2, int n3) {
        this.feature = feature;
        try {
            if (byArray != null) {
                this.userName = new String(byArray, "ISO-8859-1");
            }
            if (byArray2 != null) {
                this.hostName = new String(byArray2, "ISO-8859-1");
            }
            if (byArray3 != null) {
                this.display = new String(byArray3, "ISO-8859-1");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        this.checkoutData = byArray4;
        this.nCheckedOut = n;
        this.time = l;
        if (byArray5 != null) {
            this.version = new String(byArray5);
        }
        this.linger = l2;
        this.handle = n2;
        this.flags = n3;
        if (this.time == 0L) {
            char c;
            this.isReservation = true;
            try {
                c = this.userName.charAt(0);
                this.userName = this.userName.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(indexOutOfBoundsException.getMessage());
            }
            this.setReservationType(c);
        }
        if (this.nCheckedOut < 0) {
            this.isQueued = true;
            this.nCheckedOut *= -1;
        }
    }

    private void setReservationType(char c) {
        if (c == 'U') {
            this.isUserRes = true;
        } else if (c == 'H') {
            this.isHostRes = true;
        } else if (c == 'D') {
            this.isDisplayRes = true;
        } else if (c == 'G') {
            this.isGroupRes = true;
        } else if (c == 'K') {
            this.isHostGroupRes = true;
        } else if (c == 'I') {
            this.isInternetRes = true;
        } else if (c == 'B') {
            this.isBorrowed = true;
        } else if (c == 'P') {
            this.isProjectRes = true;
        } else if (c == 'L' || c == 'V') {
            this.isBundleRes = true;
        } else {
            this.isUnknownRes = true;
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getUsername() {
        return this.userName;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getHostname() {
        return this.hostName;
    }

    public byte[] getCheckoutData() {
        return this.checkoutData;
    }

    public String getCheckoutDataString() {
        try {
            return this.checkoutData == null ? null : new String(this.checkoutData, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public int getCount() {
        return this.nCheckedOut;
    }

    public Date getCheckoutTime() {
        return new Date(this.time * 1000L);
    }

    public String getVersion() {
        return this.version;
    }

    public long getLinger() {
        return this.linger;
    }

    public int getHandle() {
        return this.handle;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    public boolean isReservation() {
        return this.isReservation;
    }

    public boolean isHostReservation() {
        return this.isHostRes;
    }

    public boolean isUserReservation() {
        return this.isUserRes;
    }

    public boolean isDisplayReservation() {
        return this.isDisplayRes;
    }

    public boolean isGroupReservation() {
        return this.isGroupRes;
    }

    public boolean isInternetReservation() {
        return this.isInternetRes;
    }

    public boolean isUnknownReservation() {
        return this.isUnknownRes;
    }

    public boolean isHostGroupReservation() {
        return this.isHostGroupRes;
    }

    public boolean isLmProjectReservation() {
        return this.isProjectRes;
    }

    public boolean isLingerBorrow() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isBundleReservation() {
        return this.isBundleRes;
    }
}

