#ifndef _JSFILES_H_
#define _JSFILES_H_

#include <jni.h>

#define JSEIS_TYPE 19 /* see trciof77.h */

#ifdef __cplusplus
extern "C" {
#endif

int jsfiles_create                     /* create JSFILES instance         */
  (int *alloc);                        /*   given number of JavaSeisFiles */

int jsfiles_getlun                     /* create a JavaSeisFile - rtn which */
  (const char *filename,               /*   given JavaSeisFile name       */
   const char *rw);                    /*   given rw flag: "r" or "rw"    */

int jsfiles_open                       /* open a JavaSeisFile - rtn ok    */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_close                      /* Close a JavaSeisFile given      */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_isa                        /* return 0 if not a JavaSeisFile  */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_status                     /* return 0 if NORMAL status       */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_message                    /* return JavaSeisWrapper msg size */
  (int which,                          /*   which JavaseisFile            */
   char *mess,                         /*   preallocated array to be popul*/
   int max_size);                      /*   maximum size of given array   */

long jsfiles_gettracecount             /* return trace count              */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_getnumdimensions           /* return number of dimensions     */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_getsamplecount             /* return sample count             */
  (int which);                         /*   which JavaseisFile            */

int jsfiles_gettrace                   /* return size of trace populated  */
  (int which,                          /*   which JavaseisFile            */
   float *trace,                       /*   preallocated array to be popul*/
   int max_size);                      /*   maximum size of given array   */

int jsfiles_puttrace                   /* return no of trac smpls written */
  (int which,                          /*   which JavaseisFile            */
   float *trace,                       /*   trace array to write          */
   int size);                          /*   size of given array           */

int jsfiles_settracenumber             /* return 1 if trace number set    */
  (int which,                          /*   which JavaseisFile            */
   long trace_num);                    /*   which trace number to set     */

int jsfiles_setaxis                    /* return 1 if axis set            */
  (int which,                          /*   which JavaseisFile            */
   int idim,                           /*   which axis (1-rel) to set     */
   int length,                         /*   length of axis                */
   const char *domain,                 /*   axis data domain              */
   const char *units,                  /*   axis data units               */
   long logical_org,                   /*   axis logical origin           */
   long logical_del,                   /*   axis logical delta            */
   double physical_org,                /*   axis physical origin          */
   double physical_del);               /*   axis physical delta           */

int jsfiles_getaxis                    /* return 1 if axis obtained       */
  (int which,                          /*   which JavaseisFile            */
   int idim,                           /*   which axis (1-rel) to set     */
   int *length,                        /*   length of axis                */
   char *domain,                       /*   rtnd axis data domain         */
   char *units,                        /*   rtnd axis data units          */
   long *logical_org,                  /*   rtnd axis logical origin      */
   long *logical_del,                  /*   rtnd axis logical delta       */
   double *physical_org,               /*   rtnd axis physical origin     */
   double *physical_del);              /*   rtnd axis physical delta      */

int jsfiles_addintproperty             /* return 1 if property added      */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   const char *description);           /*   description of property       */

int jsfiles_addfloatproperty           /* return 1 if property added      */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   const char *description);           /*   description of property       */

int jsfiles_adddoubleproperty          /* return 1 if property added      */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   const char *description);           /*   description of property       */

int jsfiles_addlongproperty            /* return 1 if property added      */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   const char *description);           /*   description of property       */

int jsfiles_putintproperty             /* return 1 if property was put    */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   int value);                         /*   value of property             */

int jsfiles_putfloatproperty           /* return 1 if property was put    */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   float value);                       /*   value of property             */

int jsfiles_putdoubleproperty          /* return 1 if property was put    */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   double value);                      /*   value of property             */

int jsfiles_putlongproperty            /* return 1 if property was put    */
  (int which,                          /*   which JavaseisFile            */
   const char *name,                   /*   name of property              */
   long value);                        /*   value of property             */

int jsfiles_getintproperty             /* return property value           */
  (int which,                          /*   which JavaseisFile            */
   const char *name);                  /*   name of property              */

float jsfiles_getfloatproperty         /* return property value           */
  (int which,                          /*   which JavaseisFile            */
   const char *name);                  /*   name of property              */

double jsfiles_getdoubleproperty       /* return property value           */
  (int which,                          /*   which JavaseisFile            */
   const char *name);                  /*   name of property              */

long jsfiles_getlongproperty           /* return property value           */
  (int which,                          /*   which JavaseisFile            */
   const char *name);                  /*   name of property              */

int jsfiles_setdatatype                /* return length of type if set    */
  (int which,                          /*   which JavaseisFile            */
   const char *type);                  /*   data type (e.g."STACK","CMP") */

int jsfiles_getdatatype                /* return length of type of rcvd   */
  (int which,                          /*   which JavaseisFile            */
   char *type,                         /*   data type (e.g."STACK","CMP") */
   size_t max_size);                   /*   maximum size of char array    */

int jsfiles_settraceformat             /* return length of format if set  */
  (int which,                          /*   which JavaseisFile            */
   const char *format);                /*   format (e.g."FLOAT","INT16")  */

int jsfiles_gettraceformat             /* return length of format rcvd    */
  (int which,                          /*   which JavaseisFile            */
   char *format,                       /*   format (e.g."FLOAT","INT16")  */
   size_t max_size);                   /*   maximum size of char array    */

int jsfiles_setbin                     /* return 1 if bin grid set        */
  (int which,                          /*   which JavaseisFile            */
   double *world,                      /*   given world coordinates (6)   */
   double *grid,                       /*   given grid coordinates (4)    */
   long *logical);                     /*   given logical coordinates (8) */

int jsfiles_getbin                     /* return 1 if bin grid obtained   */
  (int which,                          /*   which JavaseisFile            */
   double *world,                      /*   returned world coordinates (6)*/
   double *grid,                       /*   returned grid coordinates (4) */
   long *logical);                     /*   rtnd logical coordinates (8)  */

int jsfiles_remove                     /* return 1 if successful          */
  (int which);                         /*   which JavaseisFile            */

void jsfiles_delete ();                /* delete JSFILES instance         */

#ifdef __cplusplus
}
#endif

#endif
