/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public class HpvDiskSerialId
extends HostId
implements FlexlmConstants {
    private long serialNumber;
    public static final String HOSTID_DISK_SN_KEYWORD = "HPV_DISK_SERIAL_NUM";
    public static final String HOSTID_DISK_SN_KEYWORD2 = "HPV_VSN";

    public HpvDiskSerialId() throws FlexlmException {
        this("HPV_DISK_SERIAL_NUM=fffffff");
    }

    public HpvDiskSerialId(String string) throws FlexlmException {
        int n;
        String string2;
        if (string != null && ((string2 = string.trim()).startsWith("HPV_DISK_SERIAL_NUM=") || string2.startsWith("HPV_VSN=")) && (string2 = string2.substring((n = string2.indexOf("=")) + 1)).length() > 0) {
            try {
                this.serialNumber = Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmException(-503, 2043);
            }
        }
        if (this.serialNumber <= 0L || this.serialNumber >= 0x100000000L) {
            throw new FlexlmException(-503, 2044);
        }
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new HpvDiskSerialId(string);
    }

    @Override
    public boolean isCurrentHost() {
        return false;
    }

    @Override
    public HostId[] getCurrentHostIds() {
        return null;
    }

    @Override
    public String getKeyword() {
        return HOSTID_DISK_SN_KEYWORD;
    }

    @Override
    public int getType() {
        return 145;
    }

    @Override
    public String toString() {
        return this.getKeyword() + "=" + Long.toString(this.serialNumber, 16);
    }

    @Override
    public Object getValue() {
        return new Integer((int)this.serialNumber);
    }

    @Override
    protected int compareValueTo(Object object) {
        int n = (Integer)object;
        int n2 = (Integer)this.getValue();
        if (n2 < n) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }
}

