/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.javaseis.array.JPerfTestShapes;
import org.javaseis.fft.FftNd;
import org.javaseis.fft.IFFT;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayPositionIterator;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.UniprocessorContext;
import org.javaseis.util.MemoryReporter;

public class JPerfTestFftNdLocal {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestFftNdLocal() {
        this(Level.INFO, false);
    }

    public JPerfTestFftNdLocal(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void fftHarness(int fftDimensions, int[] shape, float[] pad) {
        FftNd fnd = new FftNd(fftDimensions, shape, pad, IFFT.Type.REAL);
        UniprocessorContext pc = new UniprocessorContext();
        DistributedArray da = new DistributedArray((IParallelContext)pc, 2, fnd.getForwardShape());
        da.setShape(1, shape);
        int nt = shape[0] * da.getElementCount();
        float[] trc = new float[nt];
        int[] pos = new int[shape.length];
        DistributedArrayPositionIterator dati = new DistributedArrayPositionIterator(da, pos);
        Random r = new Random(12345L);
        while (dati.hasNext()) {
            dati.next();
            for (int i = 0; i < nt; ++i) {
                trc[i] = r.nextFloat();
            }
            da.putTrace(trc, pos);
        }
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < shape.length; ++i) {
            arraySize *= (double)shape[i];
        }
        double startTime = JPerfTestFftNdLocal.getTime();
        fnd.forward(da);
        fnd.inverse(da);
        double elapsedTime = JPerfTestFftNdLocal.getTime() - startTime;
        this.logInfo(fftDimensions + "D FFT Forward/Inverse : size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(shape));
        this.logFine("\nAfter FFT round trip");
        if (this._doChecks) {
            dati.reset();
            r.setSeed(12345L);
            while (dati.hasNext()) {
                dati.next();
                da.getTrace(trc, pos);
                for (int i = 0; i < nt; ++i) {
                    float f1 = trc[i];
                    float f2 = r.nextFloat();
                    if (!(Math.abs(f1 - f2) > 1.0E-6f)) continue;
                    throw new IllegalStateException(Arrays.toString(pos) + " " + f1 + " " + f2 + " " + 1.0E-6f);
                }
            }
        }
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    public static void main(String[] args) {
        int[] newshape;
        int i;
        Boolean memoryPrint = true;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        MemoryReporter memrp = null;
        if (memoryPrint.booleanValue()) {
            memrp = new MemoryReporter();
        }
        JPerfTestFftNdLocal tester = new JPerfTestFftNdLocal(Level.INFO, false);
        tester.logInfo("Org with JTK FFT ");
        float[] pad = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        double startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 1D: " + memrp.getMemoryUsage());
            }
            newshape = new int[]{shapes.get(i)[0], shapes.get(i)[1], shapes.get(i)[2], 1};
            tester.fftHarness(1, newshape, pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 1D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 1D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
        startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 2D: " + memrp.getMemoryUsage());
            }
            newshape = new int[]{shapes.get(i)[0], shapes.get(i)[1], shapes.get(i)[2], 1};
            tester.fftHarness(2, newshape, pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 2D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 2D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
        startTime = JPerfTestFftNdLocal.getTime();
        for (i = 0; i < shapes.size(); ++i) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for 3D: " + memrp.getMemoryUsage());
            }
            newshape = new int[]{shapes.get(i)[0], shapes.get(i)[1], shapes.get(i)[2], 1};
            tester.fftHarness(3, newshape, pad);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for 3D: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
        tester.logInfo("Total time for 3D : " + (JPerfTestFftNdLocal.getTime() - startTime) + " sec");
    }
}

