#!/bin/bash

# First, make sure that we can run a simple "Hello, world" java app:
echo " "
echo "Run hello world app:"
java JavaTestApp

# There is a slim chance that /lib64 is not in the lib path:
export LD_LIBRARY_PATH=/lib64:$LD_LIBRARY_PATH

echo " "
echo "Updated LD_LIBRARY_PATH"
echo $LD_LIBRARY_PATH

# Maybe there is a permissions problem?
echo " "
echo "Show libnsl permissions and soft links"
ls -al /lib64/* | grep libnsl

# SELinux might be restricting access to libraries
# The call to getenforce might return "Enforcing"
echo " "
echo "Call getenforce"
getenforce

# Go ahead and turn off:
echo " "
echo "Call setenforce 0"
setenforce 0

# add verbose output, help track down specific location
echo " "
echo "Call java"
java  -verbose:jni -Xmx8000M -Xms8000M -jar Flatirons.jar
