/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.util;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.DRBG;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public abstract class HmacRandom
extends DRBG
implements Serializable {
    private static final long serialVersionUID = -7122111935914355392L;
    private static boolean a = false;
    private byte[] b = null;
    private byte[] p = null;
    private int q;
    private CryptoTransform r;
    private int s;
    private String t;

    HmacRandom(String string, int n2, long l2) {
        super("HMAC" + string, l2, a);
        if (this.e > n2 / 2) {
            throw new IllegalArgumentException("Invalid security strength value");
        }
        this.r = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "HMAC");
        this.t = string;
        this.s = n2 >> 3;
    }

    void a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.d(byArray, byArray2);
        byArray3 = this.d(byArray3, this.g);
        this.p = new byte[this.s];
        Arrays.fill(this.p, (byte)0);
        this.b = new byte[this.s];
        Arrays.fill(this.b, (byte)1);
        this.c(byArray3);
        this.q = 1;
    }

    void b(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.d(byArray, byArray2);
        this.c(byArray3);
        this.q = 1;
    }

    void c(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new IllegalStateException("buffer is null");
        }
        if (this.q > 0x20000000) {
            this.l = true;
            return;
        }
        if (byArray2 != null) {
            this.c(byArray2);
        }
        byte[] byArray3 = null;
        while (byArray3 == null || byArray3.length < byArray.length) {
            this.b = this.a(this.p, new byte[][]{this.b});
            this.a(this.b);
            byArray3 = this.d(byArray3, this.b);
        }
        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
        this.c(byArray2);
        ++this.q;
    }

    void c(byte[] byArray) {
        this.p = this.a(this.p, new byte[][]{this.b, {0}, byArray});
        this.b = this.a(this.p, new byte[][]{this.b});
        if (byArray != null) {
            this.p = this.a(this.p, new byte[][]{this.b, {1}, byArray});
            this.b = this.a(this.p, new byte[][]{this.b});
        }
    }

    private byte[] a(byte[] byArray, byte[][] byArray2) {
        this.r.init(5, new Object[]{this.t, byArray}, null);
        for (int i2 = 0; i2 < byArray2.length - 1; ++i2) {
            this.r.transform(byArray2[i2], 0, byArray2[i2] == null ? 0 : byArray2[i2].length, false);
        }
        return this.r.transform(byArray2[byArray2.length - 1], 0, byArray2[byArray2.length - 1] == null ? 0 : byArray2[byArray2.length - 1].length, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.p);
        objectOutputStream.writeInt(this.q);
        objectOutputStream.writeObject(this.r);
        objectOutputStream.writeInt(this.s);
        objectOutputStream.writeObject(this.t);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.b = (byte[])objectInputStream.readObject();
        this.p = (byte[])objectInputStream.readObject();
        this.q = objectInputStream.readInt();
        this.r = (CryptoTransform)objectInputStream.readObject();
        this.s = objectInputStream.readInt();
        this.t = (String)objectInputStream.readObject();
    }

    public static final class HmacSHA512Random
    extends HmacRandom
    implements Serializable {
        private static final long serialVersionUID = -570617823890473137L;

        public HmacSHA512Random() {
            super("SHA512", 512, 0x800000000L);
        }
    }

    public static final class HmacSHA384Random
    extends HmacRandom
    implements Serializable {
        private static final long serialVersionUID = 6960186948467732934L;

        public HmacSHA384Random() {
            super("SHA384", 384, 0x800000000L);
        }
    }

    public static final class HmacSHA256Random
    extends HmacRandom
    implements Serializable {
        private static final long serialVersionUID = 943059293293630491L;

        public HmacSHA256Random() {
            super("SHA256", 256, 0x800000000L);
        }
    }

    public static final class HmacSHA224Random
    extends HmacRandom
    implements Serializable {
        private static final long serialVersionUID = -8414525870192793723L;

        public HmacSHA224Random() {
            super("SHA224", 224, 0x800000000L);
        }
    }

    public static final class HmacSHA1Random
    extends HmacRandom
    implements Serializable {
        private static final long serialVersionUID = 6847912916083459135L;

        public HmacSHA1Random() {
            super("SHA-1", 160, 0x800000000L);
        }
    }
}

