/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.Padding;
import com.certicom.ecc.jcae.RNGSpi;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class X923Padding
extends Padding {
    public static final String ALGORITHM_NAME = "X923Padding";
    private SecureRandom b = null;

    public X923Padding(int n2) throws NoSuchPaddingException {
        super(ALGORITHM_NAME, n2);
        if (n2 < 1 || n2 > 255) {
            throw new NoSuchPaddingException("Invalid block size");
        }
        this.b = RNGSpi.a();
    }

    public int pad(byte[] byArray, int n2, int n3) throws ShortBufferException, IllegalBlockSizeException {
        int n4 = this.a - n3 % this.a;
        byte by = (byte)n4;
        if (byArray.length - (n2 += n3) < n4) {
            throw new ShortBufferException("Output buffer too small");
        }
        for (int i2 = 0; i2 < n4 - 1; ++i2) {
            byArray[n2 + i2] = this.b == null ? (byte)0 : (byte)this.b.nextInt();
        }
        byArray[n2 + n4 - 1] = by;
        return n4;
    }

    public int unpad(byte[] byArray, int n2, int n3) throws BadPaddingException, ShortBufferException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = byArray[n2 + n3 - 1] & 0xFF;
        if (n4 < 1 || n4 > this.a) {
            throw new BadPaddingException("Invalid pad size");
        }
        if (n3 < n4) {
            throw new ShortBufferException("Output buffer too small");
        }
        return n4;
    }
}

