/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.AES_XCBC_Mac96Spi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AES_XCBC_Mac128Spi
extends AES_XCBC_Mac96Spi {
    public AES_XCBC_Mac128Spi() {
        this.a = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "XCBC_MAC128");
        this.b = this.a.outputSize(0, true);
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        SecretKey secretKey;
        if (!(key instanceof SecretKey) || !key.getAlgorithm().startsWith("AES")) {
            throw new InvalidKeyException("Invalid key, should be AES instance");
        }
        byte[] byArray = key.getEncoded();
        int n2 = byArray.length;
        if (n2 < 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            Arrays.fill(byArray2, n2, 16, (byte)0);
            secretKey = new SecretKeySpec(byArray2, "AES-128");
        } else if (n2 == 16) {
            secretKey = (SecretKey)key;
        } else {
            Mac mac;
            byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            try {
                mac = Mac.getInstance("AES-XCBC-MAC-128", "Certicom");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidKeyException(noSuchProviderException.getMessage());
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "AES-128");
            mac.init(secretKeySpec);
            byte[] byArray4 = mac.doFinal(key.getEncoded());
            secretKey = new SecretKeySpec(byArray4, "AES-128");
        }
        super.engineInit(secretKey, algorithmParameterSpec);
    }
}

