/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import org.javaseis.io.Seisio;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.TraceProperties;
import org.javaseis.util.SeisException;
import org.javaseis.util.access.FrameBuffer;
import org.javaseis.util.datavolume.VolumeEvaluator;

public class TraceAccessor {
    private Seisio _seisio = null;
    private IParallelContext _pc = null;
    private long[] _lengths = null;
    private int _cur_rank = -1;
    private VolumeEvaluator _vol_eval = null;
    protected boolean _read_write;
    protected long _cur_trace = -1L;
    protected long _cur_frame = -1L;
    protected long _first_trace = -1L;
    protected long _last_trace = -1L;
    protected long _first_frame = -1L;
    protected long _last_frame = -1L;
    protected long _first_trace_in_frame = -1L;
    protected long _last_trace_in_frame = -1L;
    protected int _traces_in_frame = 0;
    protected boolean _work_to_do = false;
    protected FrameBuffer _frame_buffer;
    protected static final long AT_BEG = -1L;
    protected static final long AT_END = 1L;

    public TraceAccessor(Seisio seisio, IParallelContext pc, String io_mode, int frame_count) {
        int size;
        int k2;
        this._seisio = seisio;
        this._pc = pc;
        if (io_mode.equalsIgnoreCase("rw")) {
            this._read_write = true;
        } else if (io_mode.equalsIgnoreCase("r")) {
            this._read_write = false;
        } else {
            throw new RuntimeException("TraceAccessor: invalid rw-" + io_mode);
        }
        this._lengths = this._seisio.getGridDefinition().getAxisLengths();
        if (this._pc != null) {
            for (k2 = this._lengths.length - 1; this._lengths[k2] < 2L && k2 >= 0; --k2) {
            }
            size = ++k2 > 0 ? this._pc.size() : 1;
            this._cur_rank = this._pc.rank();
            if (size == 1 && this._cur_rank != 0) {
                size = 0;
            }
        } else {
            size = 1;
            this._cur_rank = 0;
        }
        if (size != 0) {
            assert (2 < this._lengths.length);
            this._traces_in_frame = (int)this._lengths[1];
            this._vol_eval = new VolumeEvaluator(this._seisio);
            long total = this._vol_eval.getTotal();
            long[] fts = new long[size];
            for (k2 = 0; k2 < size; ++k2) {
                fts[k2] = TraceAccessor.getFirstTraceInFrame(k2, size, this._vol_eval);
            }
            long[] lts = new long[size];
            for (k2 = 1; k2 < size; ++k2) {
                lts[k2 - 1] = fts[k2] - 1L;
            }
            lts[size - 1] = total - 1L;
            if (this._cur_rank > 0 && fts[this._cur_rank] < lts[this._cur_rank - 1]) {
                fts[this._cur_rank] = lts[this._cur_rank - 1] + 1L;
            }
            this._first_trace = fts[this._cur_rank];
            this._last_trace = lts[this._cur_rank];
            boolean bl = this._work_to_do = this._first_trace < this._last_trace;
            if (frame_count < 1) {
                frame_count = 1;
            }
            this._frame_buffer = new FrameBuffer(this, frame_count);
            if (this._work_to_do) {
                this._first_frame = this._first_trace / (long)this._traces_in_frame;
                this._last_frame = this._last_trace / (long)this._traces_in_frame;
            }
        }
    }

    public static int getFrameCount(IParallelContext pc, Seisio seisio) {
        long retval = new VolumeEvaluator(seisio).getLengths()[2];
        if (retval > Integer.MAX_VALUE) {
            throw new RuntimeException("TraceAccessor.getFrameCount: number of frames too big");
        }
        return (int)retval;
    }

    protected void init(long where) {
        this._cur_rank = this._pc != null ? this._pc.rank() : 0;
        if (this._work_to_do) {
            if (where == 1L) {
                this._cur_trace = this._last_trace + 1L;
                this._cur_frame = this._last_frame + 1L;
            } else {
                this._cur_trace = this._first_trace - 1L;
                this._cur_frame = this._first_frame - 1L;
            }
            this.initFrame();
        }
    }

    protected void initFrame() {
        this._first_trace_in_frame = (long)this._traces_in_frame * this._cur_frame;
        this._last_trace_in_frame = this._first_trace_in_frame + (long)this._traces_in_frame - 1L;
    }

    private static long getFirstTraceInFrame(int group, int num_groups, VolumeEvaluator vol_eval) {
        long[] lengths = vol_eval.getLengths();
        int traces_in_frame = (int)lengths[1];
        long total = vol_eval.getTotal();
        long group_total = (long)Math.ceil(total / (long)num_groups);
        long nt = (long)group * group_total;
        long nf = nt / (long)traces_in_frame;
        long retval = nf * (long)traces_in_frame;
        return retval;
    }

    public boolean isReadWrite() {
        return this._read_write;
    }

    public TraceProperties getHeader() {
        TraceProperties retval = this._frame_buffer.getHeader(this._cur_trace);
        return retval;
    }

    public float[] readTrace() throws SeisException {
        float[] retval = null;
        if (this._work_to_do) {
            if (this._traces_in_frame < 1) {
                throw new SeisException("No traces in frame " + this._cur_frame);
            }
            retval = this._frame_buffer.readTrace();
        }
        return retval;
    }

    public int writeTrace(float[] trace) throws SeisException {
        int retval = 0;
        if (this._work_to_do) {
            if (trace == null) {
                throw new SeisException("Trace is null");
            }
            retval = this._frame_buffer.writeTrace(trace);
        }
        return retval;
    }

    public long getFirst() {
        return this._first_trace;
    }

    public long getLast() {
        return this._last_trace;
    }

    public long getCurrent() {
        return this._cur_trace;
    }

    public VolumeEvaluator getVolumeEvaluator() {
        return this._vol_eval;
    }

    public void flush() throws SeisException {
        this._frame_buffer.flush();
    }

    public boolean setIndex(long trace_index) throws SeisException {
        boolean retval;
        if (this._work_to_do) {
            if (trace_index == this._cur_trace) {
                return true;
            }
            retval = this.updateCurrentTraceAndFrame(trace_index);
            if (retval) {
                if (this._cur_trace < this._first_trace_in_frame || this._cur_trace > this._last_trace_in_frame) {
                    if (this._read_write && this._frame_buffer.isFull()) {
                        retval = this.writeOldestFrame();
                    }
                    this.initFrame();
                    this._frame_buffer.setTraceIndex(this._cur_trace);
                    if (this._read_write) {
                        this.readCurrentFrame();
                    } else {
                        retval = this.readCurrentFrame();
                    }
                } else {
                    retval = this._frame_buffer.setTraceIndex(this._cur_trace);
                }
            }
        } else {
            retval = false;
        }
        return retval;
    }

    private boolean updateCurrentTraceAndFrame(long cur_trace) {
        boolean retval;
        if (cur_trace > this._last_trace || cur_trace < this._first_trace) {
            retval = false;
        } else {
            long cur_frame = cur_trace / (long)this._traces_in_frame;
            boolean bl = retval = cur_frame <= this._last_frame;
            if (retval) {
                this._cur_trace = cur_trace;
                this._cur_frame = cur_frame;
            }
        }
        return retval;
    }

    protected boolean readCurrentFrame() throws SeisException {
        boolean retval = this._frame_buffer.readFrame(this._first_trace_in_frame, this._last_trace_in_frame, this._cur_trace) != null;
        return retval;
    }

    protected boolean writeOldestFrame() throws SeisException {
        if (!this._read_write) {
            throw new SeisException("Attempt to write when ReadOnly");
        }
        boolean retval = true;
        int frame_save = this._frame_buffer.getFrameIndex();
        int frame = this._frame_buffer.oldestModifiedFrame();
        this._frame_buffer.setFrameIndex(frame);
        if (this._frame_buffer.couldHaveChanged()) {
            int count = this._frame_buffer.writeFrame();
            retval = count > 0;
        }
        this._frame_buffer.setFrameIndex(frame_save);
        return retval;
    }

    public int[] getSeisioPosition(long index) {
        long[] lengths = this._vol_eval.getLengths();
        long[] pos = this._vol_eval.getPosition(index);
        int[] retval = new int[lengths.length];
        for (int k2 = 1; k2 < lengths.length; ++k2) {
            retval[k2] = (int)pos[k2 - 1];
        }
        retval[0] = 0;
        return retval;
    }

    public Seisio getSeisio() {
        return this._seisio;
    }

    public static long getFirstTraceByteInFrame(int group, int num_groups, VolumeEvaluator vol_eval, DataFormat df) {
        long[] lengths = vol_eval.getLengths();
        int samples_in_trace = (int)lengths[0];
        long retval = (long)samples_in_trace * TraceAccessor.getFirstTraceInFrame(group, num_groups, vol_eval) * (long)df.getBytesPerSample();
        return retval;
    }

    public static long getFirstHeaderByteInFrame(int group, int num_groups, VolumeEvaluator vol_eval, TraceProperties header) {
        int bytes_in_header = header.getRecordLength();
        long retval = (long)bytes_in_header * TraceAccessor.getFirstTraceInFrame(group, num_groups, vol_eval);
        return retval;
    }
}

