/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.javaseis.array.IBackingArray;
import org.javaseis.array.LongArrayStorage;

public class JTestLongArrayStorageIO
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTestLongArrayStorageIO.class.getName());

    public void test1() throws IOException, ClassNotFoundException {
        long size = 512L;
        LongArrayStorage a = this.createData(size);
        String path = this.write(a);
        LongArrayStorage b = this.read(path);
        int i = 0;
        while ((long)i < size) {
            float aValue = a.getFloat(i);
            float bValue = b.getFloat(i);
            assert ((double)Math.abs(aValue - bValue) < 0.001);
            ++i;
        }
        new File(path).deleteOnExit();
        LOG.info("Test 1 completed successfully");
    }

    public void test2() throws IOException, ClassNotFoundException {
        long size = 512L;
        long new_length = 256L;
        long offset = 128L;
        LongArrayStorage a = this.createData(size);
        a.setBufferView(offset, new_length);
        String path = this.write(a);
        LongArrayStorage b = this.read(path);
        int i = 0;
        while ((long)i < new_length) {
            assert ((double)Math.abs(a.getFloat(offset + (long)i) - b.getFloat(i)) < 0.001);
            ++i;
        }
        new File(path).deleteOnExit();
        LOG.info("Test 2 completed successfully");
    }

    public void test3() throws IOException, ClassNotFoundException {
        long size = 512L;
        long new_length = 256L;
        long offset = 128L;
        LongArrayStorage a = this.createData(size);
        IBackingArray ba = a.view(new_length, offset);
        String path = this.write((LongArrayStorage)ba);
        LongArrayStorage b = this.read(path);
        int i = 0;
        while ((long)i < new_length) {
            assert ((double)Math.abs(a.getFloat(offset + (long)i) - b.getFloat(i)) < 0.001);
            ++i;
        }
        new File(path).deleteOnExit();
        LOG.info("Test 3 completed successfully");
    }

    private String write(LongArrayStorage a) throws IOException, FileNotFoundException {
        File f = File.createTempFile("LongArray", "ser");
        FileOutputStream fos = new FileOutputStream(f);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(a);
        out.close();
        fos.close();
        return f.getAbsolutePath();
    }

    private LongArrayStorage read(String path) throws IOException, ClassNotFoundException {
        FileInputStream fileIn = new FileInputStream(path);
        ObjectInputStream in = new ObjectInputStream(fileIn);
        LongArrayStorage a = (LongArrayStorage)in.readObject();
        in.close();
        fileIn.close();
        return a;
    }

    private LongArrayStorage createData(long size) {
        LongArrayStorage s = new LongArrayStorage(Float.TYPE, size);
        float value = new Random(1134L).nextFloat();
        s.fill(value, 0L, 1L, size);
        return s;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        new JTestLongArrayStorageIO().test1();
        new JTestLongArrayStorageIO().test2();
        new JTestLongArrayStorageIO().test3();
    }
}

