/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.properties.AxisDefinition;

public class SocketCommands {
    public static final int GET_DESC_NAME = 101;
    public static final int GET_TRACES = 201;
    public static final int GET_DATA_DIMENSIONS = 301;
    public static final int GET_AXIS_INFO = 401;
    public static final int DISCONNECT = 501;
    public static final int OPEN_DATASET = 701;
    public static final int EXIT = -999;

    public static int getCommand(DataInputStream stream) throws IOException {
        return stream.readInt();
    }

    public static void sendCommand(DataOutputStream stream, int command) throws IOException {
        stream.writeInt(command);
    }

    public static long[] getKeys(int dimensions, DataInputStream in) throws IOException {
        long[] keys = new long[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            keys[i] = in.readLong();
        }
        return keys;
    }

    public static void sendKeys(long[] keys, DataOutputStream out) throws IOException {
        for (int i = 0; i < keys.length; ++i) {
            out.writeLong(keys[i]);
        }
    }

    public static void getTraces(DataInputStream in, DataOutputStream out, float[][] traces) throws IOException {
        long start = System.currentTimeMillis();
        int count = in.readInt();
        long samples = in.readLong();
        if (traces == null || traces.length < count) {
            traces = new float[count][(int)samples];
        } else {
            Arrays.fill((Object[])traces, (Object)0);
        }
        for (int i = 0; i < count; ++i) {
            int j = 0;
            while ((long)j < samples) {
                traces[i][j] = in.readFloat();
                ++j;
            }
        }
        long stop = System.currentTimeMillis();
        double elapse = (double)(stop - start) / 1000.0;
        double amount = (double)((long)count * samples * 32L) / 1048576.0;
        double mbPerSecond = amount / elapse;
        String msg = String.format("%3.2f Mb/Second, Trace count: %d", mbPerSecond, count);
        System.out.println(msg);
    }

    public static void sendTraces(DataInputStream in, DataOutputStream out, float[][] traces, int fold) throws IOException {
        long start = System.currentTimeMillis();
        out.writeInt(fold);
        out.writeLong(traces[0].length);
        for (int i = 0; i < fold; ++i) {
            for (int j = 0; j < traces[0].length; ++j) {
                out.writeFloat(traces[i][j]);
            }
        }
        long stop = System.currentTimeMillis();
        double elapse = (double)(stop - start) / 1000.0;
        double amount = (double)(fold * traces[0].length * 32) / 1048576.0;
        double mbPerSecond = amount / elapse;
        String msg = String.format("%3.2f Mb/Second, Trace count: %d", mbPerSecond, fold);
        System.out.println(msg);
    }

    public static String getDimensionProperties(int dimension, DataInputStream in, DataOutputStream out) throws IOException {
        out.writeInt(dimension);
        long logicalOrigin = in.readLong();
        long logicalCount = in.readLong();
        long logicalInc = in.readLong();
        double physiclOrigin = in.readDouble();
        double physicalDelta = in.readDouble();
        String units = in.readUTF();
        String name = in.readUTF();
        String domain = in.readUTF();
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append(" " + logicalOrigin);
        buf.append(" - " + (logicalOrigin + (logicalCount - 1L) * logicalInc));
        buf.append(" (" + logicalInc + ")");
        buf.append(" Units: " + units);
        buf.append(" Domain: " + domain);
        buf.append(" " + physiclOrigin);
        buf.append(" - " + (physiclOrigin + (double)(logicalCount - 1L) * physicalDelta));
        buf.append(" (" + physicalDelta + ")");
        return buf.toString();
    }

    public static void sendDimensionProperties(DataInputStream in, DataOutputStream out, Seisio seisio) throws IOException {
        int dimension = in.readInt();
        GridDefinition grid = seisio.getGridDefinition();
        AxisDefinition axis = grid.getAxis(dimension);
        long logicalOrigin = axis.getLogicalOrigin();
        long logicalCount = axis.getLength();
        long logicalInc = axis.getLogicalDelta();
        double physiclOrigin = axis.getPhysicalOrigin();
        double physicalDelta = axis.getPhysicalDelta();
        String units = axis.getUnits().getName();
        String name = axis.getLabel().getName();
        String domain = axis.getDomain().getName();
        out.writeLong(logicalOrigin);
        out.writeLong(logicalCount);
        out.writeLong(logicalInc);
        out.writeDouble(physiclOrigin);
        out.writeDouble(physicalDelta);
        out.writeUTF(units);
        out.writeUTF(name);
        out.writeUTF(domain);
    }

    public static String getDatasetPath(DataInputStream in) throws IOException {
        return in.readUTF();
    }

    public static void sendDatasetPath(DataOutputStream out, String path) throws IOException {
        out.writeUTF(path);
    }
}

