/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayIterator;
import org.javaseis.parallel.DistributedArrayPositionIterator;

public class DistributedArrayTraceIterator<E>
implements DistributedArrayIterator<E> {
    private final DistributedArray _distributedArray;
    private final DistributedArrayPositionIterator _positionIterator;
    private final E _trace;
    private int[] _tracePosition;

    public DistributedArrayTraceIterator(DistributedArray distributedArray, E trace) {
        this._distributedArray = distributedArray;
        this._trace = trace;
        this._tracePosition = new int[distributedArray.getDimensions()];
        this._positionIterator = new DistributedArrayPositionIterator(distributedArray, this._tracePosition);
    }

    public DistributedArrayTraceIterator(DistributedArray distributedArray, E trace, int direction) {
        this._distributedArray = distributedArray;
        this._trace = trace;
        this._tracePosition = new int[distributedArray.getDimensions()];
        this._positionIterator = new DistributedArrayPositionIterator(distributedArray, this._tracePosition, direction);
    }

    @Override
    public final boolean hasNext() {
        return this._positionIterator.hasNext();
    }

    @Override
    public E next() {
        this._tracePosition = this._positionIterator.next();
        if (this._trace instanceof float[]) {
            this._distributedArray.getTrace((float[])this._trace, this._tracePosition);
        } else if (this._trace instanceof int[]) {
            this._distributedArray.getTrace((int[])this._trace, this._tracePosition);
        } else if (this._trace instanceof short[]) {
            this._distributedArray.getTrace((short[])this._trace, this._tracePosition);
        } else if (this._trace instanceof double[]) {
            this._distributedArray.getTrace((double[])this._trace, this._tracePosition);
        } else if (this._trace instanceof long[]) {
            this._distributedArray.getTrace((long[])this._trace, this._tracePosition);
        } else if (this._trace instanceof byte[]) {
            this._distributedArray.getTrace((byte[])this._trace, this._tracePosition);
        } else {
            throw new RuntimeException("Data type not recognized");
        }
        return this._trace;
    }

    @Override
    public int[] getPosition() {
        return this._tracePosition;
    }

    public final void putData(E data) {
        if (data instanceof float[]) {
            this._distributedArray.putTrace((float[])data, this._tracePosition);
        } else if (data instanceof int[]) {
            this._distributedArray.putTrace((int[])data, this._tracePosition);
        } else if (data instanceof short[]) {
            this._distributedArray.putTrace((short[])data, this._tracePosition);
        } else if (data instanceof double[]) {
            this._distributedArray.putTrace((double[])data, this._tracePosition);
        } else if (data instanceof long[]) {
            this._distributedArray.putTrace((long[])data, this._tracePosition);
        } else if (data instanceof byte[]) {
            this._distributedArray.putTrace((byte[])data, this._tracePosition);
        } else {
            throw new RuntimeException("Data type not recognized");
        }
    }

    @Override
    public void reset() {
        this._positionIterator.reset();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }
}

