/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayIterator;

public class DistributedArrayPositionIterator
implements DistributedArrayIterator<int[]> {
    private int _hypercubeIndex;
    private int _volumeIndex;
    private int _frameIndex;
    private int _traceIndex;
    private DistributedArray _distributedArray;
    private int _nHypercubes;
    private int _nVolumes;
    private int _nFrames;
    private int _nTraces;
    private int[] _position;
    private int _ndim;
    private static int FORWARD = 1;
    private static int REVERSE = -1;
    private int _incr = FORWARD;

    public DistributedArrayPositionIterator(DistributedArray distributedArray, int[] position) {
        if (distributedArray == null) {
            throw new IllegalArgumentException("distributedArray is null");
        }
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        this._distributedArray = distributedArray;
        this._position = position;
        if (this._position.length < distributedArray.getDimensions()) {
            String message = String.format("position.length, dimensions mismatch (%d vs. %d)", position.length, distributedArray.getDimensions());
            throw new IllegalArgumentException(message);
        }
        this._ndim = distributedArray.getDimensions();
        this._nHypercubes = this._ndim > 4 ? distributedArray.getLocalLength(4) : 1;
        this._nVolumes = this._ndim > 3 ? distributedArray.getLocalLength(3) : 1;
        this._nTraces = distributedArray.getLocalLength(1);
        this._nFrames = distributedArray.getLocalLength(2);
        this._hypercubeIndex = 0;
        this._volumeIndex = 0;
        this._frameIndex = 0;
        this._traceIndex = 0;
    }

    public DistributedArrayPositionIterator(DistributedArray distributedArray, int[] position, int direction) {
        this(distributedArray, position);
        if (direction == REVERSE) {
            this._incr = REVERSE;
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex = this._nHypercubes - 1;
            this._incr = REVERSE;
        } else {
            this._incr = FORWARD;
        }
    }

    @Override
    public final boolean hasNext() {
        if (this._hypercubeIndex >= this._nHypercubes || this._hypercubeIndex < 0) {
            return false;
        }
        if (this._nFrames == 0) {
            return false;
        }
        return this._nVolumes != 0 || this._ndim != 4;
    }

    @Override
    public final int[] getPosition() {
        return (int[])this._position.clone();
    }

    @Override
    public final int[] next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Attempt to use next() after hasNext() returns false");
        }
        if (this._ndim > 4) {
            this._position[4] = this._distributedArray.localToGlobal(4, this._hypercubeIndex);
        }
        if (this._ndim > 3) {
            this._position[3] = this._distributedArray.localToGlobal(3, this._volumeIndex);
        }
        this._position[2] = this._distributedArray.localToGlobal(2, this._frameIndex);
        this._position[1] = this._distributedArray.localToGlobal(1, this._traceIndex);
        this._position[0] = 0;
        this._traceIndex += this._incr;
        if (this._traceIndex >= this._nTraces) {
            this._traceIndex = 0;
            this._frameIndex += this._incr;
        } else if (this._traceIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex += this._incr;
        }
        if (this._frameIndex >= this._nFrames) {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex += this._incr;
        } else if (this._frameIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex += this._incr;
        }
        if (this._volumeIndex >= this._nVolumes) {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex = 0;
            this._hypercubeIndex += this._incr;
        } else if (this._volumeIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex += this._incr;
        }
        return this._position;
    }

    @Override
    public void reset() {
        this._ndim = this._distributedArray.getDimensions();
        this._nHypercubes = this._ndim > 4 ? this._distributedArray.getLocalLength(4) : 1;
        this._nVolumes = this._ndim > 3 ? this._distributedArray.getLocalLength(3) : 1;
        this._nTraces = this._distributedArray.getLocalLength(1);
        this._nFrames = this._distributedArray.getLocalLength(2);
        if (this._incr == REVERSE) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex = this._nHypercubes - 1;
        } else {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex = 0;
            this._hypercubeIndex = 0;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }
}

