/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.javaseis.compress.TraceCompressor;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualIO;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;
import org.javaseis.util.SeisException;

public class SeisioVoxet
extends Seisio {
    private static final long serialVersionUID = 1L;
    private ParameterSet _gocadParameters;
    private String _prop_file;

    public SeisioVoxet(String path) throws SeisException {
        super(path);
        this.open("r");
    }

    public SeisioVoxet(Seisio sio) throws SeisException {
        super(sio._path, sio._gridDefinition, sio._dataDefinition, null);
        this._byteOrder = ByteOrder.BIG_ENDIAN;
        this._dataDefinition = new DataDefinition(DataType.CUSTOM, DataFormat.FLOAT, this._byteOrder);
        this.createDefaultVoxetHdr();
    }

    @Override
    public void open(String openMode) throws SeisException {
        String mode = "r";
        this._isReadOnly = true;
        if (openMode.equals("rw")) {
            this._isReadOnly = false;
            mode = "rw";
        }
        String voxetHdr = this._path.toString();
        try {
            this._gocadParameters = ParameterSetIO.readFile(voxetHdr);
        }
        catch (IOException e) {
            throw new SeisException(e.toString());
        }
        if (this._gocadParameters.getString("GOCAD", null) == null) {
            throw new SeisException("Input path is not a GOCAD voxet header: " + voxetHdr);
        }
        String buf = this._gocadParameters.getString("AXIS_N", null);
        if (buf == null) {
            throw new SeisException("AXIS_N undefined in GOCAD voxet header: " + voxetHdr);
        }
        int[] idim = new int[3];
        if ((idim = this._gocadParameters.getInts("AXIS_N", idim)).length != 3) {
            throw new SeisException("AXIS_N undefined in GOCAD voxet header: " + voxetHdr);
        }
        String s2 = this._gocadParameters.getString("PROP_FILE", null);
        if (s2 == null) {
            throw new SeisException("PROP_FILE undefined in GOCAD voxet header: " + voxetHdr);
        }
        this._prop_file = s2.substring(s2.indexOf(32) + 1, s2.length());
        int ndim = idim.length;
        this._gridDefinition = GridDefinition.getDefault(ndim, idim);
        this._byteOrder = ByteOrder.BIG_ENDIAN;
        this._dataDefinition = new DataDefinition(DataType.CUSTOM, DataFormat.FLOAT, this._byteOrder);
        this._filePropertiesParset.setString("DataType", this._dataDefinition.getDataTypeString());
        this._filePropertiesParset.setString("TraceFormat", this._dataDefinition.getTraceFormatString());
        this._filePropertiesParset.setString("ByteOrder", this._dataDefinition.getByteOrderString());
        this._filePropertiesParset.setInt("DataDimensions", this._gridDefinition.getNumDimensions());
        this._filePropertiesParset.setStrings("AxisLabels", this._gridDefinition.getAxisLabelsStrings());
        this._filePropertiesParset.setStrings("AxisUnits", this._gridDefinition.getAxisUnitsStrings());
        this._filePropertiesParset.setStrings("AxisDomains", this._gridDefinition.getAxisDomainsStrings());
        this._filePropertiesParset.setLongs("AxisLengths", this._gridDefinition.getAxisLengths());
        this._filePropertiesParset.setLongs("LogicalOrigins", this._gridDefinition.getAxisLogicalOrigins());
        this._filePropertiesParset.setLongs("LogicalDeltas", this._gridDefinition.getAxisLogicalDeltas());
        this._filePropertiesParset.setDoubles("PhysicalOrigins", this._gridDefinition.getAxisPhysicalOrigins());
        this._filePropertiesParset.setDoubles("PhysicalDeltas", this._gridDefinition.getAxisPhysicalDeltas());
        this._isMapped = false;
        this._isVirtual = false;
        this._usesHeaderProperties = false;
        this._headerLengthBytes = 0;
        this._headerLengthWords = 0;
        this._filePropertiesParset.setInt("HeaderLengthBytes", this._headerLengthBytes);
        File fh = new File(this._path);
        String tracePath = fh.getParent() + File.separator + this._prop_file;
        this._traceIO = new VirtualIO(tracePath, mode);
        int numSamples = (int)this._gridDefinition.getNumSamplesPerTrace();
        int numTraces = (int)this._gridDefinition.getNumTracesPerFrame();
        int numFrames = (int)this._gridDefinition.getNumFramesPerVolume();
        this._traceLength = TraceCompressor.getRecordLength(this._dataDefinition.getTraceFormat(), numSamples);
        this._frameLength = this._traceLength * numTraces;
        this._volumeLength = this._frameLength * (long)numFrames;
        this._frameHeaderLength = this._headerLengthBytes * numTraces;
        try {
            this._traceBuffer = ByteBuffer.allocateDirect((int)this._frameLength);
            this._traceBuffer.order(this._byteOrder);
            this._traceBufferView = this._traceBuffer.asFloatBuffer();
            this._traceData = new float[numTraces][numSamples];
        }
        catch (IllegalArgumentException ex) {
            throw new SeisException("Could not allocate buffers\n" + ex.getMessage());
        }
        this._traceCompressor = new TraceCompressor(this._dataDefinition.getTraceFormat(), numSamples, this._traceBuffer);
        this._traceIndex = -1L;
        this._frameIndex = -1;
        this._volumeIndex = -1;
        this._traceFilePosition = -1L;
        this._headerFilePosition = -1L;
        int numDimensions = this._gridDefinition.getNumDimensions();
        this._position = new int[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            this._position[i] = -1;
        }
    }

    public void createDefaultVoxetHdr() throws SeisException {
        float[] axis_o = new float[2];
        float[][] axis_uvw = new float[3][3];
        float[] axis_min = new float[3];
        float[] axis_max = new float[3];
        float[] axis_d = new float[3];
        int[] axis_n = new int[3];
        String[] axis_name = new String[3];
        String[] axis_unit = new String[3];
        axis_o[0] = (float)this._gridDefinition.getAxisPhysicalOrigin(0);
        axis_o[1] = (float)this._gridDefinition.getAxisPhysicalOrigin(1);
        axis_uvw[0][2] = (float)this._gridDefinition.getAxisPhysicalDelta(0);
        axis_uvw[1][1] = (float)this._gridDefinition.getAxisPhysicalDelta(1);
        axis_uvw[2][0] = (float)this._gridDefinition.getAxisPhysicalDelta(2);
        axis_n[0] = (int)this._gridDefinition.getAxisLength(0);
        axis_n[1] = (int)this._gridDefinition.getAxisLength(1);
        axis_n[2] = (int)this._gridDefinition.getAxisLength(2);
        axis_max[0] = axis_n[0] - 1;
        axis_max[1] = axis_n[1] - 1;
        axis_max[2] = axis_n[2] - 1;
        Arrays.fill(axis_d, 0, 3, 1.0f);
        axis_name[0] = this._gridDefinition.getAxisLabelString(0);
        axis_name[1] = this._gridDefinition.getAxisLabelString(1);
        axis_name[2] = this._gridDefinition.getAxisLabelString(2);
        axis_unit[0] = this._gridDefinition.getAxisUnitsString(0);
        axis_unit[1] = this._gridDefinition.getAxisUnitsString(1);
        axis_unit[2] = this._gridDefinition.getAxisUnitsString(2);
        this.createVoxetHdr("Voxet.vo", axis_o, axis_uvw, axis_min, axis_max, axis_n, axis_d, axis_name, axis_unit);
    }

    public void createVoxetHdr(String outputName, float[] axis_o, float[][] axis_uvw, float[] axis_min, float[] axis_max, int[] axis_n, float[] axis_d, String[] axis_name, String[] axis_unit) throws SeisException {
        File f = new File(this._path + File.separator + outputName);
        PrintStream out = null;
        try {
            f.createNewFile();
            out = new PrintStream(f);
        }
        catch (IOException e) {
            throw new SeisException("Could not create Voxet Header: " + f.getAbsolutePath());
        }
        out.println("GOCAD Voxet 1");
        out.println("HEADER {");
        out.println("name:" + outputName);
        out.println("}");
        out.format("%s %f %f\n", "AXIS_O", Float.valueOf(axis_o[0]), Float.valueOf(axis_o[1]));
        out.format("%s %f %f %f\n", "AXIS_U", Float.valueOf(axis_uvw[0][0]), Float.valueOf(axis_uvw[0][1]), Float.valueOf(axis_uvw[0][2]));
        out.format("%s %f %f %f\n", "AXIS_V", Float.valueOf(axis_uvw[1][0]), Float.valueOf(axis_uvw[1][1]), Float.valueOf(axis_uvw[1][2]));
        out.format("%s %f %f %f\n", "AXIS_W", Float.valueOf(axis_uvw[2][0]), Float.valueOf(axis_uvw[2][1]), Float.valueOf(axis_uvw[2][2]));
        out.format("%s %f %f %f\n", "AXIS_MIN", Float.valueOf(axis_min[0]), Float.valueOf(axis_min[1]), Float.valueOf(axis_min[2]));
        out.format("%s %f %f %f\n", "AXIS_MAX", Float.valueOf(axis_max[0]), Float.valueOf(axis_max[1]), Float.valueOf(axis_max[2]));
        out.format("%s %d %d %d\n", "AXIS_N", axis_n[0], axis_n[1], axis_n[2]);
        out.format("%s %f %f %f\n", "AXIS_D", Float.valueOf(axis_d[0]), Float.valueOf(axis_d[1]), Float.valueOf(axis_d[2]));
        out.format("%s \"%s\" \"%s\" \"%s\"\n", "AXIS_NAME", axis_name[0], axis_name[1], axis_name[2]);
        out.format("%s \"%s\" \"%s\" \"%s\"\n", "AXIS_UNIT", axis_unit[0], axis_unit[1], axis_unit[2]);
        out.println("AXIS_TYPE even even even");
        out.println("PROPERTY 1 \"Seismic\"");
        out.println("PROP_ESIZE 1 4");
        out.println("PROP_ETYPE 1 IEEE");
        out.println("PROP_OFFSET 1 0");
        out.println("PROP_FILE 1 " + "TraceFile");
        out.println("END");
        out.close();
    }

    public static void main(String[] args) throws SeisException {
        SeisioVoxet sv = new SeisioVoxet("/home/moshecc/tmp/voxet/Mosher2.vo");
        sv.open("r");
    }
}

