/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.ArrayMath;
import java.util.Arrays;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.FrameIterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.TraceIterator;
import org.junit.Assert;
import org.junit.Test;

public class JTestMultipleDimensions {
    @Test
    public void testReshape0() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 1);
            int[] shape2 = (int[])shape.clone();
            shape2[0] = 2;
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            Assert.assertArrayEquals((int[])shape, (int[])a.getShape());
            a.reshape(shape2);
            Assert.assertEquals((long)2L, (long)a.getShape()[0]);
        }
    }

    @Test
    public void testReshape() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 1);
            for (int j = 0; j < shape.length; ++j) {
                int[] shape2 = (int[])shape.clone();
                shape2[j] = 2;
                IFlexArray<int[]> a = FlexArray.createIntArray(shape);
                Assert.assertArrayEquals((int[])shape, (int[])a.getShape());
                a.reshape(shape2);
                Assert.assertEquals((long)2L, (long)a.getShape()[j]);
            }
        }
    }

    @Test
    public void testT21() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 1);
            shape[0] = 5;
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            Assert.assertArrayEquals((int[])shape, (int[])a.getShape());
            a.transpose(TransposeType.T21);
            Assert.assertEquals((long)1L, (long)a.getShape()[0]);
            Assert.assertEquals((long)5L, (long)a.getShape()[1]);
        }
    }

    @Test
    public void testTOuter() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 1);
            shape[shape.length - 1] = 5;
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            Assert.assertArrayEquals((int[])shape, (int[])a.getShape());
            a.transposeOuter();
            Assert.assertEquals((long)1L, (long)a.getShape()[shape.length - 1]);
            Assert.assertEquals((long)5L, (long)a.getShape()[shape.length - 2]);
        }
    }

    @Test
    public void testTraceIterator() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 3);
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            TraceIterator<int[]> it = new TraceIterator<int[]>(a);
            while (it.hasNext()) {
                int[] trace = it.next();
                Arrays.fill(trace, 1);
            }
        }
    }

    @Test
    public void testFrameIterator() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 3);
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            FrameIterator it = new FrameIterator(a);
            while (it.hasNext()) {
                int[][] frame = (int[][])it.next();
                ArrayMath.fill((int)1, (int[][])frame);
            }
        }
    }

    @Test
    public void testCopyConstructor() {
        int min = 2;
        int max = 10;
        for (int i = min; i <= max; ++i) {
            int[] shape = new int[i];
            Arrays.fill(shape, 3);
            IFlexArray<int[]> a = FlexArray.createIntArray(shape);
            FlexArray b = new FlexArray((FlexArray)a);
            Assert.assertArrayEquals((int[])a.getShape(), (int[])b.getShape());
        }
    }
}

