/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import java.util.Iterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.iterators.beta.IIterator;
import org.javaseis.iterators.beta.IPositionIterator;

public class TraceIterator<E>
implements IIterator<E> {
    private final IFlexArray<E> _seismicArray;
    private final IPositionIterator<int[]> _positionIterator;
    private int[] _tracePosition;

    public TraceIterator(IFlexArray<E> gArray) {
        this._seismicArray = gArray;
        this._tracePosition = new int[gArray.getDimensions()];
        this._positionIterator = gArray.newPositionIterator();
        this._positionIterator.setScope(IPositionIterator.Scope.TRACE_AXIS);
    }

    public TraceIterator(IFlexArray<E> multiArray, IPositionIterator<int[]> positionIterator) {
        this._seismicArray = multiArray;
        this._tracePosition = new int[multiArray.getDimensions()];
        this._positionIterator = positionIterator;
        if (this._positionIterator.getScope() != IPositionIterator.Scope.TRACE_AXIS) {
            throw new IllegalArgumentException("The scope for the position iterator must be 1");
        }
    }

    @Override
    public final boolean hasNext() {
        return this._positionIterator.hasNext();
    }

    @Override
    public E next() {
        this._tracePosition = (int[])this._positionIterator.next();
        return this._seismicArray.getTrace(this._tracePosition);
    }

    @Override
    public int[] getPosition() {
        return (int[])this._tracePosition.clone();
    }

    @Override
    public void reset() {
        this._positionIterator.reset();
    }

    @Override
    public Iterator<E> iterator() {
        return new TraceIterator<E>(this._seismicArray);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

