/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import edu.mines.jtk.util.ArrayMath;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.ArraysUtil;
import org.javaseis.array.beta.DecompositionType;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.ParallelDecomposition;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.array.beta.Transposer;
import org.javaseis.iterators.beta.IPositionIterator;

public final class FlexArray<T>
implements IFlexArray<T> {
    private static final Logger LOG = Logger.getLogger(FlexArray.class.getName());
    private static final int MIN_DIM = 2;
    private int[] shape;
    private Object storage;
    private final Class<?> type;
    private int elementCount;

    public static IFlexArray<int[]> createIntArray(int[] shape) {
        FlexArray<int[]> ia = new FlexArray<int[]>(int[].class, 1, shape);
        return ia;
    }

    public static IFlexArray<int[]> createIntArray(int elementCount, int[] shape) {
        FlexArray<int[]> ia = new FlexArray<int[]>(int[].class, elementCount, shape);
        return ia;
    }

    public static IFlexArray<float[]> createFloatArray(int[] shape) {
        FlexArray<float[]> ia = new FlexArray<float[]>(float[].class, 1, shape);
        return ia;
    }

    public static IFlexArray<float[]> createFloatArray(int elementCount, int[] shape) {
        FlexArray<float[]> ia = new FlexArray<float[]>(float[].class, elementCount, shape);
        return ia;
    }

    public FlexArray(Class<?> type, int elementCount, int[] shape) {
        this.validateShape(shape);
        this.validateType(type);
        this.elementCount = elementCount;
        this.shape = (int[])shape.clone();
        this.type = type;
        int[] lengths = (int[])shape.clone();
        lengths[0] = lengths[0] * elementCount;
        this.storage = Array.newInstance(this.getElementType(), ArrayMath.reverse((int[])lengths));
    }

    public FlexArray(Class<?> type, int elementCount, Object data) {
        this.shape = ArraysUtil.getShape(data);
        this.shape[0] = this.shape[0] / elementCount;
        this.validateShape(this.shape);
        this.validateType(type);
        this.type = type;
        this.elementCount = elementCount;
        this.storage = data;
    }

    public FlexArray(FlexArray<T> src) {
        this(src.type, src.getElementCount(), src.getShape());
        IPositionIterator<int[]> it = src.newPositionIterator();
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            T tIn = src.getTrace(pos);
            T tOut = this.getTrace(pos);
            System.arraycopy(tIn, 0, tOut, 0, this.shape[0] * this.elementCount);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Type = " + this.type.getCanonicalName() + ", Shape = " + Arrays.toString(this.shape) + " element count = " + this.elementCount);
        return buf.toString();
    }

    @Override
    public int getDimensions() {
        return this.shape.length;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?> getElementType() {
        return this.type.getComponentType();
    }

    @Override
    public T[] getBackArray() {
        return (Object[])this.storage;
    }

    @Override
    public ParallelDecomposition getDecomposition() {
        ParallelDecomposition decomp = new ParallelDecomposition(DecompositionType.NONE, this.shape[this.shape.length - 1], 1, 0);
        return decomp;
    }

    @Override
    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    @Override
    public void reshape(int[] newShape) {
        int i;
        this.validateShape(newShape);
        while (this.shape.length > newShape.length) {
            this.removeDimension();
        }
        while (this.shape.length < newShape.length) {
            this.addDimension();
        }
        for (i = newShape.length - 1; i >= 0; --i) {
            this.setLength(i, newShape[i]);
        }
        for (i = 0; i < newShape.length; ++i) {
            this.setLength(i, newShape[i]);
        }
    }

    @Override
    public void transposeOuter() {
        this.transpose(this.getDimensions(), this.getDimensions() - 1);
    }

    @Override
    public void transpose(TransposeType type) {
        Transposer.transpose(this, type);
    }

    @Override
    public void transpose(int axisA, int axisB) {
        if (axisA < 1 || axisA > this.shape.length) {
            throw new IllegalArgumentException("Invalid axis specified.  Axes must be  between 1 and " + this.shape.length);
        }
        if (axisB < 1 || axisB > this.shape.length) {
            throw new IllegalArgumentException("Invalid axis specified.  Axes must be  between 1 and " + this.shape.length);
        }
        if (axisA == 1 && axisB != 2 || axisB == 1 && axisA != 2) {
            throw new IllegalArgumentException("When trasposing axis 1 only axis 2 is directly supported.  Other transposes have to be done by using multiple operations");
        }
        if (axisA == 1 && axisB == 2 || axisA == 2 && axisB == 1) {
            this.t21();
            return;
        }
        FlexArray<T> a = new FlexArray<T>(this.type, this.elementCount, this.storage);
        IPositionIterator<int[]> it = a.newPositionIterator();
        int[] shapeOut = (int[])this.shape.clone();
        shapeOut[--axisA] = this.shape[--axisB];
        shapeOut[axisB] = this.shape[axisA];
        int[] container = (int[])shapeOut.clone();
        container[0] = 0;
        this.storage = Array.newInstance(this.getElementType(), ArrayMath.reverse((int[])container));
        this.shape = shapeOut;
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            T trace = a.getTrace(pos);
            int tmp = pos[axisA];
            pos[axisA] = pos[axisB];
            pos[axisB] = tmp;
            this.putTrace(trace, pos);
        }
    }

    @Override
    public T getTrace(int[] pos) {
        this.validatePosition(pos);
        Object a = this.storage;
        for (int i = pos.length - 1; i > 0; --i) {
            a = Array.get(a, pos[i]);
        }
        return (T)a;
    }

    @Override
    public void putTrace(T buf, int[] pos) {
        this.validatePosition(pos);
        Object a = this.storage;
        for (int i = pos.length - 1; i > 1; --i) {
            a = Array.get(a, pos[i]);
        }
        Array.set(a, pos[1], buf);
    }

    @Override
    public T[] getFrame(int[] pos) {
        this.validatePosition(pos);
        Object a = this.storage;
        for (int i = pos.length - 1; i > 1; --i) {
            a = Array.get(a, pos[i]);
        }
        return (Object[])a;
    }

    @Override
    public void putFrame(T[] buf, int[] pos) {
        this.validatePosition(pos);
        if (pos.length == 2) {
            this.storage = buf;
            return;
        }
        Object a = this.storage;
        for (int i = pos.length - 1; i > 2; --i) {
            a = Array.get(a, pos[i]);
        }
        Array.set(a, pos[2], buf);
    }

    @Override
    public T[][] getVolume(int[] pos) {
        this.validatePosition(pos);
        Object a = this.storage;
        for (int i = pos.length - 1; i > 2; --i) {
            a = Array.get(a, pos[i]);
        }
        return (Object[][])a;
    }

    @Override
    public void putVolume(T[][] buf, int[] pos) {
        this.validatePosition(pos);
        if (pos.length == 3) {
            this.storage = buf;
            return;
        }
        Object a = this.storage;
        for (int i = pos.length - 1; i > 3; --i) {
            a = Array.get(a, pos[i]);
        }
        Array.set(a, pos[3], buf);
    }

    @Override
    public T[][][] getHypercube(int[] pos) {
        this.validatePosition(pos);
        Object a = this.storage;
        for (int i = pos.length - 1; i > 3; --i) {
            a = Array.get(a, pos[i]);
        }
        return (Object[][][])a;
    }

    @Override
    public void putHypercube(T[][][] buf, int[] pos) {
        this.validatePosition(pos);
        if (pos.length == 4) {
            this.storage = buf;
            return;
        }
        Object a = this.storage;
        for (int i = pos.length - 1; i > 4; --i) {
            a = Array.get(a, pos[i]);
        }
        Array.set(a, pos[4], buf);
    }

    @Override
    public IPositionIterator<int[]> newPositionIterator() {
        return new PositionIterator(this.getShape());
    }

    @Override
    public IPositionIterator<int[]> newPositionIterator(IPositionIterator.Direction dir, IPositionIterator.Scope axis) {
        int[] shapeIn = this.getShape();
        return new PositionIterator(shapeIn, new int[shapeIn.length], dir, axis);
    }

    private void setShape0(int shape0) {
        if (this.shape[0] == shape0) {
            return;
        }
        int len0 = shape0 * this.elementCount;
        this.shape[0] = shape0;
        IPositionIterator<int[]> it = this.newPositionIterator(IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.FRAME_AXIS);
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            T[] frame = this.getFrame(pos);
            int oldLen = Array.getLength(frame[0]);
            if (len0 == oldLen) continue;
            Object[] dst = (Object[])Array.newInstance(this.getElementType(), this.shape[1], len0);
            for (int i = 0; i < this.shape[1]; ++i) {
                System.arraycopy(frame[i], 0, dst[i], 0, Math.min(len0, oldLen));
            }
            this.putFrame(dst, pos);
        }
    }

    private void setLength(int axis, int newLen) {
        if (axis < 0 || axis > this.shape.length - 1) {
            throw new IllegalArgumentException("Axis is invalid");
        }
        if (this.shape[axis] == newLen) {
            return;
        }
        if (axis == 0) {
            this.setShape0(newLen);
            return;
        }
        int[] shapeOut = (int[])this.shape.clone();
        shapeOut[axis] = newLen;
        int[] container = (int[])shapeOut.clone();
        container[0] = 0;
        Object out = Array.newInstance(this.getElementType(), ArrayMath.reverse((int[])container));
        FlexArray<Object> a = new FlexArray<Object>(this.type, this.elementCount, out);
        IPositionIterator<int[]> it = a.newPositionIterator();
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            Object trace = null;
            trace = pos[axis] < this.shape[axis] ? (Object)this.getTrace(pos) : Array.newInstance(this.getElementType(), new int[]{this.shape[0] * this.elementCount});
            a.putTrace(trace, pos);
        }
        this.storage = a.storage;
        this.shape = shapeOut;
    }

    private void t21() {
        boolean OPTIMIZED21 = true;
        int[] shapeOut = (int[])this.shape.clone();
        shapeOut[0] = this.shape[1];
        shapeOut[1] = this.shape[0];
        IPositionIterator<int[]> it = this.newPositionIterator(IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.FRAME_AXIS);
        this.shape = shapeOut;
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            T[] frame = this.getFrame(pos);
            Object[] dst = null;
            if (this.getElementType().equals(Integer.TYPE) && OPTIMIZED21) {
                dst = (Object[])ArraysUtil.tran21((int[][])frame);
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (int[][])dst);
            } else if (this.getElementType().equals(Float.TYPE) && OPTIMIZED21) {
                dst = (Object[])ArraysUtil.tran21((float[][])frame);
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (float[][])dst);
            } else if (this.getElementType().equals(Integer.TYPE) && !OPTIMIZED21) {
                dst = (Object[])ArrayMath.transpose((int[][])((int[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (int[][])dst);
            } else if (this.getElementType().equals(Float.TYPE) && !OPTIMIZED21) {
                dst = (Object[])ArrayMath.transpose((float[][])((float[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (float[][])dst);
            } else if (this.getElementType().equals(Double.TYPE)) {
                dst = (Object[])ArrayMath.transpose((double[][])((double[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (double[][])dst);
            } else if (this.getElementType().equals(Short.TYPE)) {
                dst = (Object[])ArrayMath.transpose((short[][])((short[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (short[][])dst);
            } else if (this.getElementType().equals(Long.TYPE)) {
                dst = (Object[])ArrayMath.transpose((long[][])((long[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (long[][])dst);
            } else if (this.getElementType().equals(Byte.TYPE)) {
                dst = (Object[])ArrayMath.transpose((byte[][])((byte[][])frame));
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (byte[][])dst);
            } else {
                dst = (Object[])ArraysUtil.transpose((Object[][])frame);
                dst = (Object[])ArraysUtil.combineTraces(this.elementCount, (Object[][])dst);
            }
            this.putFrame(dst, pos);
        }
    }

    private void removeDimension() {
        if (this.shape.length < 3) {
            throw new UnsupportedOperationException("Cannot remove a dimension from a 2D array");
        }
        int[] newLengths = new int[this.shape.length - 1];
        for (int i = 0; i < newLengths.length; ++i) {
            newLengths[i] = this.shape[i];
        }
        this.shape = newLengths;
        int[] containerLengths = new int[this.shape.length];
        containerLengths[0] = this.shape[this.shape.length - 1];
        Object out = Array.newInstance(this.getElementType(), containerLengths);
        Object a = Array.get(this.storage, 0);
        for (int i = 0; i < this.shape[this.shape.length - 1]; ++i) {
            Object b = Array.get(a, i);
            Array.set(out, i, b);
        }
        this.storage = out;
    }

    private void addDimension() {
        int[] newLengths = new int[this.shape.length + 1];
        for (int i = 0; i < this.shape.length; ++i) {
            newLengths[i] = this.shape[i];
        }
        newLengths[newLengths.length - 1] = 1;
        this.shape = newLengths;
        int[] containerLengths = new int[this.shape.length];
        containerLengths[0] = 1;
        Object out = Array.newInstance(this.getElementType(), containerLengths);
        Array.set(out, 0, this.storage);
        this.storage = out;
    }

    private void validateShape(int[] shape) {
        if (shape.length < 2) {
            throw new IllegalArgumentException("Diminsions must be greater than 2");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 0) continue;
            throw new IllegalArgumentException("shape is invalid " + Arrays.toString(shape));
        }
    }

    private void validatePosition(int[] pos) {
        if (pos.length != this.shape.length) {
            throw new IllegalArgumentException("The length of the position indicator does not match the existing data");
        }
        for (int i = 0; i < pos.length; ++i) {
            if (pos[i] >= 0) continue;
            throw new IllegalArgumentException("position indicator is invalid " + Arrays.toString(pos));
        }
    }

    private void validateType(Class<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("The parameter 'type' is expected to be an array, something like int[].class or float[].class");
        }
    }
}

