/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.spec.PointSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public abstract class FFParameterSpec
implements Zeroizeable,
ECParams,
Serializable {
    private static final long serialVersionUID = 6710011009580678591L;
    protected int a;
    protected byte[] b;
    protected byte[] c;
    protected byte[] d;
    protected byte[] e;
    protected byte[] f;
    protected byte[] g;
    protected int h;
    protected String i;
    protected String j;
    protected boolean k = false;

    protected FFParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string, String string2) {
        if (byArray == null || byArray2 == null || byArray4 == null || byArray5 == null || byArray6 == null) {
            throw new NullPointerException("parameter(s) cannot be null!");
        }
        this.a = n3;
        n3 = (n3 + 7) / 8;
        this.b = this.a(byArray, 0, byArray.length, n3);
        this.c = this.a(byArray2, 0, byArray2.length, n3);
        if (byArray3 != null) {
            this.d = this.a(byArray3, 0, byArray3.length, -1);
        }
        this.e = this.a(byArray4, 0, byArray4.length, n3);
        this.f = this.a(byArray5, 0, byArray5.length, n3);
        this.g = this.a(byArray6, 0, byArray6.length, -1);
        this.h = n2;
        this.i = string;
        this.j = string2;
    }

    public int getSize() {
        return this.a;
    }

    public byte[] getA() {
        return this.a(this.b, 0, this.b.length, -1);
    }

    public byte[] getB() {
        return this.a(this.c, 0, this.c.length, -1);
    }

    public byte[] getSeed() {
        if (this.d != null) {
            return this.a(this.d, 0, this.d.length, -1);
        }
        return null;
    }

    public PointParams getPoint() {
        return new PointSpec(this.e, this.f, this);
    }

    public byte[] getPointOrder() {
        return this.a(this.g, 0, this.g.length, -1);
    }

    public int getPointOrderSize() {
        return FFParameterSpec.a(this.g);
    }

    static int a(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (byArray[n2] == 0) continue;
            n3 = byArray[n2] & 0xFF;
            break;
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = n3 > 127 ? 8 : (n3 > 63 ? 7 : (n3 > 31 ? 6 : (n3 > 15 ? 5 : (n3 > 7 ? 4 : (n3 > 3 ? 3 : (n3 > 1 ? 2 : (n3 > 0 ? 1 : 0)))))));
        return (n4 - n2 - 1) * 8 + n5;
    }

    public int getCofactor() {
        return this.h;
    }

    public String getName() {
        String string;
        if (this.i == null) {
            string = this.getOID();
            if (string == null) {
                string = "ImplicitlyCA";
            }
        } else {
            string = new String(this.i);
        }
        return string;
    }

    public String getOID() {
        if (this.j == null) {
            return null;
        }
        return new String(this.j);
    }

    public boolean equals(Object object) {
        if (object instanceof FFParameterSpec) {
            FFParameterSpec fFParameterSpec = (FFParameterSpec)object;
            return this.a == fFParameterSpec.a && this.h == fFParameterSpec.h && this.a(this.b, fFParameterSpec.b) && this.a(this.c, fFParameterSpec.c) && this.a(this.e, fFParameterSpec.e) && this.a(this.f, fFParameterSpec.f) && this.a(this.g, fFParameterSpec.g);
        }
        return false;
    }

    public int hashCode() {
        return this.a << 9 ^ this.h << 6 ^ this.b(this.b) ^ this.b(this.c) ^ this.b(this.e) ^ this.b(this.f) ^ this.b(this.g);
    }

    protected int b(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n3 = n2 << 9;
            int n4 = n2 >>> 23;
            n2 = n3 ^ n4 ^ byArray[i2];
        }
        return n2;
    }

    protected final byte[] a(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null || byArray.length - n2 < n3) {
            throw new IllegalArgumentException("parameter(s) relating to input buffer invalid");
        }
        int n5 = n3;
        while (n3 > 0 && byArray[n2] == 0) {
            ++n2;
            --n3;
        }
        if (n3 == 0) {
            return new byte[n5];
        }
        if (n4 == -1) {
            n4 = n3;
        }
        if (n3 > n4) {
            throw new IllegalArgumentException("output buffer is too small.");
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, n4 - n3, n3);
        return byArray2;
    }

    protected final boolean a(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null array(s)");
        }
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        for (n2 = 0; n2 < byArray2.length && byArray2[n2] == 0; ++n2) {
        }
        if (byArray.length - n3 != byArray2.length - n2) {
            return false;
        }
        n3 = byArray.length - n2;
        n2 = 0;
        while (n3-- > 0) {
            if (byArray[byArray.length - ++n2] == byArray2[byArray2.length - n2]) continue;
            return false;
        }
        return true;
    }

    public boolean isZeroized() {
        return this.k;
    }

    public boolean testZeroizationState() {
        return this.k;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.b, (byte)0);
        Arrays.fill(this.c, (byte)0);
        if (this.d != null) {
            Arrays.fill(this.d, (byte)0);
        }
        Arrays.fill(this.e, (byte)0);
        Arrays.fill(this.f, (byte)0);
        Arrays.fill(this.g, (byte)0);
        this.h = 0;
        this.a = 0;
        this.j = "0.0.0.0";
        this.i = "0.0.0.0";
        this.k = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.a));
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.g);
        objectOutputStream.writeObject(new Integer(this.h));
        objectOutputStream.writeObject(this.i);
        objectOutputStream.writeObject(this.j);
        objectOutputStream.writeObject(new Boolean(this.k));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (Integer)objectInputStream.readObject();
        this.b = (byte[])objectInputStream.readObject();
        this.c = (byte[])objectInputStream.readObject();
        this.d = (byte[])objectInputStream.readObject();
        this.e = (byte[])objectInputStream.readObject();
        this.f = (byte[])objectInputStream.readObject();
        this.g = (byte[])objectInputStream.readObject();
        this.h = (Integer)objectInputStream.readObject();
        this.i = (String)objectInputStream.readObject();
        this.j = (String)objectInputStream.readObject();
        this.k = (Boolean)objectInputStream.readObject();
    }
}

