/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LinearLayoutWidget
extends JPanel
implements ComponentListener {
    protected Direction m_direction;
    protected int m_inset;
    protected int m_nextRowColumn = 0;
    protected GridBagLayout m_gridBagLayout = new GridBagLayout();
    public boolean Verbose = false;
    public boolean RecolorLabels = false;

    public LinearLayoutWidget(Direction dir, int insets, String borderLabel) {
        try {
            this.m_direction = dir;
            this.m_inset = Math.max(0, insets);
            this.m_inset = Math.min(9, insets);
            if (borderLabel != null) {
                this.setBorder(BorderFactory.createTitledBorder(borderLabel));
            }
            this.setLayout(this.m_gridBagLayout);
            this.addComponentListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static LinearLayoutWidget horz(int insets, String borderLabel) {
        return new LinearLayoutWidget(Direction.Horizontal, insets, borderLabel);
    }

    public static LinearLayoutWidget vert(int insets, String borderLabel) {
        return new LinearLayoutWidget(Direction.Vertical, insets, borderLabel);
    }

    public JLabel createGapLabel(int w, int h) {
        try {
            JLabel lbl = new JLabel("");
            Dimension d = new Dimension(w, h);
            lbl.setPreferredSize(d);
            lbl.setMinimumSize(d);
            this.addComponent(lbl, 0);
            return lbl;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JLabel createGapLabel(int gapSize) {
        try {
            JLabel lbl = new JLabel("");
            Dimension d = new Dimension(gapSize, gapSize);
            lbl.setPreferredSize(d);
            lbl.setMinimumSize(d);
            this.addComponent(lbl, 0);
            return lbl;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void addStretch(int stretch) {
        try {
            JPanel panel = new JPanel();
            panel.setBackground(this.getBackground());
            this.addComponent(panel, stretch);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public JLabel createLabel(String txt, int position, int stretch) {
        try {
            JLabel tf = new JLabel(txt, position);
            this.addComponent(tf, stretch);
            return tf;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JComboBox<String> createSubComboBox(String label, ItemListener listener) {
        try {
            LinearLayoutWidget sub = this.createLinearLayoutWidget(Direction.Horizontal, 0, null, 0);
            sub.addComponent(new JLabel(label), 0);
            JComboBox<String> combo = new JComboBox<String>();
            if (listener != null) {
                combo.addItemListener(listener);
            }
            sub.addComponent(combo, 10);
            return combo;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JTextField createSubTextField(String label, String txt, ActionListener listener) {
        try {
            LinearLayoutWidget sub = this.createLinearLayoutWidget(Direction.Horizontal, 0, null, 0);
            sub.addComponent(new JLabel(label), 0);
            JTextField tf = new JTextField(txt);
            if (listener != null) {
                tf.addActionListener(listener);
            }
            sub.addComponent(tf, 10);
            return tf;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JTextField createTextField(String txt, ActionListener listener, int stretch) {
        try {
            JTextField tf = new JTextField(txt);
            if (listener != null) {
                tf.addActionListener(listener);
            }
            this.addComponent(tf, stretch);
            return tf;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JComboBox createComboBox(ActionListener listener) {
        try {
            JComboBox box = new JComboBox();
            if (listener != null) {
                box.addActionListener(listener);
            }
            this.addComponent(box, 0);
            return box;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JRadioButton createRadioButton(String txt, ButtonGroup group, ActionListener listener, int stretch) {
        try {
            JRadioButton btn = new JRadioButton(txt);
            if (listener != null) {
                btn.addActionListener(listener);
            }
            this.addComponent(btn, stretch);
            group.add(btn);
            return btn;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JCheckBox createCheckBox(String txt, int stretch, ActionListener listener) {
        try {
            JCheckBox btn = new JCheckBox(txt);
            if (listener != null) {
                btn.addActionListener(listener);
            }
            this.addComponent(btn, stretch);
            return btn;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JButton createButton(String txt, ActionListener listener, int stretch) {
        try {
            JButton btn = new JButton(txt);
            if (listener != null) {
                btn.addActionListener(listener);
            }
            this.addComponent(btn, stretch);
            return btn;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public GridLayoutWidget createGridLayoutWidget(int insets, int stretch) throws Exception {
        try {
            GridLayoutWidget fw = new GridLayoutWidget(insets);
            this.addComponent(fw, stretch);
            return fw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public GridLayoutWidget createGridLayoutWidget(int insets, String borderLabel, int stretch) throws Exception {
        try {
            GridLayoutWidget fw = new GridLayoutWidget(insets, borderLabel);
            this.addComponent(fw, stretch);
            return fw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public LinearLayoutWidget createHorizontal(int insets, String borderLabel, int stretch) throws Exception {
        try {
            LinearLayoutWidget fw = new LinearLayoutWidget(Direction.Horizontal, insets, borderLabel);
            this.addComponent(fw, stretch);
            return fw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public LinearLayoutWidget createVertical(int insets, String borderLabel, int stretch) throws Exception {
        try {
            LinearLayoutWidget fw = new LinearLayoutWidget(Direction.Vertical, insets, borderLabel);
            this.addComponent(fw, stretch);
            return fw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public LinearLayoutWidget createLinearLayoutWidget(Direction dir, int insets, String borderLabel, int stretch) throws Exception {
        try {
            LinearLayoutWidget fw = new LinearLayoutWidget(dir, insets, borderLabel);
            this.addComponent(fw, stretch);
            return fw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public JPanel createPanel(int stretch) throws Exception {
        try {
            JPanel panel = new JPanel();
            this.addComponent(panel, stretch);
            return panel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addHorzPair(Component child1, int stretch1, Component child2, int stretch2) throws Exception {
        try {
            LinearLayoutWidget sub = this.createHorizontal(0, null, 0);
            sub.addComponent(child1, stretch1);
            sub.addComponent(child2, stretch2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addComponentInBox(Component child, int stretch, String title) throws Exception {
        try {
            LinearLayoutWidget w = this.createVertical(0, title, stretch);
            w.addComponent(child, 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addComponent(Component child, int stretch) throws Exception {
        try {
            GridBagConstraints gbcon = new GridBagConstraints();
            if (this.m_direction == Direction.Horizontal) {
                gbcon.gridx = this.m_nextRowColumn;
                gbcon.gridy = 0;
                gbcon.weightx = Math.max(stretch, 0);
                gbcon.weighty = 1.0;
            } else {
                gbcon.gridx = 0;
                gbcon.gridy = this.m_nextRowColumn;
                gbcon.weightx = 1.0;
                gbcon.weighty = Math.max(stretch, 0);
            }
            gbcon.anchor = 10;
            gbcon.fill = 1;
            gbcon.gridheight = 1;
            gbcon.gridwidth = 1;
            int inset = Math.max(this.m_inset, 0);
            gbcon.insets = new Insets(inset, inset, inset, inset);
            this.m_gridBagLayout.setConstraints(child, gbcon);
            this.add(child);
            ++this.m_nextRowColumn;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        try {
            if (child instanceof JLabel && this.RecolorLabels) {
                child.setBackground(this.getBackground());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void callLayoutContainer() {
        try {
            GridBagLayout gbl = (GridBagLayout)this.getLayout();
            gbl.layoutContainer(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            if (this.Verbose) {
                System.out.println("layout widget componentResized height = " + Integer.toString(this.getSize().height));
            }
            this.m_gridBagLayout.invalidateLayout(this);
            this.callLayoutContainer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public static enum Direction {
        Vertical,
        Horizontal;

    }
}

