/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.ParameterBase;
import com.PecosCore.Windows.Parameter.Parameter_Grid;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ParameterManager
implements ParameterBase.Listener {
    protected ParameterTree m_parameterTree;
    protected ArrayList<ParameterBase> m_list = new ArrayList();
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public ParameterTree parameterTree() {
        return this.m_parameterTree;
    }

    public ParameterManager(ParameterTree pt) {
        try {
            this.m_parameterTree = pt;
            if (this.m_parameterTree == null) {
                this.m_parameterTree = new ParameterTree();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ParameterBase getParameterBase(String parameterName) throws Exception {
        try {
            for (ParameterBase p : this.m_list) {
                if (!parameterName.equalsIgnoreCase(p.parameterName())) continue;
                return p;
            }
            throw new Exception("Parameter not found: " + parameterName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public String getString(String parameterName) throws Exception {
        try {
            return this.getParameterBase(parameterName).getString();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double getDouble(String parameterName, double defValue, double min, double max) throws Exception {
        try {
            return this.getParameterBase(parameterName).getDouble(defValue, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getInt(String parameterName, int defvalue, int min, int max) throws Exception {
        try {
            return this.getParameterBase(parameterName).getInt(defvalue, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ArrayList<String> getStringList(String parameterName) throws Exception {
        try {
            return this.getParameterBase(parameterName).getStringList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public String getGridString(String parameterName, String gridKey) throws Exception {
        try {
            return this.getParameterBase(parameterName).getGridString(gridKey);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double getGridDouble(String parameterName, String gridKey, double defValue, double min, double max) throws Exception {
        try {
            return this.getParameterBase(parameterName).getGridDouble(gridKey, defValue, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getGridInt(String parameterName, String gridKey, int defvalue, int min, int max) throws Exception {
        try {
            return this.getParameterBase(parameterName).getGridInt(gridKey, defvalue, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected String checkTabName(String tabPageName) {
        try {
            if (tabPageName == null) {
                return "Default";
            }
            if (tabPageName.isEmpty()) {
                return "Default";
            }
            return tabPageName;
        }
        catch (Exception error) {
            return "Default";
        }
    }

    protected void checkParameterName(String parameterName) throws Exception {
        try {
            if (parameterName == null) {
                throw new Exception("parameterName == null");
            }
            if (parameterName.isEmpty()) {
                throw new Exception("parameterName.isEmpty()");
            }
            for (ParameterBase p : this.m_list) {
                if (!parameterName.equalsIgnoreCase(p.parameterName())) continue;
                throw new Exception("Param already exists");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Parameter_Grid create_Parameter_Grid(String parameterName, String tabPageName) throws Exception {
        try {
            tabPageName = this.checkTabName(tabPageName);
            this.checkParameterName(parameterName);
            ParameterTree pt = this.m_parameterTree.ParameterTree_get(parameterName);
            Parameter_Grid p = new Parameter_Grid(pt, parameterName, tabPageName, 0, 1);
            this.appendParameterBase(p);
            return p;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void appendParameterBase(ParameterBase param) {
        try {
            if (param != null) {
                param.addListener(this);
                this.m_list.add(param);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public JComponent editor() {
        try {
            if (this.m_list.size() < 1) {
                return new JPanel();
            }
            ArrayList<String> tabPageNames = new ArrayList<String>();
            for (ParameterBase p : this.m_list) {
                String tab = p.tabPageName();
                boolean found = false;
                for (String s : tabPageNames) {
                    found = found || tab.equalsIgnoreCase(s);
                }
                if (found) continue;
                tabPageNames.add(tab);
            }
            if (tabPageNames.size() == 1) {
                return this.createPage((String)tabPageNames.get(0));
            }
            JTabbedPane tabs = new JTabbedPane();
            for (String s : tabPageNames) {
                tabs.addTab(s, this.createPage(s));
            }
            return tabs;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createPage(String s) {
        try {
            LinearLayoutWidget w = LinearLayoutWidget.vert(0, null);
            for (ParameterBase p : this.m_list) {
                String tab = p.tabPageName();
                if (!tab.equalsIgnoreCase(s)) continue;
                w.addComponent(p.editor(), p.editorVerticalStretch());
            }
            w.addStretch(10);
            return w;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void handleParameterModified(ParameterBase sender, Object data) {
        try {
            this.broadcast(sender.m_parameterName, data);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearListeners() {
        try {
            this.m_listeners.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void broadcast(String name, Object data) {
        try {
            for (int n = this.m_listeners.size() - 1; n >= 0; --n) {
                WeakReference<Listener> weak = this.m_listeners.get(n);
                Listener listener = (Listener)weak.get();
                if (listener != null) {
                    listener.handleParameterEdited(name, data);
                    continue;
                }
                this.m_listeners.remove(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected static interface Listener {
        public void handleParameterEdited(String var1, Object var2);
    }
}

