/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class GenericObjectListener {
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public void broadcast(Object sender, Object data) {
        try {
            for (int n = this.m_listeners.size() - 1; n >= 0; --n) {
                WeakReference<Listener> weak = this.m_listeners.get(n);
                Listener listener = (Listener)weak.get();
                if (listener != null) {
                    listener.handleGenericObjectListener(sender, data);
                    continue;
                }
                this.m_listeners.remove(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener == null) {
                return;
            }
            for (WeakReference<Listener> weak : this.m_listeners) {
                Listener curr = (Listener)weak.get();
                if (!listener.equals(curr)) continue;
                return;
            }
            this.m_listeners.add(new WeakReference<Listener>(listener));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeAllListeners() {
        this.m_listeners.clear();
    }

    public static interface Listener {
        public void handleGenericObjectListener(Object var1, Object var2);
    }
}

