/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class ExceptionMonitorEntry
extends AbstractTableModel {
    public Exception Error;
    public String TimeAdded;
    protected StackTraceElement[] m_stackTraceElements;

    public ExceptionMonitorEntry(Exception err) {
        try {
            this.Error = err;
            Date date = new Date();
            this.TimeAdded = date.toString();
            this.m_stackTraceElements = err.getStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public StackTraceElement[] getStackTraceArray() {
        return this.m_stackTraceElements;
    }

    @Override
    public int getRowCount() {
        if (this.m_stackTraceElements == null) {
            return 0;
        }
        return this.m_stackTraceElements.length;
    }

    @Override
    public int getColumnCount() {
        if (this.m_stackTraceElements == null) {
            return 0;
        }
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (this.m_stackTraceElements == null) {
                return "";
            }
            if (row < 0 || row >= this.getRowCount()) {
                return "";
            }
            if (column < 0 || column >= 4) {
                return "";
            }
            if (column == 0) {
                return this.m_stackTraceElements[row].getClassName();
            }
            if (column == 1) {
                return this.m_stackTraceElements[row].getFileName();
            }
            if (column == 2) {
                return Integer.toString(this.m_stackTraceElements[row].getLineNumber());
            }
            if (column == 3) {
                return this.m_stackTraceElements[row].getMethodName();
            }
            return "";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Class name";
            }
            if (column == 1) {
                return "File name";
            }
            if (column == 2) {
                return "Line number";
            }
            if (column == 3) {
                return "Method name";
            }
            return "bad column";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "getColumnName exception";
        }
    }
}

