/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.IChangeLog;
import java.util.ArrayList;
import javax.swing.DefaultListModel;

public class ChangeLog_Flatirons
implements IChangeLog {
    public ArrayList<ChangeLogRelease> Changes = new ArrayList();
    protected static ChangeLog_Flatirons m_singleton = null;

    protected ChangeLog_Flatirons() {
        try {
            ChangeLogRelease release = this.addRelease("10/09/25", "25.10.09");
            release.Changes.add("Fixed error creating CSV files for Phoenix connection");
            release = this.addRelease("09/21/25", "25.09.21");
            release.Changes.add("Switched default database to SQLite from HyperSQL");
            release.Changes.add("Several database modifications to help with large surveys");
            release = this.addRelease("09/16/25", "25.09.16");
            release.Changes.add("Added help to the SEGY dictionary editor ");
            release = this.addRelease("09/05/25", "25.09.05");
            release.Changes.add("Huge data modification: Changed import code to remove dependence on XML. ");
            release.Changes.add("Huge data modification: Simplified trace table indexing scheme. ");
            release = this.addRelease("06/10/25", "25.06.10");
            release.Changes.add("Made a number of minor database mods to facilitate Phoenix interconnectivity");
            release.Changes.add("Modified default inversion options in VNS tomo");
            release = this.addRelease("12/20/24", "24.12.20");
            release.Changes.add("Added ability to have negative increments when merging");
            release = this.addRelease("11/25/24", "24.11.24");
            release.Changes.add("Fixed a number of minor issues in the P-SV code");
            release = this.addRelease("07/14/24", "24.07.14");
            release.Changes.add("Added ability to start MPI tomography inversions");
            release = this.addRelease("05/17/24", "24.05.17");
            release.Changes.add("Fixed and updated the delay time segy export code");
            release = this.addRelease("02/15/24", "24.02.15");
            release.Changes.add("Cleaned up database dependency code");
            release = this.addRelease("01/28/24", "24.01.28");
            release.Changes.add("Fixed major receiver sort creation bug ");
            release = this.addRelease("11/3/23", "23.11.03");
            release.Changes.add("Added option to toggle unlocked processes in the picker window");
            release = this.addRelease("11/3/23", "23.11.03");
            release.Changes.add("Added option to set database values using three point plane definition");
            release.Changes.add("Potential memory leak fixed in SEGY import");
            release = this.addRelease("9/25/23", "23.09.25");
            release.Changes.add("Added option to remove geometry error analysis frrom delay time sequence");
            release.Changes.add("Added a number of minor bug fixes and speed issues to ASCII import tools");
            release = this.addRelease("8/09/23", "23.08.09");
            release.Changes.add("Fixed polygon interpolation in VNS window");
            release.Changes.add("Added polygon extrapolation in VNS window");
            release = this.addRelease("5/31/23", "23.05.31");
            release.Changes.add("Fixed a number of issues relating to very small grid sizes");
            release.Changes.add("Fixed file copy code, can now handle any size file");
            release.Changes.add("Added binary trace table backup code, much faster than CSV backup");
            release = this.addRelease("5/08/23", "23.05.08");
            release.Changes.add("New import decimation option attempts to ensure similar fold for all receivers");
            release.Changes.add("Select output pick name in the Pick Nearest Time picker");
            release.Changes.add("Simple and fast dialog to add/subtract pick times");
            release.Changes.add("Compute option for MinOffset/MaxOffset added");
            release = this.addRelease("1/13/23", "23.01.13");
            release.Changes.add("Additional FlexLM licensing updates");
            release.Changes.add("Modified SEGY import to allow trace filtering based on receiver sensor number");
            release.Changes.add("Minor bug fixes");
            release = this.addRelease("12/09/22", "22.12.09");
            release.Changes.add("Updated FlexLM licensing code");
            release.Changes.add("Modified Trace Mixer to work with any group/sort");
            release.Changes.add("Added new trend export format");
            release = this.addRelease("5/24/22", "22.05.24");
            release.Changes.add("New uphole survey framework");
            release.Changes.add("Create a clone of the current VNS model");
            release.Changes.add("Import the delay time velocity model into a VNS model");
            release.Changes.add("Import the uphole survey model into a VNS model");
            release.Changes.add("Smooth the VNS model");
            release.Changes.add("Display delay time refractors on VNS profiles");
            release.Changes.add("New way of constraining tomography inversion");
            release = this.addRelease("4/7/22", "22.04.07");
            release.Changes.add("Two new shortcuts have been added to delay time modeling");
            release.Changes.add("Use database columns to define datums - delay time statics");
            release.Changes.add("Option to use picks to generate a spatially smooth moveout trend");
            release = this.addRelease("3/7/22", "22.03.07");
            release.Changes.add("Significant improvement in VNS tomography algorithm - better, higher resolution velocity fields");
            release = this.addRelease("2/25/22", "22.02.25");
            release.Changes.add("Moveout trend display - export trends to CSV files");
            release = this.addRelease("2/18/22", "22.02.18");
            release.Changes.add("Picker window - scroll/zoom horizontally using the mouse wheel");
            release.Changes.add("Picker window - added scrolling hot keys");
            release.Changes.add("Picker window - added zoom in/out hot keys");
            release.Changes.add("Color scales - Easy to share color scale ranges via global range");
            release = this.addRelease("1/25/22", "22.01.25");
            release.Changes.add("date time issue fixed");
            release = this.addRelease("1/14/22", "22.01.14");
            release.Changes.add("TomoVNS update extrapolation speed issue fixed");
            release = this.addRelease("1/7/22", "22.01.07");
            release.Changes.add("Fixed bug in 2D FFT filter");
            release.Changes.add("Added hot key to picker - toggles selected process");
            release.Changes.add("Save profile line options");
            release = this.addRelease("12/27/21", "21.12.27");
            release.Changes.add("Added 2D FFT filter to aid manual picking of very noisy data");
            release.Changes.add("Removed SQLite dependencies");
            release = this.addRelease("11/22/21", "21.11.22");
            release.Changes.add("Added option to save predicted travel times during VNS tomo update");
            release = this.addRelease("10/29/21", "21.10.29");
            release.Changes.add("Added Gridded Velocity Analysis");
            release.Changes.add("Added tools to simplify Phoenix connectivity");
            release = this.addRelease("7/30/21", "21.07.30");
            release.Changes.add("Added manual limits to Delay Time Velocity Analysis");
            release.Changes.add("Added brute stack process to help pick noisy data");
            release = this.addRelease("4/29/21", "21.04.29");
            release.Changes.add("* Added ability to run TomoVNS update in independent thread - allows use of rest of program while running *");
            release = this.addRelease("2/23/21", "21.02.23");
            release.Changes.add("Added ability to use shot gathers for branch assignment and moveout trends");
            release.Changes.add("Added additional options for amplitude onset picker");
            release.Changes.add("Added some VTI options to TomoVNS (constant delta/epsilon)");
            release = this.addRelease("3/31/20", "20.03.31");
            release.Changes.add("Delay time update now correctly ignores killed shots/receivers");
            release.Changes.add("Version used to create project is now logged in ProjectDescription.xml");
            release.Changes.add("Added hotkeys to linear moveout trend windows - use 'a' to add a point and 'f' to finish assigning trend");
            release.Changes.add("Removed Elevation from spatial smoothing dialog - added separate elevation smoothing option");
            release.Changes.add("Lowered minimum precomputed pick gather spacing and radius to 1");
            release.Changes.add("Lowered minimum offset bin size to 1");
            release.Changes.add("Fixed ProjectID numbering bug when merging merged projects");
            release.Changes.add("Fixed branch assignment CSV import/export");
            release.Changes.add("Added option to force traces to zero mean before stacking - to deal with biased traces");
            release = this.addRelease("12/23/19", "19.12.23");
            release.Changes.add("* TomoVNS and Eikonal models now save automatically after each iteration *");
            release.Changes.add("Added an option to select interpolated LMO trend as user-defined trend at any given location");
            release.Changes.add("Added screencapture button to LMO trend windows - must paste into drawing program after clicking button");
            release.Changes.add("Creating a TomoVNS or Eikonal model using the interactive model builder now correctly selects the new model in the respective tomo window");
            release.Changes.add("Expanded the allowed range of some plot display options");
            release.Changes.add("Pick copy dialog now provides a confirmation popup after successfully copying picks");
            release.Changes.add("Fixed a bug causing incorrect gather display when importing the trace table from a csv backup");
            release.Changes.add("Lowered the minimum refractor velocity smoothing radius in advanced delay time options");
            release.Changes.add("Added a pick import/export option using separate Shot/Receiver Line/Point (4 column)");
            release.Changes.add("Lowered minimum max/min offset difference in TomoVNS to 10 ft/m");
            release.Changes.add("Statics and tomo datum columns no longer appear in merge - this was causing a lot of clutter in merged projects");
            release.Changes.add("Eikonal/TomoVNS profiles now appear as white on minimap");
            release.Changes.add("Recently added VNS velocity limits are no longer on by default - added a toggle switch that is off by default");
            release = this.addRelease("9/25/19", "19.09.25");
            release.Changes.add("Fixed a bug in the prior release which resulted in ControlPointAdd not working in the stack picker");
            release.Changes.add("Added a custom combined Line/Point pick import");
            release.Changes.add("Added intermediate and final datum columns to Eikonal when using velocity as intermediate datum");
            release = this.addRelease("9/12/19", "19.09.12");
            release.Changes.add("Fixed display bug in TomoVNS mouseover text");
            release.Changes.add("Fixed a bug related to picking hidden traces not in selected branch");
            release.Changes.add("Re-enabled receiver sort and bin sort");
            release.Changes.add("Fixed a bug related to marine VNS model creation");
            release.Changes.add("Fixes to shallow tomo velocity modeling");
            release.Changes.add("* Fixed a major project merge bug *");
            release.Changes.add("Added rubber band polarity flip functionality");
            release.Changes.add("Fixed a marine import bug where Receiver PointDepth was not being imported");
            release = this.addRelease("2/11/19", "19.02.11");
            release.Changes.add("* Major Java-related performance fix for large surveys *");
            release.Changes.add("* Enabled project tracecounts greater than 2.1 billion *");
            release.Changes.add("* Allowed delay time and TomoVNS to run with more than 2.1 billion traces *");
            release.Changes.add("* Added ability to import velocity SEG-Y into existing TomoVNS model *");
            release.Changes.add("Fixed a bug related to using fixed velocity for intermediate datums in TomoVNS");
            release.Changes.add("Added a reversed rainbow color scale default");
            release.Changes.add("TomoVNS now stores initial parameters in history");
            release = this.addRelease("8/15/18", "18.08.15");
            release.Changes.add("Added optional dynamic range compression to delay time update - see advanced options");
            release.Changes.add("Enabled use of a velocity as intermediate datum for TomoVNS");
            release.Changes.add("Added optional minimum forced velocity increase to TomoVNS update");
            release.Changes.add("Added option to highlight selected intermediate datum");
            release = this.addRelease("5/14/18", "18.05.14");
            release.Changes.add("Fixed a bug related to opening projects in the prior release");
            release.Changes.add("Fixed a pick copy bug");
            release.Changes.add("Fixed a bug in the stack picker causing picks < 0 to not be killed");
            release.Changes.add("Changed TomoVNS and Eikonal3D code to handle memory errors on large surveys");
            release.Changes.add("Allow polygon limits for GLI pick file export");
            release.Changes.add("Added Velocity at Constant Elevation option to TomoVNS model Map View");
            release.Changes.add("Fixed a critical TomoVNS model bug in 18.05.08 release - this release replaces that one");
            release = this.addRelease("2/21/18", "18.02.21");
            release.Changes.add("* Significant upgrade to TomoVNS interpolator *");
            release.Changes.add("* Added support for uphole surveys *");
            release.Changes.add("* Added ability to add SEG-Y files to existing projects (does not work with marine decimation yet) *");
            release.Changes.add("Fixed/improved several other interpolators");
            release.Changes.add("Added a picker hotkey to display trace header info");
            release.Changes.add("Fixed some state-related database bugs");
            release.Changes.add("Fixed a bug where ensemble workers did not reload properly");
            release.Changes.add("Some changes to project handling logic");
            release = this.addRelease("10/9/17", "17.10.09");
            release.Changes.add("Fixed issues in TomoVNS interpolator");
            release = this.addRelease("9/20/17", "17.09.20");
            release.Changes.add("Added mouseover text data display to tomo profiles");
            release.Changes.add("Added polygon pick kill option to delay time pick histogram");
            release.Changes.add("Added greyscale option for profile QC stacks");
            release = this.addRelease("8/8/17", "17.08.08");
            release.Changes.add("Fixed bug in shot/receiver stack picker inline/crossline grouping");
            release = this.addRelease("7/28/17", "17.07.28");
            release.Changes.add("Allow grouping by inline/crossline in shot/receiver stack picker");
            release.Changes.add("Added some zoom locking options");
            release = this.addRelease("7/14/17", "17.07.14");
            release.Changes.add("Fixed major autopicker bug");
            release.Changes.add("Fixed marine import");
            release = this.addRelease("6/9/17", "17.06.09");
            release.Changes.add("Fixed a bug introduced in prior release that prevented receiver gathers from loading");
            release = this.addRelease("6/1/17", "17.06.01");
            release.Changes.add("Added ability to define custom node spacing for VNS");
            release.Changes.add("Fixed a bug related to merging projects");
            release.Changes.add("Lowered some minimum allowed values for spacing and sample interval");
            release = this.addRelease("4/7/17", "17.04.07");
            release.Changes.add("Fixed a small bug preventing certain projects from being built in compressed mode");
            release = this.addRelease("4/4/17", "17.04.04");
            release.Changes.add("Added a few things to tomo SEG-Y output");
            release.Changes.add("Improvements made to VNS wavefront propagation");
            release.Changes.add("Added some tomo profile options");
            release.Changes.add("Added support for Paradigm 17");
            release = this.addRelease("3/7/17", "17.03.07");
            release.Changes.add("Added change to SEG-Y viewer");
            release.Changes.add("Added CDP header to output tomo velocity SEG-Y files");
            release.Changes.add("Added receiver display on mouse move to main Basemap");
            release.Changes.add("Added Close functionality to SEG-Y/Dictionary Editor");
            release.Changes.add("Added ability to display details of VNS model");
            release.Changes.add("Fixed a bug in both eikonal and VNS tomography related to float/double accuracy");
            release.Changes.add("Fixed a bug in both eikonal and VNS tomography related to threading");
            release.Changes.add("Cleaned up some menu items");
            release = this.addRelease("12/2/16", "16.12.02");
            release.Changes.add("Added ability to kill picks outside time window in autopickers");
            release.Changes.add("Fixed issue with Paradigm-15.5 connectivity");
            release.Changes.add("Minor changes to VNS tomography");
            release = this.addRelease("10/10/16", "16.10.10");
            release.Changes.add("Added support for Paradigm 15.5");
            release.Changes.add("Trace table now properly stores picks as floats");
            release.Changes.add("Various minor bug fixes");
            release.Changes.add("Minor changes to VNS tomography");
            release.Changes.add("Significantly lowered minimum location separation limit in Tomo interactive model builder");
            release = this.addRelease("8/11/16", "16.08.11");
            release.Changes.add("Decreased minimum allowed tomo node spacing to 1 ft/m");
            release.Changes.add("Fixed a bug that caused tomo to not ignore killed picks");
            release.Changes.add("Fixed a localization bug related to decimal separators in slider");
            release = this.addRelease("7/15/16", "16.07.15");
            release.Changes.add("Fixed a localization bug related to decimal separators on import");
            release.Changes.add("Small bug fixes to tomography");
            release = this.addRelease("6/20/16", "16.06.20");
            release.Changes.add("Water velocity in Tomo interactive model now set properly");
            release.Changes.add("Various small bug fixes in Tomo");
            release.Changes.add("Velocity smoothing change");
            release = this.addRelease("3/30/16", "16.03.30");
            release.Changes.add("Added option to display predicted picks for both Tomo and DT");
            release.Changes.add("Allows user to set Epos username for Echos functions");
            release = this.addRelease("3/17/16", "16.03.17");
            release.Changes.add("Small bug fixes to tomography");
            release.Changes.add("Increased max number of samples for SEG-Y output");
            release.Changes.add("Fixed a bug related to Echos import");
            release = this.addRelease("1/13/16", "16.01.13");
            release.Changes.add("Added export picks using FFID/Receiver PointNumber");
            release.Changes.add("Numerous bug fixes");
            release = this.addRelease("12/3/15", "15.12.03");
            release.Changes.add("Fixed a bug related to Echos spreadsheet import");
            release = this.addRelease("11/24/15", "15.11.24");
            release.Changes.add("Can now use uphole survey to constrain VNS velocity model");
            release.Changes.add("Additional fixes to grid smoothing");
            release.Changes.add("Fixed a bug releated to grid smoothing at very large radii");
            release.Changes.add("TomoVNS add TOMOVNS_MAXDEPTH column to shot/rec tables when max depth viewed");
            release.Changes.add("Exception logs now save the version number");
            release.Changes.add("Now saves list of original SEG-Y files used to create project");
            release.Changes.add("Basemap display now shows average value for selected column");
            release.Changes.add("Added Echos integration");
            release = this.addRelease("9/16/15", "15.09.16");
            release.Changes.add("Fixed a bug related to tracking in the threshold auto picker");
            release = this.addRelease("9/14/15", "15.09.14");
            release.Changes.add("TomoVNS update - added ability to turn off smoothing (set to zero)");
            release.Changes.add("TomoVNS - added ability to create model using interactive model builder");
            release.Changes.add("TomoVNS - Travel times through water layer now computed for display purposes");
            release = this.addRelease("7/21/15", "15.07.21");
            release.Changes.add("Added ability to lock shallow velocity during TomoVNS update");
            release.Changes.add("Added extra options for pick export");
            release = this.addRelease("7/13/15", "15.07.13");
            release.Changes.add("Fixed a critical stacking bug");
            release = this.addRelease("7/7/15", "15.07.07");
            release.Changes.add("Fixed a bug related to Tomography stacks not being displayed");
            release = this.addRelease("7/6/15", "15.07.06");
            release.Changes.add("Significant TomoVNS fix");
            release.Changes.add("Added option to limit shot/receiver stacks to polygon");
            release.Changes.add("Removed requirement that data be shot sorted when autopicking");
            release = this.addRelease("6/19/15", "15.06.19");
            release.Changes.add("Significant improvements made to all tomo methods");
            release.Changes.add("Checking for duplicates in shot/rec table causes Duplicate flag to be set");
            release = this.addRelease("6/15/15", "15.06.15");
            release.Changes.add("VNS tomography algorithm updated, bugs fixed");
            release.Changes.add("Removed an unused licensing function that could potentially cause issues with checkout");
            release = this.addRelease("6/10/15", "15.06.10");
            release.Changes.add("Shot/receiver delay time stacks now honor killed traces");
            release.Changes.add("VNS tomo update optimized");
            release = this.addRelease("6/2/15", "15.06.02");
            release = this.addRelease("5/22/15", "15.05.22");
            release.Changes.add("Can now define grid using three corners");
            release.Changes.add("Option to export Eikonal tomo model using project grid");
            release.Changes.add("Added trace data value display to SEGY view dialog");
            release.Changes.add("Added checks for valid SHOTID");
            release.Changes.add("Temporarily disabled refraction database backup for files that are too large");
            release = this.addRelease("4/23/15", "15.04.23");
            release.Changes.add("Added automatic backup of refraction database whenever project is opened");
            release.Changes.add("Added option to manually back up refraction database - second option under Database menu");
            release.Changes.add("Added line color display when viewing receivers");
            release.Changes.add("Basemap window - grid interpolation can now use shots and/or receivers");
            release.Changes.add("Recompute total fold for shots and receivers (under Picking menu)");
            release = this.addRelease("4/6/15", "15.04.06");
            release.Changes.add("Fixed  bug model profile display window");
            release.Changes.add("SEG-Y and dictionary editor is now a stand-alone window");
            release.Changes.add("Added option display delay time model results as a grid");
            release.Changes.add("Added reload all plots button in MultMap");
            release.Changes.add("Added AGC option to put output sample at bottom of time window");
            release = this.addRelease("3/27/15", "15.03.27");
            release.Changes.add("Fixed minor geometry database display bug");
            release = this.addRelease("3/26/15", "15.03.26");
            release.Changes.add("Fixed major error handling bug related to logging of application exceptions");
            release = this.addRelease("3/6/15", "15.03.06");
            release.Changes.add("Fixed possible bug in pick copy dialog");
            release.Changes.add("Added option to control velocity variation limits in delay time analysis");
            release.Changes.add("Minor bug fixes");
            release = this.addRelease("2/27/15", "15.02.27");
            release.Changes.add("Added new tomography algorithm - node spacing varies on Z axis");
            release.Changes.add("Improved code that creates shot/receiver stacks");
            release.Changes.add("Modified delay time anisotropy code");
            release.Changes.add("Added column filter option during project import");
            release.Changes.add("Added offset limits for killing picks");
            release.Changes.add("Added option to control anisotropic delay time grid size");
            release.Changes.add("Added option to control max allowed delay time anisotropy");
            release.Changes.add("Fixed bug when using hot key to copy auto picks to user picks");
            release.Changes.add("Added creation options to tomo history");
            release.Changes.add("Minor fix to boundary conditions for receivers in tomography");
            release.Changes.add("Raised trace display limits in Shot/Receiver stacks");
            release = this.addRelease("11/21/14", "14.11.21");
            release.Changes.add("Fixed UNC Paths on windows for accessing data files across a mapped network drive.");
            release.Changes.add("Changed Versioning numbers to: YEAR.MONTH.DAY");
            release = this.addRelease("11/7/14", "1.7.0");
            release.Changes.add("Can now define polygon while zooming/unzooming");
            release.Changes.add("Many changes to tomography, including:");
            release.Changes.add("Ability to create new model by smoothing current model");
            release.Changes.add("Ability to create new model by specifying new node spacings and depth");
            release.Changes.add("Initialize tomo velocity field using delay time model");
            release = this.addRelease("10/29/14", "1.6.3");
            release.Changes.add("Fixed bug related to project name entry in previous release");
            release = this.addRelease("10/23/14", "1.6.2");
            release.Changes.add("Tomography can now handle much larger surveys (even larger than before)");
            release.Changes.add("Added option to immediately unkill shots or receivers in Stack Picker");
            release = this.addRelease("9/22/14", "1.6.2b");
            release.Changes.add("Beta code for shear statics (converted wave)");
            release = this.addRelease("9/19/14", "1.6.1");
            release.Changes.add("Added code to import DT info from other projects");
            release = this.addRelease("9/12/14", "1.6.0");
            release.Changes.add("Bug fixes from previous two removed releases");
            release = this.addRelease("8/23/14", "1.5.8");
            release.Changes.add("Tomography test code changes");
            release.Changes.add("Projects now have .xtref extension");
            release = this.addRelease("8/12/14", "1.5.7");
            release.Changes.add("Massive changes to tomography code - beta");
            release = this.addRelease("6/18/14", "1.5.6");
            release.Changes.add("Significant improvements to tomo statics computation options");
            release = this.addRelease("6/16/14", "1.5.5");
            release.Changes.add("Added KillPicksUsingDelayTimeSolution hot key - works with geometry correction display in upper-left picker window");
            release.Changes.add("Fixed a bug related to profiles");
            release.Changes.add("Added an 'Exit Flatirons' option to the 'Project' menu");
            release = this.addRelease("5/27/14", "1.5.4");
            release.Changes.add("Added axis locking icons to several map displays");
            release.Changes.add("Added ability to create stacks for all profiles, versions, and statics fields automatically");
            release.Changes.add("Added histogram displays to column difference window, basemap, and delay time model window");
            release.Changes.add("Fixed some bugs in the Shot/Receiver stack picker");
            release = this.addRelease("4/24/14", "1.5.3");
            release.Changes.add("Added approximate node hit count to tomography analysis");
            release.Changes.add("Tomography node hit counts may be displayed in profile and map views");
            release.Changes.add("Tomography node hit counts may be exported to SEG-Y");
            release = this.addRelease("4/14/14", "1.5.2");
            release.Changes.add("Pick color in Shot/Receiver stacks can now be changed");
            release.Changes.add("Users now have some control over font sizes - look under the Windows menu");
            release.Changes.add("A new tomography update algorithm has been added. It can handle far larger surveys but is ~15% slower");
            release = this.addRelease("3/31/14", "1.5.1");
            release.Changes.add("Can now set license server location using environment variables");
            release = this.addRelease("3/11/14", "1.5.0");
            release.Changes.add("Picks persist in the Shot/Receiver stack picker");
            release.Changes.add("Automated restack capability Shot/Receiver stack picker");
            release.Changes.add("Fixed a bug related to 'ControlPointAdd' in Shot/Receiver stack picker");
            release.Changes.add("Fixed internal bugs");
            release = this.addRelease("2/5/14", "1.4.9");
            release.Changes.add("Fixed some internal bugs");
            release = this.addRelease("2/3/14", "1.4.8");
            release.Changes.add("Fixed a bug in the interactive model builder");
            release = this.addRelease("1/27/14", "1.4.7");
            release.Changes.add("Minor bug fixes");
            release = this.addRelease("12/28/13", "1.4.6");
            release.Changes.add("Removed calendar event that terminates program after December 27");
            release = this.addRelease("12/11/13", "1.4.5");
            release.Changes.add("Added ability to import SPS files and populate SEG-Y headers");
            release = this.addRelease("11/20/13", "1.4.4");
            release.Changes.add("'Show shots/receivers' bug fixed in Multimap");
            release.Changes.add("Can now interpolate to grid in Basemap");
            release.Changes.add("Pen mode option added to picker");
            release.Changes.add("Added model-building with user-defined LVL data");
            release = this.addRelease("10/15/13", "1.4.3");
            release.Changes.add("Added a 'no event' option to the 'Shift user picks' tool in the picker");
            release = this.addRelease("10/02/13", "1.4.2");
            release.Changes.add("Fixed a bug that was causing output tomo velocities to be truncated");
            release = this.addRelease("10/01/13", "1.4.1");
            release.Changes.add("Shared trace table code tweaks");
            release.Changes.add("Added DTA_BadPickCount output to delay time analysis");
            release.Changes.add("Worked on statics computation code");
            release = this.addRelease("8/26/13", "1.4.0");
            release.Changes.add("Updated the tomography code");
            release.Changes.add("Customizable double click interval");
            release = this.addRelease("8/6/13", "1.3.7");
            release.Changes.add("Fixed trace table indexing bug on very large surveys");
            release.Changes.add("Added ability to extrapolate outside smoothed polygon");
            release = this.addRelease("8/5/22", "1.3.6");
            release.Changes.add("New display added to compare different project data (Database --> Compare other project...)");
            release.Changes.add("Processing sequence my be displayed on either side of picker window");
            release.Changes.add("Optional pick time shift added to tomo analysis");
            release = this.addRelease("7/22/13", "1.3.5");
            release.Changes.add("Multiple basemap display");
            release.Changes.add("Tomography statics computation - compute intermediate datum at velocity");
            release.Changes.add("Segy  export - killed traces/shots/receivers marked as TraceCode 2");
            release = this.addRelease("7/3/13", "1.3.4");
            release.Changes.add("Export tomography velocity model to SEGY file'");
            release.Changes.add("Modified picking to honor zoom viewport'");
            release = this.addRelease("5/17/13", "1.3.3");
            release.Changes.add("Project names may contain '-' and '_'");
            release.Changes.add("Uphole information may be used to constrain tomographic velocities");
            release.Changes.add("Single-trace polarity flip hot key fixed");
            release = this.addRelease("4/25/13", "1.3.2");
            release.Changes.add("ASCII export from trace table added");
            release.Changes.add("User-selectable refractor velocity smoothing radius");
            release = this.addRelease("3/25/13", "1.3.1");
            release.Changes.add("Users may now select the minimum valid fold for delay time analysis");
            release.Changes.add("Picker navigation display - up to three columns may be used for filtering");
            release.Changes.add("Batch trace kill option bug fixed");
            release = this.addRelease("3/12/13", "1.3.0");
            release.Changes.add("Added new picker window to display multiple offset gathers");
            release.Changes.add("Fixed bug in the tomo display code");
            release.Changes.add("Application now saves list of open tabs when closed; 'Load saved tabs' option added.");
            release = this.addRelease("1/18/13", "1.2.9");
            release.Changes.add("Fixed minor issue with SQL string construction");
            release = this.addRelease("1/7/13", "1.2.8");
            release.Changes.add("All SQL query strings saved");
            release = this.addRelease("12/31/12", "1.2.7");
            release.Changes.add("Added predicted error vectors to the picker basemap display");
            release.Changes.add("User can select to update branch during geom correction");
            release = this.addRelease("12/28/12", "1.2.6");
            release.Changes.add("Fixed shot polarity bug in shot/receiver stack window");
            release.Changes.add("Fixed yet another issue with importing picks");
            release = this.addRelease("12/10/12", "1.2.5");
            release.Changes.add("Linear moveout trend using traces dialog has significant imporovements");
            release.Changes.add("Added worker which can remove traces based on floating point header values");
            release.Changes.add("Project units may be changed");
            release = this.addRelease("12/6/12", "1.2.4");
            release.Changes.add("Added option to open SEG-Y viewer/dictionary editor to application 'Project' menu.");
            release.Changes.add("Closing SEG-Y viewer/dictionary editor no longer exits program.");
            release = this.addRelease("12/4/12", "1.2.3");
            release.Changes.add("Gray scale trace plotting in picker window");
            release.Changes.add("Importing FBP_USER bug fixed");
            release = this.addRelease("11/15/12", "1.2.2");
            release.Changes.add("Added ability to smooth within polygon");
            release = this.addRelease("11/14/12", "1.2.1");
            release.Changes.add("Numerous bug fixes/updates");
            release = this.addRelease("10/23/12", "1.2.0");
            release.Changes.add("Beta version of 3D tomography - single cpu version");
            release.Changes.add("Can now drag receivers in picker basemap window");
            release.Changes.add("Hot key to kill current shot/receiver");
            release = this.addRelease("10/17/12", "1.1.32");
            release.Changes.add("Can plot branch locations on basemap");
            release = this.addRelease("10/15/12", "1.1.32");
            release.Changes.add("Fixed bug which reset anisotropy data");
            release.Changes.add("Added input data processing flow, used to tie dynamite/vibe surveys");
            release.Changes.add("Added Flag column to shot/receiver table. Flags may be set in shot/receiver stack window");
            release.Changes.add("Added new delay time model profile window, found under Delaytime menu");
            release.Changes.add("Added fold plots to basemap");
            release = this.addRelease("9/27/12", "1.1.31");
            release.Changes.add("Pick window spider plot modified, kill and select options added");
            release = this.addRelease("9/24/12", "1.1.30");
            release.Changes.add("Some branch assignment options saved, unzoom irritant fixed");
            release = this.addRelease("9/20/12", "1.1.29");
            release.Changes.add("Added rubber band trace kill");
            release.Changes.add("Added batch process to kill traces with DC bias");
            release = this.addRelease("9/18/12", "1.1.28");
            release.Changes.add("Modified project merge logic to enamble line/point/ffid increments");
            release = this.addRelease("9/11/12", "1.1.23");
            release.Changes.add("Option to import multiple projects simultaneously");
            release.Changes.add("Option to open project without having to shut program down first (BETA!!!!)");
            release.Changes.add("Database display aimed at 2D surveys (beta)");
            release = this.addRelease("8/29/12", "1.1.22");
            release.Changes.add("New delay time shift options in branch window");
            release.Changes.add("Added FFID/Channel pick IO");
            release = this.addRelease("8/27/12", "1.1.21");
            release.Changes.add("Added bulk time shift to statics wizard");
            release.Changes.add("Fixed bug in color scale");
            release.Changes.add("Fixed bug in 2D tomography");
            release.Changes.add("Lots of changes to the segy import wizard");
            release.Changes.add("Modified the column math dialog");
            release.Changes.add("Modified shot/receiver database windows");
            release.Changes.add("Sort the shot/receiver tables by clicking on a column header");
            release.Changes.add("Fixed bug in 2D tomography");
            release.Changes.add("Added percent complete and ETA to progress bars");
            release = this.addRelease("8/20/12", "1.1.20");
            release.Changes.add("Added option to color trace background by receiver linenumber");
            release.Changes.add("Beta version of multi shot pick window.");
            release = this.addRelease("8/13/12", "1.1.19");
            release.Changes.add("Added rubberband picking modes");
            release.Changes.add("Fixed bug in prior pick logic that prevented picks from being deleted");
            release = this.addRelease("8/7/12", "1.1.18");
            release.Changes.add("Confirm that app has read/write permissions in safe way");
            release.Changes.add("Fixed off-by-one Fold count");
            release.Changes.add("Fixed severe issue with very low fold receivers");
            release = this.addRelease("8/3/12", "1.1.17");
            release.Changes.add("Can now drag shots from within picker basemap window");
            release.Changes.add("Pick version colors and sizes shared between windows");
            release.Changes.add("Pick event selection now shared between windows");
            release.Changes.add("Descending sort order option in picker window navigation tab");
            release.Changes.add("New hot key - pick event nearest cursor time");
            release.Changes.add("Most hot keys are now active when the cursor is over the basemap");
            release = this.addRelease("7/16/12", "1.1.16");
            release.Changes.add("New inline/crossline offset pick window");
            release.Changes.add("Option to compute V0 from uphole information");
            release = this.addRelease("7/3/12", "1.1.15");
            release.Changes.add("2D tomography - beta version");
            release.Changes.add("Delay time errors now updated when new picks made");
            release = this.addRelease("6/28/12", "1.1.14");
            release.Changes.add("Re-worked the theshold autopicker logic");
            release.Changes.add("Grid definition now done automatically");
            release.Changes.add("Dragger dialog now works with receivers");
            release.Changes.add("Application can now be extended with user code...details to follow");
            release = this.addRelease("6/6/12", "1.1.13");
            release.Changes.add("ScreenCapture menu no longer visible when making screencapture");
            release = this.addRelease("6/5/12", "1.1.12");
            release.Changes.add("Added kill buttons to tabs");
            release = this.addRelease("6/4/12", "1.1.11");
            release.Changes.add("Traces may be displayed using wiggles in the stack comparison window");
            release.Changes.add("Group navigation skips empty groups");
            release.Changes.add("Fixed bug in picker causing multiple refeshes");
            release.Changes.add("Modified the threshold auto picker, perhaps for the better");
            release.Changes.add("Numerous minor bug fixes and enhancements");
            release = this.addRelease("5/29/12", "1.1.10");
            release.Changes.add("Modified the layout of several windows to make the program usable on small laptop screens");
            release.Changes.add("New hot key option added - AddSinglePickNoSnap. Does not snap to nearest event");
            release.Changes.add("Added restrictions to limit the number of columns which may be added to the trace table");
            release.Changes.add("Numerous minor bug fixes and enhancements");
            release = this.addRelease("5/23/12", "1.1.09");
            release.Changes.add("Added shot/receiver pick counter - look under Picking ==> Compute shot/receiver pick count ");
            release.Changes.add("Bug fixed in prior pick logic - picks naw saved in database");
            release = this.addRelease("5/21/12", "1.1.08");
            release.Changes.add("Added duplicate entry analysis to shot and receiver tables");
            release.Changes.add("Added ability to select hidden shots and receivers in the picker window");
            release = this.addRelease("5/18/12", "1.1.07");
            release.Changes.add("Added hot keys to copy auto picks to user picks");
            release.Changes.add("DATUM_FINAL now set to correct value when computing statics");
            release.Changes.add("Some parameters saved in the model building window");
            release.Changes.add("Fixed import bug - handles column names with spaces or special characters");
            release.Changes.add("Fixed trace mixer bug - handles killed traces");
            release.Changes.add("Improved prior-pick logic");
            release = this.addRelease("5/16/12", "1.1.06");
            release.Changes.add("Added option to recreate trace table indices - used for recovery");
            release.Changes.add("Fixed table editing bug - database values may be directly edited in table now");
            release = this.addRelease("5/15/12", "1.1.05");
            release.Changes.add("Fixed bug in Apply Delay Time Shifts module");
            release = this.addRelease("5/14/12", "1.1.04");
            release.Changes.add("QC stack issue fixed(?) ");
            release.Changes.add("Trend curve definition handles improper user input");
            release.Changes.add("Semblance computation improved");
            release = this.addRelease("5/4/12", "1.1.03");
            release.Changes.add("Option to save screen captures as jpeg");
            release.Changes.add("Bug fixed in profile QC stacks");
            release = this.addRelease("4/30/12", "1.1.02");
            release.Changes.add("Added SEG-Y viewing to the new SEG-Y import wizard");
            release.Changes.add("Added an option to limit the number of traces scanned in the new SEG-Y import wizard");
            release.Changes.add("Cleaned up the new profile-based offset picker window");
            release = this.addRelease("4/27/12", "1.1.01");
            release.Changes.add("Fixed a bug in the threshold autopicker");
            release.Changes.add("Added fold to the shot/receiver tables (set on import)");
            release.Changes.add("Picker window - select on any unique column (not just ID)");
            release = this.addRelease("4/25/12", "1.1.0");
            release.Changes.add("New picker window, picks offset plane gathers generated from 2D profiles (Beta!)");
            release.Changes.add("Zero-mean option when applying linear moveout - surprisingly useful!");
            release.Changes.add("Added optional database restrictions in the pick copy dialog");
            release.Changes.add("Fixed problem killing picks in moveout trend dialog");
            release = this.addRelease("4/20/12", "1.0.15");
            release.Changes.add("Branch assignment dialog modified extensively");
            release.Changes.add("Bug in SP1 import fixed");
            release.Changes.add("Reworking profile manager code....");
            release = this.addRelease("4/19/12", "1.0.14");
            release.Changes.add("Shot/receiver stack window now has splitter-resize arrows. ");
            release.Changes.add("Added scroll bars to delay time model window");
            release.Changes.add("Fixed issue with polygon usage in model building window");
            release.Changes.add("Modify model dialog defaults to editing column you are currently viewing in the map");
            release.Changes.add("Movement vectors only drawn if shot/receiver moved");
            release.Changes.add("Sorting by trace azimuth in the picker window fixed");
            release.Changes.add("User selected shot/receiver symbols in model window");
            release.Changes.add("Fixed receiver ID / shot ID confusion on geometry update");
            release = this.addRelease("4/18/12", "1.0.13");
            release.Changes.add("Shot/receiver stack window now has user-defined navigation order. ");
            release.Changes.add("After killing a shot (or receiver) the picker moves to the next shot (or receiver) in the navigation order");
            release.Changes.add("Wiggle display options added to shot/receiver stacks display");
            release.Changes.add("Added DC Bias measure to Noise level worker");
            release.Changes.add("The new SEG-Y project import wizard is a work in progress");
            release = this.addRelease("4/16/12", "1.0.12");
            release.Changes.add("Sparse CMP gathers may be used to pick stacking velocities (much faster for large 3D surveys)");
            release.Changes.add("AzimuthMoved now computed, in addition to DistanceMoved");
            release.Changes.add("Bug in statics computation fixed");
            release.Changes.add("Must always use an intermediate datum");
            release = this.addRelease("4/16/12", "1.0.11");
            release.Changes.add("ASCII column-delimited import (Database ==> Import ==> Open ASCII import window) WORK IN PROGRESS!!");
            release.Changes.add("Added boolean trace selection worker (used in batch-only mode for now)");
            release = this.addRelease("4/13/12", "1.0.10");
            release.Changes.add("Added change log");
            release.Changes.add("Added scroll bars in main basemap display");
            release.Changes.add("Branch interpolation method option - inverse square or inverse fourth");
            release = this.addRelease("4/12/12", "1.0.09");
            release.Changes.add("Use sparse CMP gathers in pick window");
            release.Changes.add("Geometry error spider plot in pick window");
            release.Changes.add("Added new hot keys");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public String currentDate() {
        try {
            return this.Changes.get((int)0).Date;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    @Override
    public String currentVersion() {
        try {
            ChangeLogRelease release = this.Changes.get(0);
            return release.Version;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    public static ChangeLog_Flatirons singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new ChangeLog_Flatirons();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public DefaultListModel<String> getListModel() {
        try {
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (ChangeLogRelease release : this.Changes) {
                model.addElement("Version: " + release.Version + "   Date: " + release.Date);
                for (String change : release.Changes) {
                    model.addElement("    " + change);
                }
                model.addElement("    ");
            }
            return model;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected ChangeLogRelease addRelease(String date, String version) {
        try {
            ChangeLogRelease release = new ChangeLogRelease(date, version);
            this.Changes.add(release);
            return release;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static class ChangeLogRelease {
        public String Date = "";
        public String Version = "";
        public ArrayList<String> Changes = new ArrayList();

        public ChangeLogRelease(String date, String version) {
            this.Date = date;
            this.Version = version;
        }
    }
}

