/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Segy;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Segy_Dictionary
extends AbstractTableModel {
    protected ArrayList<Entry> m_mapEntries = new ArrayList();
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected Entry m_coordinateScalarEntry = null;
    protected Entry m_elevationScalarEntry = null;
    protected Entry m_timeScalarEntry = null;
    public String m_fileName = "";
    public boolean m_fileNameValid = false;
    public static String FileSuffix = "SegyDictXML";
    protected boolean m_sendModMessage = true;
    protected ByteBuffer m_testBuffer = ByteBuffer.allocate(240);
    protected int m_firstTraceIndex = -999;
    protected String m_testHeaderLabel = "";
    protected String m_testDatabaseLabel = "";
    protected int TotalDumps = 0;
    public String PreStackErrorMessage = "";
    protected ArrayList<RequiredPair> m_requiredList = new ArrayList();
    public String ReasonNotValidPostStack = "";
    public boolean ShowTestColumnsInTable = true;

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public void setTestData(byte[] data, int firstTraceIndex, ByteOrder order) {
        try {
            this.m_firstTraceIndex = -999999;
            for (Entry e : this.m_mapEntries) {
                e.TestDatabase = "";
                e.TestHeader = "";
            }
            if (data == null) {
                this.fireTableDataChanged();
                return;
            }
            if (data.length != 240) {
                this.fireTableDataChanged();
                return;
            }
            if (firstTraceIndex < 0) {
                this.fireTableDataChanged();
                return;
            }
            this.m_firstTraceIndex = firstTraceIndex;
            this.m_testHeaderLabel = "QC: Header value, " + Integer.toString(this.m_firstTraceIndex + 1);
            this.m_testDatabaseLabel = "QC: Database value, " + Integer.toString(this.m_firstTraceIndex + 1);
            this.m_testBuffer.rewind();
            this.m_testBuffer.put(data);
            this.m_testBuffer.order(order);
            this.computeTestValues();
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean isFileNameValid() {
        return this.m_fileNameValid;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setOpenFileName(String fileName) {
        try {
            this.m_mapEntries.clear();
            this.m_fileNameValid = false;
            this.m_fileName = "";
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.fireTableDataChanged();
                return;
            }
            if (!fileName.toLowerCase().endsWith(FileSuffix.toLowerCase())) {
                this.fireTableDataChanged();
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readContentsFromNode(root);
            this.m_fileNameValid = true;
            this.m_fileName = fileName;
            this.fireTableDataChanged();
            this.handleMod(true, false, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileName = Tools_Strings.confirmSuffix(fileName, FileSuffix);
            this.m_fileNameValid = true;
            this.save();
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            if (!this.m_fileNameValid) {
                return;
            }
            if (this.m_fileName.length() < 2) {
                return;
            }
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("SegyDictionary");
            document.appendChild(root);
            this.writeContentsToNode(root);
            Tools_XML.writeDocumentToFile(document, this.m_fileName);
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            try {
                this.m_mapEntries.clear();
                this.m_fileNameValid = false;
                this.m_fileName = "";
                this.fireTableDataChanged();
            }
            catch (Exception error2) {
                ExceptionMonitor.add(error2);
            }
            return;
        }
    }

    public ArrayList<String> columns(String tableName) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Entry e : this.m_mapEntries) {
                if (!e.Table.equalsIgnoreCase(tableName)) continue;
                list.add(e.Column);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void computeTestValues() {
        try {
            for (Entry e : this.m_mapEntries) {
                e.TestDatabase = "";
                e.TestHeader = "";
            }
            if (this.m_firstTraceIndex < 0) {
                return;
            }
            this.prepareSeismicHeaderDictionary(null);
            this.fillTraceHeader(this.m_testBuffer, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleMod(boolean fireTableMod, boolean bSave, Object modData) {
        try {
            if (fireTableMod) {
                this.computeTestValues();
                this.fireTableDataChanged();
            }
            if (bSave) {
                this.save();
            }
            this.m_listenerManager.broadcast(this, modData);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected double getScalar(Entry entry, ByteBuffer traceHeaderByteBuffer) {
        return this.getScalar(entry, 0, traceHeaderByteBuffer);
    }

    protected double getScalar(Entry entry, int buffOffset, ByteBuffer traceHeaderByteBuffer) {
        try {
            if (entry == null) {
                return 1.0;
            }
            if (!entry.Valid) {
                return entry.DefaultValue;
            }
            int scalar = 0;
            if (entry.HeaderType == DataType.Short) {
                scalar = traceHeaderByteBuffer.getShort(buffOffset + entry.FirstByte);
            }
            if (entry.HeaderType == DataType.Int) {
                scalar = traceHeaderByteBuffer.getInt(buffOffset + entry.FirstByte);
            }
            if (scalar >= 1) {
                return scalar;
            }
            if (scalar == 0) {
                return 1.0;
            }
            return -1.0 / (double)scalar;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 1.0;
        }
    }

    public void prepareEnsembleHeaderDictionary(EnsembleHeaderDictionary headerDict) {
        try {
            this.m_coordinateScalarEntry = null;
            this.m_elevationScalarEntry = null;
            this.m_timeScalarEntry = null;
            for (Entry entry : this.m_mapEntries) {
                entry.HeaderIndex = -9999;
                if (!headerDict.containsEntry(entry.Table, entry.Column)) continue;
                entry.HeaderIndex = headerDict.getEntryIndex(entry.Table, entry.Column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void copyHeaderToBuffer(Column_Abstract header, ByteBuffer buff) {
        try {
            byte[] bytes = buff.array();
            for (int n = 0; n < bytes.length; ++n) {
                bytes[n] = 0;
            }
            for (Entry entry : this.m_mapEntries) {
                if (entry.HeaderIndex < 0) continue;
                try {
                    if (entry.HeaderType == DataType.Byte) {
                        buff.put(entry.FirstByte, (byte)header.getInt(entry.HeaderIndex));
                    }
                    if (entry.HeaderType == DataType.Int) {
                        buff.putInt(entry.FirstByte, header.getInt(entry.HeaderIndex));
                    }
                    if (entry.HeaderType == DataType.Short) {
                        buff.putShort(entry.FirstByte, (short)header.getInt(entry.HeaderIndex));
                    }
                    if (entry.HeaderType != DataType.Float) continue;
                    buff.putFloat(entry.FirstByte, header.getFloat(entry.HeaderIndex));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void fillTraceHeader(ByteBuffer buff, Column_Abstract header) {
        this.fillTraceHeader(buff, 0, header);
    }

    public void fillTraceHeader(ByteBuffer buff, int buffOffset, Column_Abstract header) {
        try {
            double scalarCoordinate = this.getScalar(this.m_coordinateScalarEntry, buffOffset, buff);
            double scalarElevation = this.getScalar(this.m_elevationScalarEntry, buffOffset, buff);
            double scalarTime = this.getScalar(this.m_timeScalarEntry, buffOffset, buff);
            int tempInt = 0;
            double tempDouble = 0.0;
            byte[] array = null;
            for (Entry entry : this.m_mapEntries) {
                tempInt = 0;
                tempDouble = 0.0;
                if (entry.Factor < 1) {
                    entry.Factor = 1;
                }
                if (entry.Valid) {
                    if (entry.HeaderType == DataType.Float) {
                        tempDouble = buff.getFloat(buffOffset + entry.FirstByte);
                        if (header == null) {
                            entry.TestHeader = Double.toString(tempDouble);
                        }
                        if (entry.ModMethod == Modification.CoordScalar) {
                            tempDouble *= scalarCoordinate;
                        }
                        if (entry.ModMethod == Modification.ElevationScalar) {
                            tempDouble *= scalarElevation;
                        }
                        if (entry.ModMethod == Modification.TimeScalar) {
                            tempDouble *= scalarTime;
                        }
                        if (entry.ModMethod == Modification.FactorDivide) {
                            tempDouble /= (double)entry.Factor;
                        }
                    } else if (entry.HeaderType == DataType.FloatIBM) {
                        if (array == null) {
                            array = buff.array();
                        }
                        tempDouble = Tools_ByteArray.extractFloatUsingIBM(array, buffOffset + entry.FirstByte);
                        if (header == null) {
                            entry.TestHeader = Double.toString(tempDouble);
                        }
                        if (entry.ModMethod == Modification.CoordScalar) {
                            tempDouble *= scalarCoordinate;
                        }
                        if (entry.ModMethod == Modification.ElevationScalar) {
                            tempDouble *= scalarElevation;
                        }
                        if (entry.ModMethod == Modification.TimeScalar) {
                            tempDouble *= scalarTime;
                        }
                        if (entry.ModMethod == Modification.FactorDivide) {
                            tempDouble /= (double)entry.Factor;
                        }
                    } else {
                        if (entry.HeaderType == DataType.Byte) {
                            tempInt = buff.get(buffOffset + entry.FirstByte);
                        }
                        if (entry.HeaderType == DataType.Int) {
                            tempInt = buff.getInt(buffOffset + entry.FirstByte);
                        }
                        if (entry.HeaderType == DataType.Short) {
                            tempInt = buff.getShort(buffOffset + entry.FirstByte);
                        }
                        if (header == null) {
                            entry.TestHeader = Integer.toString(tempInt);
                        }
                        tempDouble = tempInt;
                        if (entry.ModMethod == Modification.FactorDivide) {
                            tempDouble = entry.DatabaseType == DataType.Double || entry.DatabaseType == DataType.Float ? (tempDouble /= (double)entry.Factor) : (double)(tempInt /= entry.Factor);
                        }
                        if (entry.ModMethod == Modification.FactorRemainder) {
                            tempDouble = tempInt %= entry.Factor;
                        }
                        if (entry.ModMethod == Modification.CoordScalar) {
                            tempDouble = (double)tempInt * scalarCoordinate;
                        }
                        if (entry.ModMethod == Modification.ElevationScalar) {
                            tempDouble = (double)tempInt * scalarElevation;
                        }
                        if (entry.ModMethod == Modification.TimeScalar) {
                            tempDouble = (double)tempInt * scalarTime;
                        }
                    }
                    if (this.TotalDumps < 100 && entry.Column.equalsIgnoreCase("CdpX")) {
                        ++this.TotalDumps;
                    }
                } else {
                    tempDouble = entry.DefaultValue;
                    tempInt = (int)Math.round(tempDouble);
                    if (header == null) {
                        entry.TestHeader = Double.toString(tempDouble);
                    }
                }
                if (entry.DatabaseType == DataType.Int) {
                    long l = Math.round(tempDouble);
                    l = Math.min(l, Integer.MAX_VALUE);
                    l = Math.max(l, Integer.MIN_VALUE);
                    if (header != null) {
                        header.putInt(entry.HeaderIndex, (int)l);
                    } else {
                        entry.TestDatabase = Long.toString(l);
                    }
                }
                if (entry.DatabaseType == DataType.Double) {
                    if (header != null) {
                        header.putDouble(entry.HeaderIndex, tempDouble);
                    } else {
                        entry.TestDatabase = Double.toString(tempDouble);
                    }
                }
                if (entry.DatabaseType != DataType.Float) continue;
                if (header != null) {
                    header.putFloat(entry.HeaderIndex, (float)tempDouble);
                    continue;
                }
                entry.TestDatabase = Double.toString(tempDouble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareSeismicHeaderDictionary(EnsembleHeaderDictionary headerDict) {
        try {
            this.m_coordinateScalarEntry = null;
            this.m_elevationScalarEntry = null;
            this.m_timeScalarEntry = null;
            for (Entry entry : this.m_mapEntries) {
                if (headerDict != null) {
                    entry.HeaderIndex = headerDict.addEntry(entry.Table, entry.Column, entry.DatabaseType);
                }
                entry.Factor = Math.max(entry.Factor, 1);
                if (entry.Table.equalsIgnoreCase("None") && entry.Column.equalsIgnoreCase("SegyScalar_Time")) {
                    this.m_timeScalarEntry = entry;
                }
                if (entry.Table.equalsIgnoreCase("None") && entry.Column.equalsIgnoreCase("SegyScalar_Elevation")) {
                    this.m_elevationScalarEntry = entry;
                }
                if (!entry.Table.equalsIgnoreCase("None") || !entry.Column.equalsIgnoreCase("SegyScalar_Coord")) continue;
                this.m_coordinateScalarEntry = entry;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortByTableColumn() {
        try {
            Collections.sort(this.m_mapEntries, new Sorter_TableColumn());
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortByOffset() {
        try {
            Collections.sort(this.m_mapEntries, new Sorter_Offset());
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeAll() {
        try {
            this.m_mapEntries.clear();
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int entryCount() {
        return this.m_mapEntries.size();
    }

    public void removeEntry(int row) {
        try {
            if (row >= 0 && row < this.m_mapEntries.size()) {
                this.m_mapEntries.remove(row);
                this.handleMod(true, true, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Modification getModFromString(String mod) {
        try {
            if (mod.equals("None")) {
                return Modification.None;
            }
            if (mod.equals("FactorDivide")) {
                return Modification.FactorDivide;
            }
            if (mod.equals("FactorRemainder")) {
                return Modification.FactorRemainder;
            }
            if (mod.equals("ElevationScalar")) {
                return Modification.ElevationScalar;
            }
            if (mod.equals("CoordScalar")) {
                return Modification.CoordScalar;
            }
            if (mod.equals("TimeScalar")) {
                return Modification.TimeScalar;
            }
            return Modification.None;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Modification.None;
        }
    }

    public void writeContentsToNode(Element node) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                Element e = node.getOwnerDocument().createElement("Entry");
                e.setAttribute("Table", entry.Table);
                e.setAttribute("Column", entry.Column);
                e.setAttribute("HeaderType", entry.HeaderType.Description);
                e.setAttribute("DatabaseType", entry.DatabaseType.Description);
                e.setAttribute("Offset", Integer.toString(1 + entry.FirstByte));
                e.setAttribute("ModMethod", entry.ModMethod.toString());
                e.setAttribute("Factor", Integer.toString(entry.Factor));
                e.setAttribute("Valid", Boolean.toString(entry.Valid));
                e.setAttribute("DefaultValue", Double.toString(entry.DefaultValue));
                node.appendChild(e);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void readContentsFromNode(Element node) throws Exception {
        try {
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(node, "Entry");
            this.m_sendModMessage = false;
            for (Element e : nodes) {
                String table = e.getAttribute("Table");
                String column = e.getAttribute("Column");
                String HeaderType = e.getAttribute("HeaderType");
                String DatabaseType = e.getAttribute("DatabaseType");
                String off = e.getAttribute("Offset");
                String mod = e.getAttribute("ModMethod");
                String fac = e.getAttribute("Factor");
                column = Tools_Strings.removeCrap(column, true);
                boolean valid = true;
                if (e.hasAttribute("Valid")) {
                    valid = Boolean.valueOf(e.getAttribute("Valid"));
                }
                double defvalue = 0.0;
                if (e.hasAttribute("DefaultValue")) {
                    defvalue = Double.valueOf(e.getAttribute("DefaultValue"));
                }
                DataType ht = DataType.typeFromDescription(HeaderType);
                DataType dt = DataType.typeFromDescription(DatabaseType);
                int offset = Integer.parseInt(off) - 1;
                int factor = Integer.parseInt(fac);
                Modification m = Segy_Dictionary.getModFromString(mod);
                Entry entry = this.addEntry(table, column, ht, dt, offset, m, factor);
                entry.Valid = valid;
                entry.DefaultValue = defvalue;
            }
            this.m_sendModMessage = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void addRequiredPair(String table, String column) {
        this.m_requiredList.add(new RequiredPair(table, column));
    }

    public boolean checkPreStackEntry(String table, String column) {
        try {
            if (!this.hasEntry(table, column)) {
                this.PreStackErrorMessage = "Required entry not present: " + table + " " + column;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidPostStack(boolean is3D) {
        try {
            this.ReasonNotValidPostStack = "";
            this.m_requiredList.clear();
            this.addRequiredPair("Trace", "CdpX");
            this.addRequiredPair("Trace", "CdpY");
            if (is3D) {
                this.addRequiredPair("Trace", "Inline");
                this.addRequiredPair("Trace", "Crossline");
            } else {
                this.addRequiredPair("Trace", "CDP");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                this.ReasonNotValidPostStack = "Required header (" + pair.Table + ", " + pair.Column + ") not defined";
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidVelocity2D() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Trace", "Bin2D");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "Offset");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidVelocity3D() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Trace", "Inline");
                this.addRequiredPair("Trace", "Crossline");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "Offset");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidPreStack() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Shot", "Easting");
                this.addRequiredPair("Shot", "Northing");
                this.addRequiredPair("Shot", "Elevation");
                this.addRequiredPair("Shot", "PointNumber");
                this.addRequiredPair("Receiver", "Easting");
                this.addRequiredPair("Receiver", "Northing");
                this.addRequiredPair("Receiver", "Elevation");
                this.addRequiredPair("Receiver", "PointNumber");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean hasEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void removeEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                this.m_mapEntries.remove(entry);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntry(int index) throws Exception {
        try {
            return this.m_mapEntries.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return entry;
            }
            throw new Exception("Does not have entry");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntry_Create(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return entry;
            }
            this.addEntry(table, column, DataType.Int, DataType.Int, 0, Modification.None, 1);
            Entry entry = this.getEntry(table, column);
            entry.Valid = false;
            entry.DefaultValue = 0.0;
            return entry;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry addEntry(String table, String column, DataType HeaderType, DataType DatabaseType, int offset, Modification mod, int factor) {
        try {
            if (this.hasEntry(table, column)) {
                return this.getEntry(table, column);
            }
            Entry entry = new Entry();
            entry.Table = table;
            entry.Column = column;
            entry.HeaderType = HeaderType;
            entry.DatabaseType = DatabaseType;
            entry.FirstByte = offset;
            entry.ModMethod = mod;
            entry.Factor = factor;
            this.m_mapEntries.add(entry);
            if (this.m_sendModMessage) {
                this.handleMod(true, true, null);
            }
            return entry;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addPostStackSegyRev1() {
        try {
            this.addEntry("None", "SegyScalar_Time", DataType.Short, DataType.Double, 214, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Coord", DataType.Short, DataType.Double, 70, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Elevation", DataType.Short, DataType.Double, 68, Modification.None, 1);
            this.addEntry("Trace", "TraceCode", DataType.Short, DataType.Int, 28, Modification.None, 1);
            this.addEntry("Trace", "SampleCount", DataType.Short, DataType.Int, 114, Modification.None, 1);
            this.addEntry("Trace", "SampleRate", DataType.Short, DataType.Int, 116, Modification.None, 1);
            this.addEntry("Trace", "CdpX", DataType.Int, DataType.Double, 180, Modification.CoordScalar, 1);
            this.addEntry("Trace", "CdpY", DataType.Int, DataType.Double, 184, Modification.CoordScalar, 1);
            this.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 188, Modification.None, 1000);
            this.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 192, Modification.None, 1000);
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addDefaultEntries() {
        try {
            this.addEntry("None", "SegyScalar_Time", DataType.Short, DataType.Double, 214, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Coord", DataType.Short, DataType.Double, 70, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Elevation", DataType.Short, DataType.Double, 68, Modification.None, 1);
            this.addEntry("Trace", "Channel", DataType.Int, DataType.Int, 12, Modification.None, 1);
            this.addEntry("Trace", "TraceCode", DataType.Short, DataType.Int, 28, Modification.None, 1);
            this.addEntry("Receiver", "Easting", DataType.Int, DataType.Double, 80, Modification.CoordScalar, 1);
            this.addEntry("Receiver", "Northing", DataType.Int, DataType.Double, 84, Modification.CoordScalar, 1);
            this.addEntry("Receiver", "Elevation", DataType.Int, DataType.Double, 40, Modification.ElevationScalar, 1);
            this.addEntry("Receiver", "PointNumber", DataType.Int, DataType.Int, 184, Modification.None, 1000);
            this.addEntry("Receiver", "LineNumber", DataType.Int, DataType.Int, 184, Modification.FactorDivide, 1000);
            this.addEntry("Shot", "Easting", DataType.Int, DataType.Double, 72, Modification.CoordScalar, 1);
            this.addEntry("Shot", "Northing", DataType.Int, DataType.Double, 76, Modification.CoordScalar, 1);
            this.addEntry("Shot", "Elevation", DataType.Int, DataType.Double, 44, Modification.ElevationScalar, 1);
            this.addEntry("Shot", "PointDepth", DataType.Int, DataType.Double, 48, Modification.ElevationScalar, 1);
            this.addEntry("Shot", "UpholeTime", DataType.Short, DataType.Int, 94, Modification.None, 0);
            this.addEntry("Shot", "PointNumber", DataType.Int, DataType.Int, 180, Modification.None, 1000);
            this.addEntry("Shot", "LineNumber", DataType.Int, DataType.Int, 180, Modification.FactorDivide, 1000);
            this.addEntry("Shot", "PointIndex", DataType.Int, DataType.Int, 8, Modification.None, 1);
            this.addEntry("Shot", "FFID", DataType.Int, DataType.Int, 8, Modification.None, 1);
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addDefaultEntries_SEI2D() {
        try {
            this.m_mapEntries.clear();
            this.addEntry("None", "SegyScalar_Time", DataType.Short, DataType.Double, 214, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Coord", DataType.Short, DataType.Double, 70, Modification.None, 1);
            this.addEntry("None", "SegyScalar_Elevation", DataType.Short, DataType.Double, 68, Modification.None, 1);
            this.addEntry("Trace", "Channel", DataType.Int, DataType.Int, 12, Modification.None, 1);
            this.addEntry("Trace", "TraceCode", DataType.Short, DataType.Int, 28, Modification.None, 1);
            this.addEntry("Receiver", "Easting", DataType.Int, DataType.Double, 80, Modification.CoordScalar, 1);
            this.addEntry("Receiver", "Northing", DataType.Int, DataType.Double, 84, Modification.CoordScalar, 1);
            this.addEntry("Receiver", "Elevation", DataType.Int, DataType.Double, 40, Modification.ElevationScalar, 1);
            this.addEntry("Receiver", "PointNumber", DataType.Int, DataType.Int, 200, Modification.None, 0);
            this.addEntry("Receiver", "PointIndex", DataType.Int, DataType.Int, 26, Modification.None, 1000);
            this.addEntry("Shot", "Easting", DataType.Int, DataType.Double, 72, Modification.CoordScalar, 1);
            this.addEntry("Shot", "Northing", DataType.Int, DataType.Double, 76, Modification.CoordScalar, 1);
            this.addEntry("Shot", "Elevation", DataType.Int, DataType.Double, 44, Modification.ElevationScalar, 1);
            this.addEntry("Shot", "PointDepth", DataType.Int, DataType.Double, 48, Modification.ElevationScalar, 1);
            this.addEntry("Shot", "UpholeTime", DataType.Short, DataType.Int, 94, Modification.None, 0);
            this.addEntry("Shot", "PointNumber", DataType.Int, DataType.Int, 196, Modification.None, 1000);
            this.addEntry("Shot", "LineNumber", DataType.Int, DataType.Int, 180, Modification.None, 1000);
            this.addEntry("Shot", "PointIndex", DataType.Int, DataType.Int, 184, Modification.None, 1);
            Entry shotLineEntry = this.getEntry("Shot", "LineNumber");
            shotLineEntry.DefaultValue = 1.0;
            shotLineEntry.Valid = false;
            this.addEntry("Shot", "SSPN", DataType.Int, DataType.Int, 8, Modification.None, 1);
            this.addEntry("Shot", "FSPN", DataType.Int, DataType.Int, 8, Modification.None, 1);
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Table";
            }
            if (column == 1) {
                return "Column";
            }
            if (column == 6) {
                return "Database type";
            }
            if (column == 3) {
                return "Offset";
            }
            if (column == 2) {
                return "Header type";
            }
            if (column == 4) {
                return "Modification";
            }
            if (column == 5) {
                return "Factor";
            }
            if (column == 7) {
                return "Value valid";
            }
            if (column == 8) {
                return "Default value";
            }
            if (column == 9) {
                return "Test: Header value";
            }
            if (column == 10) {
                return "Test: Database value";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (!this.m_fileNameValid) {
            return 0;
        }
        int rows = this.m_mapEntries.size();
        return rows;
    }

    @Override
    public int getColumnCount() {
        if (this.ShowTestColumnsInTable) {
            return 11;
        }
        return 9;
    }

    public Class getColumnClass(int column) {
        if (column == 7) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 9) {
            return false;
        }
        return column != 10;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            if (!this.m_fileNameValid) {
                return;
            }
            if (value == null) {
                return;
            }
            Entry entry = this.m_mapEntries.get(row);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (column == 7) {
                    entry.Valid = b;
                    this.handleMod(true, true, null);
                }
                return;
            }
            if (!(value instanceof String)) {
                return;
            }
            String s = (String)value;
            if (s.length() < 1) {
                return;
            }
            if (column == 0) {
                entry.Table = s;
            }
            if (column == 1) {
                s = Tools_Strings.removeSpace(s);
                entry.Column = s = Tools_Strings.removeCrap(s, true);
            }
            if (column == 6) {
                entry.DatabaseType = DataType.typeFromDescription(s);
            }
            if (column == 3) {
                entry.FirstByte = Integer.parseInt(s) - 1;
            }
            if (column == 2) {
                entry.HeaderType = DataType.typeFromDescription(s);
            }
            if (column == 4) {
                entry.ModMethod = Modification.modFromDescription(s);
            }
            if (column == 5) {
                entry.Factor = Integer.parseInt(s);
            }
            if (column == 8) {
                entry.DefaultValue = Double.parseDouble(s);
            }
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (!this.m_fileNameValid) {
                return "";
            }
            Entry e = this.m_mapEntries.get(row);
            if (column == 0) {
                return e.Table;
            }
            if (column == 1) {
                return e.Column;
            }
            if (column == 6) {
                return e.DatabaseType.Description;
            }
            if (column == 3) {
                return Integer.toString(1 + e.FirstByte);
            }
            if (column == 2) {
                return e.HeaderType.Description;
            }
            if (column == 4) {
                return e.ModMethod.Description;
            }
            if (column == 5) {
                if (e.ModMethod == Modification.FactorDivide || e.ModMethod == Modification.FactorRemainder) {
                    return Integer.toString(e.Factor);
                }
                return "";
            }
            if (column == 7) {
                return e.Valid;
            }
            if (column == 8) {
                return Double.toString(e.DefaultValue);
            }
            if (column == 9) {
                return e.TestHeader;
            }
            if (column == 10) {
                return e.TestDatabase;
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public static class Entry {
        public int FirstByte = 0;
        public DataType HeaderType = DataType.Int;
        public Modification ModMethod = Modification.None;
        public int Factor = 0;
        public String Table = "Error";
        public String Column = "Error";
        public DataType DatabaseType = DataType.Int;
        public int HeaderIndex = 0;
        public DataType EnsembleType = DataType.Int;
        public boolean IsEnsembleFloatType = false;
        public boolean Valid = true;
        public double DefaultValue;
        protected String TestHeader = "";
        protected String TestDatabase = "";

        public void populateByteArray(byte[] bytes, int offset) {
            try {
                int b;
                int b2;
                for (int b3 = 0; b3 < 40; ++b3) {
                    bytes[offset + b3] = 32;
                }
                String table = this.Table;
                if (this.Table.equalsIgnoreCase("Shot")) {
                    table = "SHT";
                }
                if (this.Table.equalsIgnoreCase("Receiver")) {
                    table = "REC";
                }
                if (this.Table.equalsIgnoreCase("Trace")) {
                    table = "TRC";
                }
                if (this.Table.equalsIgnoreCase("None")) {
                    table = "N/A";
                }
                byte[] temp = table.getBytes();
                for (b2 = 0; b2 < temp.length; ++b2) {
                    bytes[offset + b2] = temp[b2];
                }
                bytes[(offset += 4) - 1] = 32;
                temp = this.Column.getBytes();
                for (b2 = 0; b2 < temp.length; ++b2) {
                    bytes[offset + b2] = temp[b2];
                }
                bytes[(offset += 22) - 1] = 32;
                String s = Integer.toString(this.FirstByte + 1);
                temp = s.getBytes();
                for (b = 0; b < temp.length; ++b) {
                    bytes[offset + b] = temp[b];
                }
                offset += 5;
                if (this.HeaderType == DataType.Byte) {
                    s = "1I";
                }
                if (this.HeaderType == DataType.Int) {
                    s = "4I";
                }
                if (this.HeaderType == DataType.Float) {
                    s = "4F";
                }
                if (this.HeaderType == DataType.Short) {
                    s = "2I";
                }
                if (this.HeaderType == DataType.FloatIBM) {
                    s = "IBM";
                }
                temp = s.getBytes();
                for (b = 0; b < temp.length; ++b) {
                    bytes[offset + b] = temp[b];
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }

        public String toString() {
            try {
                String s = String.format("%10s%10s", this.Table, this.Column);
                return s;
            }
            catch (Exception error) {
                return "Error";
            }
        }
    }

    public static enum Modification {
        None("None"),
        FactorDivide("Divide by factor"),
        FactorRemainder("Divide by factor, use remainder"),
        ElevationScalar("Apply the elevation scalar"),
        CoordScalar("Apply the coordinate scalar"),
        TimeScalar("Apply the time scalar");

        public final String Description;

        private Modification(String desc) {
            this.Description = desc;
        }

        public static Modification modFromDescription(String s) {
            Modification[] arr = Modification.values();
            for (int n = 0; n < arr.length; ++n) {
                if (!s.equalsIgnoreCase(arr[n].Description)) continue;
                return arr[n];
            }
            return None;
        }
    }

    public static class Sorter_TableColumn
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.Table.equals(e2.Table)) {
                    return e1.Column.compareTo(e2.Column);
                }
                return e1.Table.compareTo(e2.Table);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    public static class Sorter_Offset
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.FirstByte == e2.FirstByte) {
                    return 0;
                }
                if (e1.FirstByte < e2.FirstByte) {
                    return -1;
                }
                return 1;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    protected class RequiredPair {
        public String Table;
        public String Column;

        public RequiredPair(String tbl, String col) {
            this.Table = tbl;
            this.Column = col;
        }
    }

    public class ColumnIndex {
        public static final int Table = 0;
        public static final int Column = 1;
        public static final int DataType = 2;
        public static final int Offset = 3;
        public static final int Modification = 4;
        public static final int Factor = 5;
        public static final int DatabaseType = 6;
        public static final int Valid = 7;
        public static final int DefaultValue = 8;
        public static final int TestHeaderValue = 9;
        public static final int TestDatabaseValue = 10;
        public static final int Count = 11;
    }
}

