/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Plugins;

import com.PecosCore.Application.Environment;
import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Plugins.IPluginConfigService;
import com.PecosCore.Plugins.PluginClassLoader;
import com.PecosCore.Refraction.IRefractionStaticsProject;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class PluginManager {
    protected static PluginManager m_singleton;
    protected IPlugin m_currentPlugin;
    protected String m_selectedPluginName;
    protected String m_loadedPluginName;
    protected ArrayList<String> m_list = new ArrayList();
    protected String m_pluginsDir;
    protected IRefractionStaticsProject m_project;
    protected IPluginConfigService m_configService = null;
    protected boolean m_checkConfig = false;
    protected static final boolean MASTER_OVERRIDE = false;

    public static PluginManager singleton() {
        if (m_singleton == null) {
            m_singleton = new PluginManager();
        }
        return m_singleton;
    }

    protected PluginManager() {
    }

    public IPlugin currentPlugin() {
        return this.m_currentPlugin;
    }

    public void setCurrentPlugin(String name) {
        try {
            this.m_selectedPluginName = name;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadCurrentPlugin() {
        try {
            if (this.m_selectedPluginName == null) {
                return;
            }
            if (this.m_selectedPluginName.length() < 1) {
                return;
            }
            if (this.m_selectedPluginName.equalsIgnoreCase(this.m_loadedPluginName)) {
                return;
            }
            Object pathString = PluginManager.singleton().getPluginsDir() + "/" + this.m_selectedPluginName + ".jar";
            System.out.println("loadCurrentPlugin " + (String)pathString);
            File tmpFile = new File(this.m_selectedPluginName);
            File parentFile = tmpFile.getParentFile();
            if (parentFile != null && tmpFile.getAbsolutePath().endsWith(".jar")) {
                pathString = this.m_selectedPluginName;
                System.out.println("loadCurrentPlugin m_selectedPluginName " + this.m_selectedPluginName);
            }
            if (!Tools_FileSystem.exists_file((String)pathString)) {
                System.out.println("loadCurrentPlugin !Tools_FileSystem.exists_file pathString " + (String)pathString);
                return;
            }
            File file = new File((String)pathString);
            if (file == null) {
                System.out.println("loadCurrentPlugin new File fail pathString " + (String)pathString);
                return;
            }
            URL url = file.toURI().toURL();
            if (!file.canRead()) {
                System.out.println("loadCurrentPlugin !file.canRead() " + (String)pathString);
                return;
            }
            PluginClassLoader loader = new PluginClassLoader(url);
            System.out.println("loadCurrentPlugin PluginClassLoader OK ");
            this.m_currentPlugin = loader.loadPlugin();
            System.out.println("loadCurrentPlugin loader.loadPlugin() OK ");
            this.m_loadedPluginName = new String(this.m_selectedPluginName);
            System.out.println("loadCurrentPlugin m_loadedPluginName " + this.m_loadedPluginName);
            this.m_configService = this.m_currentPlugin.getConfigService();
            System.out.println("loadCurrentPlugin m_configService ");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadList() {
        try {
            String corePath = PluginManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String libPath = corePath.substring(0, corePath.lastIndexOf("/"));
            String topPath = libPath.substring(0, libPath.lastIndexOf("/"));
            Object pluginsPath = topPath + "/plugins";
            if (Environment.getIsDebug()) {
                String sAppPath = Environment.getExecuteableDirectory();
                File file = new File(sAppPath);
                File buildFile = file.getParentFile();
                File flatironsFile = buildFile.getParentFile();
                File appsFile = flatironsFile.getParentFile();
                File sourceFile = appsFile.getParentFile();
                String sPath1 = sourceFile.getAbsolutePath() + "/FlatironsRefractionStatics/Flatirons_Omega/dist";
                File file1 = new File(sPath1);
                File file2 = flatironsFile.getParentFile().getParentFile();
                String sPath2 = file2.getAbsolutePath() + "/Flatirons_Omega/dist";
                file2 = new File(sPath2);
                String sPath3 = sourceFile.getAbsolutePath() + "/plugins/Flatirons_Omega/dist";
                File file3 = new File(sPath3);
                String sPath4 = sourceFile.getAbsolutePath() + "/Flatirons/Flatirons_Omega/dist";
                File file4 = new File(sPath4);
                File flatirons_OmegaFile = null;
                if (file1.exists()) {
                    flatirons_OmegaFile = file1;
                } else if (file2.exists()) {
                    flatirons_OmegaFile = file2;
                } else if (file3.exists()) {
                    flatirons_OmegaFile = file3;
                } else if (file4.exists()) {
                    flatirons_OmegaFile = file4;
                }
                if (flatirons_OmegaFile != null) {
                    pluginsPath = flatirons_OmegaFile.getAbsolutePath();
                }
            }
            if (Tools_FileSystem.exists_path((String)pluginsPath)) {
                ArrayList<String> tempList = Tools_FileSystem.files((String)pluginsPath, false);
                this.m_pluginsDir = pluginsPath;
                for (String item : tempList) {
                    int endIndex;
                    String name;
                    if (!item.endsWith(".jar") || this.m_list.contains(name = item.substring(0, endIndex = item.length() - ".jar".length()))) continue;
                    this.m_list.add(name);
                }
            }
            this.addDebugXtGeoPlugin(this.m_list);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    void addDebugXtGeoPlugin(ArrayList list) {
        try {
            String pluginsPath;
            String sAppPath;
            File file;
            File buildFile;
            File flatironsFile;
            File appsFile;
            File sourceFile;
            String sPath3;
            File file3;
            if (Environment.getIsDebug() && (file3 = new File(sPath3 = (sourceFile = (appsFile = (flatironsFile = (buildFile = (file = new File(sAppPath = Environment.getExecuteableDirectory())).getParentFile()).getParentFile()).getParentFile()).getParentFile()).getAbsolutePath() + "/plugins/Flatirons_XtGeo/store")).exists() && Tools_FileSystem.exists_path(pluginsPath = file3.getAbsolutePath())) {
                ArrayList<String> tempList = Tools_FileSystem.files(pluginsPath, false);
                for (String item : tempList) {
                    if (!item.endsWith(".jar")) continue;
                    int endIndex = item.length() - ".jar".length();
                    String name = item.substring(0, endIndex);
                    String sTemp = pluginsPath + "/" + item;
                    if (this.m_list.contains(sTemp)) continue;
                    this.m_list.add(sTemp);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ArrayList getPluginList() {
        return this.m_list;
    }

    public String getPluginsDir() {
        try {
            if (this.m_pluginsDir == null) {
                this.loadList();
            }
            return this.m_pluginsDir;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setProject(IRefractionStaticsProject project) {
        this.m_project = project;
    }

    public IRefractionStaticsProject getProject() {
        return this.m_project;
    }

    public boolean checkConfig() {
        return this.m_checkConfig;
    }

    public void setCheckConfig(boolean check) {
        this.m_checkConfig = check;
    }

    public boolean overrideOK() {
        return false;
    }
}

