/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Plugins;

import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Shared.ExceptionMonitor;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginClassLoader
extends URLClassLoader {
    protected String m_className = "";
    protected String m_path;
    protected URL m_url;

    public PluginClassLoader(URL url) {
        super(new URL[]{url}, PluginClassLoader.class.getClassLoader());
        try {
            this.m_url = url;
            this.m_path = url.getPath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public IPlugin loadPlugin() {
        try {
            this.m_path = URLDecoder.decode(this.m_path, "UTF-8");
            System.out.println("loadPlugin m_path " + this.m_path);
            JarFile jarFile = new JarFile(this.m_path);
            System.out.println("loadPlugin jarFile ok ");
            Enumeration<JarEntry> list = jarFile.entries();
            while (list.hasMoreElements()) {
                JarEntry entry = list.nextElement();
                String entryName = entry.getName();
                System.out.println("loadPlugin jarFile entryName " + entryName);
                if (entryName.contains("PecosCore") || !entryName.endsWith("Plugin.class") || !entryName.contains("OmegaPlugin") && !entryName.contains("SeisspacePlugin") && !entryName.contains("XtgeoPlugin") && !entryName.contains("SierraPlugin")) continue;
                this.m_className = entryName;
                System.out.println("loadPlugin m_className " + this.m_className);
            }
            System.out.println("loadPlugin before substring, m_className " + this.m_className);
            this.m_className = this.m_className.substring(0, this.m_className.length() - 6);
            System.out.println("loadPlugin after substring, m_className " + this.m_className);
            this.m_className = this.m_className.replace("/", ".");
            Class<?> loadedClass = Class.forName(this.m_className, true, this);
            System.out.println("loadPlugin Class loadedClass OK " + this.m_className);
            if (loadedClass == null) {
                return null;
            }
            System.out.println("Loaded plugin class: " + loadedClass.getCanonicalName());
            Object loadedObject = loadedClass.newInstance();
            System.out.println("Plugin interface class name: " + IPlugin.class.getName());
            if (loadedObject instanceof IPlugin) {
                IPlugin plugin = (IPlugin)loadedObject;
                return plugin;
            }
            System.out.println("Error loading plugin: not an XTGeo compatible plugin");
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

