/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;

public class FFT_ShortWindowAnalysis {
    protected int m_numUptick = 4;
    protected boolean m_inputValid = false;
    protected float[] m_inputTrace = new float[10];
    protected float m_inputStartTime = 0.0f;
    protected float m_inputSampleInterval = 0.0f;
    protected FFT_1D_Wrapper m_fftInput = new FFT_1D_Wrapper(100);
    protected boolean m_resampledValid = false;
    protected float[] m_resampledTrace = new float[10];
    protected float m_resampledStartTime = 0.0f;
    protected float m_resampledSampleInterval = 0.0f;
    protected FFT_1D_Wrapper m_fftResampled = new FFT_1D_Wrapper(100);
    protected boolean m_computedValid = false;
    protected float m_windowLength = 32.0f;
    protected float m_taperLength = 8.0f;
    protected boolean m_applyTaper = true;
    protected float[] m_taperMask = new float[10];
    protected int m_numWindowSamples;
    protected int m_paddedWindowSamples;
    protected float[][] m_windowedData = new float[2][2];
    protected float m_maxAmplitude = 0.0f;
    protected float m_frequencyIncrement;
    protected float[][] m_fftReal = new float[2][2];
    protected float[][] m_fftImag = new float[2][2];
    protected float[][] m_fftAmp = new float[2][2];
    protected float[][] m_fftPhase = new float[2][2];
    protected FFT_1D_Wrapper m_fftWindow = new FFT_1D_Wrapper(100);

    public int numUptick() {
        return this.m_numUptick;
    }

    public void setNumUptick(int numUptick) {
        numUptick = Math.min(16, numUptick);
        numUptick = Math.max(4, numUptick);
        this.m_resampledValid = false;
        this.m_numUptick = 2;
        while (this.m_numUptick < numUptick) {
            this.m_numUptick *= 2;
        }
    }

    public boolean inputValid() {
        return this.m_inputValid;
    }

    public float[] inputTrace() {
        return this.m_inputTrace;
    }

    public float inputStartTime() {
        return this.m_inputStartTime;
    }

    public float inputSampleInterval() {
        return this.m_inputSampleInterval;
    }

    public boolean resampledValid() {
        return this.m_resampledValid;
    }

    public float[] resampledTrace() {
        return this.m_resampledTrace;
    }

    public float resampledStartTime() {
        return this.m_resampledStartTime;
    }

    public float resampledSampleInterval() {
        return this.m_resampledSampleInterval;
    }

    public boolean computedValid() {
        return this.m_computedValid;
    }

    public int numWindowSamples() {
        return this.m_numWindowSamples;
    }

    public int paddedWindowSamples() {
        return this.m_paddedWindowSamples;
    }

    public float[][] windowedData() {
        return this.m_windowedData;
    }

    public float maxAmplitude() {
        return this.m_maxAmplitude;
    }

    public float frequencyIncrement() {
        return this.m_frequencyIncrement;
    }

    public float[][] fftReal() {
        return this.m_fftReal;
    }

    public float[][] fftImag() {
        return this.m_fftImag;
    }

    public float[][] fftAmp() {
        return this.m_fftAmp;
    }

    public float[][] fftPhase() {
        return this.m_fftPhase;
    }

    public void computeAllData(float windowLength, float taperLength, boolean applyTaper) throws Exception {
        try {
            this.m_computedValid = false;
            if (!this.m_resampledValid) {
                throw new Exception("m_resampledValid == false");
            }
            this.m_windowLength = windowLength;
            this.m_applyTaper = applyTaper;
            this.m_numWindowSamples = (int)(0.5f + this.m_windowLength / this.m_resampledSampleInterval);
            this.m_numWindowSamples = Math.max(8, this.m_numWindowSamples);
            this.m_windowLength = (float)this.m_numWindowSamples * this.m_resampledSampleInterval;
            this.m_paddedWindowSamples = 512;
            while (this.m_paddedWindowSamples < 2 * this.m_numWindowSamples) {
                this.m_paddedWindowSamples *= 2;
            }
            this.m_frequencyIncrement = 1.0f / (float)(0.001 * (double)this.m_paddedWindowSamples * (double)this.m_resampledSampleInterval);
            if (Math.abs(this.m_taperLength - taperLength) > 0.01f || this.m_taperMask.length != this.m_numWindowSamples) {
                int n;
                this.m_taperLength = taperLength;
                if (this.m_taperMask.length != this.m_numWindowSamples) {
                    this.m_taperMask = new float[this.m_numWindowSamples];
                }
                int nts = (int)(0.5f + this.m_taperLength / this.m_resampledSampleInterval);
                nts = Math.max(0, nts);
                nts = Math.min(nts, this.m_numWindowSamples / 4);
                for (n = 0; n < this.m_numWindowSamples; ++n) {
                    this.m_taperMask[n] = 1.0f;
                }
                for (n = 0; n < nts; ++n) {
                    this.m_taperMask[n] = ((float)n + 1.0f) / (float)(nts + 1);
                    this.m_taperMask[this.m_numWindowSamples - 1 - n] = this.m_taperMask[n];
                }
            }
            this.extractWindows();
            if (this.m_fftWindow.getPowerOfTwo() != this.m_paddedWindowSamples) {
                this.m_fftWindow = new FFT_1D_Wrapper(this.m_paddedWindowSamples);
            }
            this.m_fftReal = this.getTwoDimArray(this.m_fftReal);
            this.m_fftImag = this.getTwoDimArray(this.m_fftImag);
            this.m_fftAmp = this.getTwoDimArray(this.m_fftAmp);
            this.m_fftPhase = this.getTwoDimArray(this.m_fftPhase);
            this.m_maxAmplitude = 0.0f;
            for (int inputIndex = 0; inputIndex < this.m_inputTrace.length; ++inputIndex) {
                float[] window = this.m_windowedData[inputIndex];
                this.m_fftWindow.forward(window);
                float[] real = this.m_fftWindow.real();
                float[] imag = this.m_fftWindow.imag();
                for (int n = 0; n < this.m_paddedWindowSamples; ++n) {
                    float re = real[n];
                    float im = imag[n];
                    this.m_fftReal[inputIndex][n] = re;
                    this.m_fftImag[inputIndex][n] = im;
                    this.m_fftAmp[inputIndex][n] = (float)Math.sqrt(re * re + im * im);
                    this.m_maxAmplitude = Math.max(this.m_maxAmplitude, this.m_fftAmp[inputIndex][n]);
                    this.m_fftPhase[inputIndex][n] = this.m_fftAmp[inputIndex][n] > 0.0f ? (float)Math.atan2(im, re) : 0.0f;
                }
            }
            this.m_computedValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float[][] getTwoDimArray(float[][] check) throws Exception {
        try {
            if (check == null) {
                return new float[this.m_inputTrace.length][this.m_paddedWindowSamples];
            }
            if (check.length != this.m_inputTrace.length) {
                return new float[this.m_inputTrace.length][this.m_paddedWindowSamples];
            }
            if (check[0].length != this.m_paddedWindowSamples) {
                this.m_windowedData = new float[this.m_inputTrace.length][this.m_paddedWindowSamples];
            }
            return check;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void extractWindows() throws Exception {
        try {
            this.m_windowedData = this.getTwoDimArray(this.m_windowedData);
            for (int inputIndex = 0; inputIndex < this.m_inputTrace.length; ++inputIndex) {
                int n;
                int resampleIndex = this.m_numUptick * inputIndex;
                float[] window = this.m_windowedData[inputIndex];
                int resampleStartIndex = resampleIndex - this.m_numWindowSamples / 2;
                for (n = 0; n < this.m_numWindowSamples; ++n) {
                    window[n] = 0.0f;
                    int index = resampleStartIndex + n;
                    if (index < 0 || index >= this.m_resampledTrace.length) continue;
                    window[n] = this.m_resampledTrace[index];
                }
                for (n = this.m_numWindowSamples; n < this.m_paddedWindowSamples; ++n) {
                    window[n] = 0.0f;
                }
                if (!this.m_applyTaper) continue;
                for (n = 0; n < this.m_numWindowSamples; ++n) {
                    window[n] = window[n] * this.m_taperMask[n];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void insertTraceData(float[] inputTrace, float startTime, float sampleInterval) {
        try {
            this.m_computedValid = false;
            this.m_resampledValid = false;
            this.m_inputValid = false;
            this.m_inputStartTime = startTime;
            this.m_inputSampleInterval = Math.max(sampleInterval, 0.1f);
            if (inputTrace == null) {
                return;
            }
            if (inputTrace.length < 10) {
                return;
            }
            if (inputTrace.length != this.m_inputTrace.length) {
                this.m_inputTrace = new float[inputTrace.length];
            }
            System.arraycopy(inputTrace, 0, this.m_inputTrace, 0, inputTrace.length);
            if (this.m_inputTrace.length > this.m_fftInput.getPowerOfTwo()) {
                this.m_fftInput = new FFT_1D_Wrapper(this.m_inputTrace.length);
            }
            this.m_fftInput.forward(this.m_inputTrace);
            this.m_inputValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeResampledTrace() throws Exception {
        try {
            int n;
            this.m_computedValid = false;
            this.m_resampledValid = false;
            if (!this.m_inputValid) {
                throw new Exception("m_inputValid == false");
            }
            this.m_resampledSampleInterval = this.m_inputSampleInterval / (float)this.m_numUptick;
            this.m_resampledStartTime = this.m_inputStartTime;
            int inputPowerOfTwo = this.m_fftInput.getPowerOfTwo();
            int outputPowerOfTwo = this.m_numUptick * inputPowerOfTwo;
            if (this.m_resampledTrace.length != outputPowerOfTwo) {
                this.m_resampledTrace = new float[outputPowerOfTwo];
            }
            if (outputPowerOfTwo != this.m_fftResampled.getPowerOfTwo()) {
                this.m_fftResampled = new FFT_1D_Wrapper(outputPowerOfTwo);
            }
            this.m_fftResampled.clearArrays();
            int inputHalf = inputPowerOfTwo / 2;
            float[] outputReal = this.m_fftResampled.real();
            float[] outputImag = this.m_fftResampled.imag();
            float[] inputReal = this.m_fftInput.real();
            float[] inputImag = this.m_fftInput.imag();
            int outputLast = outputPowerOfTwo - 1;
            int inputLast = inputPowerOfTwo - 1;
            float scalar = (float)Math.sqrt(this.m_numUptick);
            for (n = 0; n < outputReal.length; ++n) {
                outputReal[n] = 0.0f;
                outputImag[n] = 0.0f;
            }
            for (n = 0; n < inputHalf; ++n) {
                outputReal[n] = scalar * inputReal[n];
                outputImag[n] = scalar * inputImag[n];
                outputReal[outputLast - n] = scalar * inputReal[inputLast - n];
                outputImag[outputLast - n] = scalar * inputImag[inputLast - n];
            }
            this.m_fftResampled.setForwardInputDataLength(this.m_resampledTrace.length);
            this.m_fftResampled.inverse(this.m_resampledTrace);
            this.m_resampledValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

