/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.Shared.ExceptionMonitor;

public class FFT_ND {
    public static void FFT_double(double[] data, int[] nn, int ndim, int isign) throws Exception {
        try {
            int i1;
            int idim;
            int ntot = 1;
            for (idim = 0; idim < ndim; ++idim) {
                ntot *= nn[idim];
            }
            if (ntot < 2 || (ntot & -ntot) != ntot) {
                System.out.println("Algorithm requires that " + ntot + " be a power of 2.");
            }
            int nprev = 1;
            for (idim = ndim - 1; idim >= 0; --idim) {
                int i3;
                int i2;
                int n = nn[idim];
                int nrem = ntot / (n * nprev);
                int ip1 = nprev << 1;
                int ip2 = ip1 * n;
                int ip3 = ip2 * nrem;
                int i2rev = 0;
                for (i2 = 0; i2 < ip2; i2 += ip1) {
                    int ibit;
                    if (i2 < i2rev) {
                        for (i1 = i2; i1 <= i2 + ip1 - 1; i1 += 2) {
                            for (i3 = i1; i3 < ip3; i3 += ip2) {
                                int i3rev = i2rev + i3 - i2;
                                double t = data[i3];
                                data[i3] = data[i3rev];
                                data[i3rev] = t;
                                t = data[i3 + 1];
                                data[i3 + 1] = data[i3rev + 1];
                                data[i3rev + 1] = t;
                            }
                        }
                    }
                    for (ibit = ip2 >> 1; ibit >= ip1 && i2rev + 1 > ibit; ibit >>= 1) {
                        i2rev -= ibit;
                    }
                    i2rev += ibit;
                }
                int ifp1 = ip1;
                while (ifp1 < ip2) {
                    int ifp2 = ifp1 << 1;
                    double theta = (double)isign * 6.28318530717959 / (double)(ifp2 / ip1);
                    double wtemp = Math.sin(0.5 * theta);
                    double wpr = -2.0 * wtemp * wtemp;
                    double wpi = Math.sin(theta);
                    double wr = 1.0;
                    double wi = 0.0;
                    for (i3 = 0; i3 < ifp1; i3 += ip1) {
                        for (i1 = i3; i1 <= i3 + ip1 - 1; i1 += 2) {
                            for (i2 = i1; i2 < ip3; i2 += ifp2) {
                                int k1 = i2;
                                int k2 = k1 + ifp1;
                                double tempr = (double)((float)wr) * data[k2] - (double)((float)wi) * data[k2 + 1];
                                double tempi = (double)((float)wr) * data[k2 + 1] + (double)((float)wi) * data[k2];
                                data[k2] = data[k1] - tempr;
                                data[k2 + 1] = data[k1 + 1] - tempi;
                                int n2 = k1;
                                data[n2] = data[n2] + tempr;
                                int n3 = k1 + 1;
                                data[n3] = data[n3] + tempi;
                            }
                        }
                        wtemp = wr;
                        wr = wtemp * wpr - wi * wpi + wr;
                        wi = wi * wpr + wtemp * wpi + wi;
                    }
                    ifp1 = ifp2;
                }
                nprev *= n;
            }
            if (isign < 0) {
                i1 = 0;
                while (i1 < 2 * ntot) {
                    int n = i1++;
                    data[n] = data[n] / (double)ntot;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void FFT_float(float[] data, int[] nn, int ndim, int isign) throws Exception {
        try {
            int i1;
            int idim;
            int ntot = 1;
            for (idim = 0; idim < ndim; ++idim) {
                ntot *= nn[idim];
            }
            if (ntot < 2 || (ntot & -ntot) != ntot) {
                System.out.println("Algorithm requires that " + ntot + " be a power of 2.");
            }
            int nprev = 1;
            for (idim = ndim - 1; idim >= 0; --idim) {
                int i3;
                int i2;
                int n = nn[idim];
                int nrem = ntot / (n * nprev);
                int ip1 = nprev << 1;
                int ip2 = ip1 * n;
                int ip3 = ip2 * nrem;
                int i2rev = 0;
                for (i2 = 0; i2 < ip2; i2 += ip1) {
                    int ibit;
                    if (i2 < i2rev) {
                        for (i1 = i2; i1 <= i2 + ip1 - 1; i1 += 2) {
                            for (i3 = i1; i3 < ip3; i3 += ip2) {
                                int i3rev = i2rev + i3 - i2;
                                float t = data[i3];
                                data[i3] = data[i3rev];
                                data[i3rev] = t;
                                t = data[i3 + 1];
                                data[i3 + 1] = data[i3rev + 1];
                                data[i3rev + 1] = t;
                            }
                        }
                    }
                    for (ibit = ip2 >> 1; ibit >= ip1 && i2rev + 1 > ibit; ibit >>= 1) {
                        i2rev -= ibit;
                    }
                    i2rev += ibit;
                }
                int ifp1 = ip1;
                while (ifp1 < ip2) {
                    int ifp2 = ifp1 << 1;
                    float theta = (float)((double)isign * 6.28318530717959 / (double)(ifp2 / ip1));
                    float wtemp = (float)Math.sin(0.5 * (double)theta);
                    float wpr = (float)(-2.0 * (double)wtemp * (double)wtemp);
                    float wpi = (float)Math.sin(theta);
                    float wr = 1.0f;
                    float wi = 0.0f;
                    for (i3 = 0; i3 < ifp1; i3 += ip1) {
                        for (i1 = i3; i1 <= i3 + ip1 - 1; i1 += 2) {
                            for (i2 = i1; i2 < ip3; i2 += ifp2) {
                                int k1 = i2;
                                int k2 = k1 + ifp1;
                                float tempr = wr * data[k2] - wi * data[k2 + 1];
                                float tempi = wr * data[k2 + 1] + wi * data[k2];
                                data[k2] = data[k1] - tempr;
                                data[k2 + 1] = data[k1 + 1] - tempi;
                                int n2 = k1;
                                data[n2] = data[n2] + tempr;
                                int n3 = k1 + 1;
                                data[n3] = data[n3] + tempi;
                            }
                        }
                        wtemp = wr;
                        wr = wtemp * wpr - wi * wpi + wr;
                        wi = wi * wpr + wtemp * wpi + wi;
                    }
                    ifp1 = ifp2;
                }
                nprev *= n;
            }
            if (isign < 0) {
                i1 = 0;
                while (i1 < 2 * ntot) {
                    int n = i1++;
                    data[n] = data[n] / (float)ntot;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void test() {
        try {
            int ndim = 4;
            int[] nn = new int[ndim];
            int len = 8;
            for (int i = 0; i < nn.length; ++i) {
                nn[i] = len;
                len *= 2;
            }
            int total = 1;
            for (int i = 0; i < nn.length; ++i) {
                total *= nn[i];
            }
            double[] data = new double[2 * total];
            int N1 = nn[0];
            int N2 = nn[1];
            int N3 = nn[2];
            int N4 = nn[3];
            for (int i1 = 0; i1 < N1; ++i1) {
                for (int i2 = 0; i2 < N2; ++i2) {
                    for (int i3 = 0; i3 < N3; ++i3) {
                        for (int i4 = 0; i4 < N4; ++i4) {
                            int index = i4 + i3 * N4 + i2 * N4 * N3 + i1 * N4 * N3 * N2;
                            double temp = Math.PI * 2 * (double)i2 / (double)N2;
                            double re = 100.0 * Math.cos(temp);
                            double im = 0.0;
                            data[2 * index] = re;
                            data[2 * index + 1] = im;
                        }
                    }
                }
            }
            long start = System.currentTimeMillis();
            int niter = 100;
            double[] original = new double[data.length];
            for (int n = 0; n < data.length; ++n) {
                original[n] = data[n];
            }
            for (int iter = 0; iter < niter; ++iter) {
                FFT_ND.FFT_double(data, nn, ndim, 1);
                FFT_ND.FFT_double(data, nn, ndim, -1);
            }
            long time = System.currentTimeMillis() - start;
            double timePerIter = (double)time / (double)niter;
            String str = String.format("ms/iter = %f   total=%d", Float.valueOf((float)timePerIter), total);
            System.out.println(str);
            int numPrinted = 0;
            double maxError = 0.0;
            for (int i1 = 0; i1 < N1; ++i1) {
                for (int i2 = 0; i2 < N2; ++i2) {
                    for (int i3 = 0; i3 < N3; ++i3) {
                        for (int i4 = 0; i4 < N4; ++i4) {
                            int index = i4 + i3 * N4 + i2 * N4 * N3 + i1 * N4 * N3 * N2;
                            double realError = Math.abs(data[2 * index] - original[2 * index]);
                            double imagError = Math.abs(data[2 * index + 1] - original[2 * index + 1]);
                            double err = realError + imagError;
                            maxError = Math.max(maxError, err);
                            if (!(err > 1.0) || numPrinted >= 100) continue;
                            String s = String.format("%d  %d  %d  %d  %f", i1, i2, i3, i4, Float.valueOf((float)err));
                            System.out.println(s);
                            ++numPrinted;
                        }
                    }
                }
            }
            System.out.println("Maximum error = " + maxError);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

