/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;

public class FFT_Interpolator {
    protected boolean m_inputValid = false;
    protected float[] m_inputTrace = new float[10];
    protected float[] m_outputTrace = new float[10];
    protected FFT_1D_Wrapper m_fftInput = new FFT_1D_Wrapper(100);
    protected FFT_1D_Wrapper m_fftOutput = new FFT_1D_Wrapper(100);
    protected FFT_1D_Wrapper m_fftWindow = new FFT_1D_Wrapper(10);
    protected int m_numUptick = 4;
    protected int m_windowLength = 32;
    protected int m_taperLength = 2;
    protected boolean m_applyTaper = true;
    protected float[] m_windowArray;
    protected float[] m_maskArray;
    protected float[] m_bufferedWindowArray;

    public FFT_Interpolator() {
        this.prepareWindowAndTaper(32, 2, true);
        this.setNumUptick(4);
    }

    public float[] windowAmplitude() {
        return this.m_fftWindow.amplitude();
    }

    public float[] output() {
        return this.m_outputTrace;
    }

    public boolean valid() {
        return this.m_inputValid;
    }

    public void setNumUptick(int numUptick) {
        this.m_numUptick = 2;
        while (this.m_numUptick < numUptick) {
            this.m_numUptick *= 2;
        }
        this.prepareWindowAndTaper(this.m_windowLength, this.m_taperLength, this.m_applyTaper);
    }

    public float[] bufferedWindowArray() {
        return this.m_bufferedWindowArray;
    }

    public float[] windowArray() {
        return this.m_windowArray;
    }

    public void prepareWindowAndTaper(int windowLength, int taperLength, boolean applyTaper) {
        try {
            int buffLen;
            this.m_windowLength = Math.max(windowLength, 8);
            this.m_taperLength = Math.max(taperLength, 0);
            this.m_taperLength = Math.min(taperLength, this.m_windowLength / 4);
            this.m_applyTaper = applyTaper && this.m_taperLength >= 2;
            this.m_windowArray = new float[this.m_windowLength * this.m_numUptick];
            this.m_maskArray = new float[this.m_windowLength * this.m_numUptick];
            for (int n = 0; n < this.m_maskArray.length; ++n) {
                this.m_maskArray[n] = 1.0f;
            }
            for (buffLen = 256; buffLen < this.m_windowArray.length; buffLen *= 2) {
            }
            this.m_bufferedWindowArray = new float[buffLen];
            if (!this.m_applyTaper) {
                return;
            }
            for (int n = 0; n < this.m_taperLength; ++n) {
                this.m_maskArray[n] = ((float)n + 1.0f) / (float)(this.m_taperLength + 1);
                this.m_maskArray[this.m_maskArray.length - n - 1] = this.m_maskArray[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float prepareCenteredWindow(int mid, boolean applyMask) {
        try {
            int n;
            int outputIndex = mid - this.m_windowArray.length / 2;
            for (n = 0; n < this.m_windowArray.length; ++n) {
                this.m_windowArray[n] = 0.0f;
                if (outputIndex >= 0 && outputIndex < this.m_outputTrace.length) {
                    this.m_windowArray[n] = this.m_outputTrace[outputIndex];
                }
                ++outputIndex;
                if (!applyMask) continue;
                this.m_windowArray[n] = this.m_windowArray[n] * this.m_maskArray[n];
            }
            for (n = 0; n < this.m_windowArray.length; ++n) {
                this.m_bufferedWindowArray[n] = this.m_windowArray[n];
            }
            for (n = this.m_windowArray.length; n < this.m_bufferedWindowArray.length; ++n) {
                this.m_bufferedWindowArray[n] = 0.0f;
            }
            if (this.m_bufferedWindowArray.length > this.m_fftWindow.getPowerOfTwo()) {
                this.m_fftWindow = new FFT_1D_Wrapper(this.m_bufferedWindowArray.length);
            }
            this.m_fftWindow.forward(this.m_bufferedWindowArray);
            float[] windowAmplitude = this.m_fftWindow.amplitude();
            float max = 0.0f;
            for (int n2 = 0; n2 < windowAmplitude.length; ++n2) {
                max = Math.max(max, windowAmplitude[n2]);
            }
            return max;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public void shift(float[] data, float shift) {
        try {
            this.setInputTrace(data);
            if (!this.m_inputValid) {
                return;
            }
            for (int n = 0; n < data.length; ++n) {
                data[n] = this.getValue((float)n - shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected float getValue(float inputSampleIndex) throws Exception {
        try {
            float outputSampleIndex = inputSampleIndex * (float)this.m_numUptick;
            if (outputSampleIndex < 0.0f) {
                return 0.0f;
            }
            int out1 = (int)outputSampleIndex;
            if (out1 <= 0) {
                return this.m_outputTrace[0];
            }
            int out2 = out1 + 1;
            if (out2 >= this.m_outputTrace.length) {
                return this.m_outputTrace[this.m_outputTrace.length - 1];
            }
            float frac = outputSampleIndex - (float)out1;
            return (1.0f - frac) * this.m_outputTrace[out1] + frac * this.m_outputTrace[out2];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setInputTrace(float[] data) {
        try {
            int n;
            this.m_inputValid = false;
            if (data == null) {
                return;
            }
            if (data.length < 4) {
                return;
            }
            if (this.m_inputTrace.length < data.length) {
                this.m_inputTrace = new float[data.length];
            }
            System.arraycopy(data, 0, this.m_inputTrace, 0, data.length);
            if (this.m_inputTrace.length > this.m_fftInput.getPowerOfTwo()) {
                this.m_fftInput = new FFT_1D_Wrapper(this.m_inputTrace.length);
            }
            this.m_fftInput.forward(this.m_inputTrace);
            int inputPowerOfTwo = this.m_fftInput.getPowerOfTwo();
            int outputPowerOfTwo = this.m_numUptick * inputPowerOfTwo;
            if (this.m_outputTrace.length != outputPowerOfTwo) {
                this.m_outputTrace = new float[outputPowerOfTwo];
            }
            if (outputPowerOfTwo != this.m_fftOutput.getPowerOfTwo()) {
                this.m_fftOutput = new FFT_1D_Wrapper(outputPowerOfTwo);
            }
            this.m_fftOutput.clearArrays();
            int inputHalf = inputPowerOfTwo / 2;
            float[] outputReal = this.m_fftOutput.real();
            float[] outputImag = this.m_fftOutput.imag();
            float[] inputReal = this.m_fftInput.real();
            float[] inputImag = this.m_fftInput.imag();
            int outputLast = outputPowerOfTwo - 1;
            int inputLast = inputPowerOfTwo - 1;
            float scalar = (float)Math.sqrt(this.m_numUptick);
            for (n = 0; n < outputReal.length; ++n) {
                outputReal[n] = 0.0f;
                outputImag[n] = 0.0f;
            }
            for (n = 0; n < inputHalf; ++n) {
                outputReal[n] = scalar * inputReal[n];
                outputImag[n] = scalar * inputImag[n];
                outputReal[outputLast - n] = scalar * inputReal[inputLast - n];
                outputImag[outputLast - n] = scalar * inputImag[inputLast - n];
            }
            this.m_fftOutput.setForwardInputDataLength(this.m_outputTrace.length);
            this.m_fftOutput.inverse(this.m_outputTrace);
            this.m_inputValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

