/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Map.HashMap_Long;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Tools_Ensemble {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected float[] m_tempArray = new float[100];
    protected HashMap_Integer m_hashMap = new HashMap_Integer();
    protected static Tools_Ensemble m_singleton = null;

    public static Tools_Ensemble singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Tools_Ensemble();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void clearFlagTracesForInputEnsemble(Ensemble ensemble) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.FlaggedForInputEnsemble = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void flagTracesForInputEnsemble(Ensemble ensemble, String table, String column, double min, double max) {
        try {
            if (!ensemble.dictionary().containsEntry(table, column)) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex(table, column);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double v = trace.header().getDouble(index);
                trace.FlaggedForInputEnsemble = trace.FlaggedForInputEnsemble && v >= min && v <= max;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void prepTempAxisValue(Ensemble ensemble) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", "TempAxisValue", DataType.Double);
            if (ensemble.traceCount() < 1) {
                return;
            }
            double scalar = 1000.0 / (double)ensemble.traceCount();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double axis = (double)n * scalar;
                ensemble.trace(n).header().putDouble(index, axis);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void prepKilledHash(Ensemble ensemble, HashMap_Long hashMap) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            int indexKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            int indexIndex = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                long traceIndex = ensemble.trace(n).header().getLong(indexIndex);
                int killed = 0;
                if (indexKilled >= 0) {
                    killed = ensemble.trace(n).header().getInt(indexKilled);
                }
                hashMap.put(traceIndex, killed);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void updateKillFlags(Ensemble parent, Ensemble child) {
        try {
            int n;
            HashMap_Long hashMap = new HashMap_Long();
            int indexChildKilled = child.dictionary().getEntryIndex("Trace", "Killed");
            int indexChildIndex = child.dictionary().getEntryIndex("Trace", "TraceIndex");
            int indexParentKilled = parent.dictionary().getEntryIndex("Trace", "Killed");
            int indexParentIndex = parent.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (n = 0; n < child.traceCount(); ++n) {
                long traceIndex = child.trace(n).header().getLong(indexChildIndex);
                hashMap.put(traceIndex, n);
            }
            for (n = 0; n < parent.traceCount(); ++n) {
                long l = parent.trace(n).header().getLong(indexParentIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeDCBias(Ensemble ensemble, boolean kill, double window) {
        try {
            int indexBias = ensemble.dictionary().addEntry("Trace", "Biased", DataType.Bool);
            int indexMaxLength = ensemble.dictionary().addEntry("Trace", "MaxDcWindow", DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putBool(indexBias, false);
                trace.DC_Biased = false;
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(window / (double)data.getSampleInterval());
                float avgAmp = data.averageAbsoluteAmplitude();
                float posBias = 0.001f * avgAmp;
                float negBias = -0.001f * avgAmp;
                boolean isPos = false;
                boolean isNeg = false;
                int maxBiasCount = 0;
                int biasCount = 0;
                for (int s = 0; s < this.m_tempArray.length; ++s) {
                    if (isPos) {
                        if (this.m_tempArray[s] > 0.0f) {
                            ++biasCount;
                            continue;
                        }
                        maxBiasCount = Math.max(maxBiasCount, biasCount);
                        isPos = false;
                        isNeg = false;
                        biasCount = 0;
                        continue;
                    }
                    if (isNeg) {
                        if (this.m_tempArray[s] < 0.0f) {
                            ++biasCount;
                            continue;
                        }
                        maxBiasCount = Math.max(maxBiasCount, biasCount);
                        isPos = false;
                        isNeg = false;
                        biasCount = 0;
                        continue;
                    }
                    if (this.m_tempArray[s] > posBias) {
                        isPos = true;
                        biasCount = 1;
                        continue;
                    }
                    if (!(this.m_tempArray[s] < negBias)) continue;
                    isNeg = true;
                    biasCount = 1;
                }
                maxBiasCount = Math.max(maxBiasCount, biasCount);
                float dcwin = trace.data().getSampleInterval() * (float)maxBiasCount;
                trace.header().putFloat(indexMaxLength, dcwin);
                if (!((double)dcwin > window) || !kill) continue;
                trace.DC_Biased = true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeNoiseLevel(Ensemble ensemble, boolean addNoiseLevelToHeader, boolean addKilledToHeader, float windowLength, float killLevel, boolean kill) {
        try {
            int indexNoise = -9999;
            if (addNoiseLevelToHeader) {
                indexNoise = ensemble.dictionary().addEntry("Trace", "NoiseLevel", DataType.Double);
            }
            int indexKilled = -9999;
            if (addKilledToHeader) {
                indexKilled = ensemble.dictionary().addEntry("Trace", "Killed", DataType.Int);
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(windowLength / data.getSampleInterval());
                float noise = 100.0f * this.m_renorm.computeNoiseLevel(this.m_tempArray, totalWindowLength);
                if (indexNoise >= 0) {
                    trace.header().putDouble(indexNoise, noise);
                }
                trace.TooNoisy = false;
                if (!kill || !(noise > killLevel)) continue;
                trace.TooNoisy = true;
                if (indexKilled < 0) continue;
                trace.header().putInt(indexKilled, 1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static float getSyntheticDelayTime(double x, double y) {
        try {
            return 50.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 20.0f;
        }
    }

    public static float getSyntheticAnisAz(double x, double y) {
        try {
            return 1.5707964f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public static float getSyntheticAnisMag(double x, double y) {
        try {
            return 3.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public static void createSineWaves(Ensemble ensemble) {
        try {
            float[] data = new float[500];
            float digi = 0.004f;
            if (ensemble.traceCount() < 3) {
                return;
            }
            double minFreq = 5.0;
            double maxFreq = 80.0;
            int indexF = ensemble.dictionary().addEntry("Trace", "Frequency", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double freq = minFreq + (double)n * (maxFreq - minFreq) / (double)(ensemble.traceCount() - 1);
                trace.header().putDouble(indexF, freq);
                double phase = 0.01 * (double)n;
                for (int s = 0; s < data.length; ++s) {
                    double temp = Math.PI * 2 * (double)s * (double)digi * freq;
                    data[s] = 1000.0f * (float)Math.sin(phase + temp);
                }
                FloatArrayWrapper wrapper = trace.data();
                wrapper.insertArray(data, data.length);
                wrapper.setSampleInterval(1000.0f * digi);
                wrapper.setFirstSampleCoord(0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void createSynthetic(Ensemble ensemble) {
        try {
            float vel = 7000.0f;
            float[] data = new float[500];
            float digi = 4.0f;
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexAzimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                float offset = trace.header().getFloat(indexOffset);
                float azimuth = trace.header().getFloat(indexAzimuth);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                float shotDT = Tools_Ensemble.getSyntheticDelayTime(sx, sy);
                float shotAnisAz = Tools_Ensemble.getSyntheticAnisAz(sx, sy);
                float shotAnisMag = Tools_Ensemble.getSyntheticAnisMag(sx, sy);
                float recDT = Tools_Ensemble.getSyntheticDelayTime(rx, ry);
                float recAnisAz = Tools_Ensemble.getSyntheticAnisAz(rx, ry);
                float recAnisMag = Tools_Ensemble.getSyntheticAnisMag(rx, ry);
                float time = (shotDT += shotAnisMag * (float)Math.cos(2.0 * (double)(azimuth - shotAnisAz))) + (recDT += recAnisMag * (float)Math.cos(2.0 * (double)(azimuth - recAnisAz))) + 1000.0f * offset / vel;
                for (int s = 0; s < data.length; ++s) {
                    float dt = Math.abs(time - (float)s * digi);
                    float exp = (float)Math.exp(0.0 - (double)dt / 25.0);
                    float cos = (float)Math.cos((double)dt * 6.28 / 30.0);
                    float rand = 0.5f - (float)Math.random();
                    data[s] = 20.0f * exp * cos + rand;
                }
                FloatArrayWrapper wrapper = trace.data();
                wrapper.insertArray(data, data.length);
                wrapper.setSampleInterval(digi);
                wrapper.setFirstSampleCoord(0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void findLastValidSample(Ensemble ensemble) {
        try {
            int indexTraceCode = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "TraceCode")) {
                indexTraceCode = ensemble.dictionary().addEntry("Trace", "TraceCode", DataType.Int);
            }
            int index = ensemble.dictionary().addEntry("Trace", "LastValidSample", DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                trace.header().putInt(index, -99999);
                if (indexTraceCode < 0) continue;
                int last = wrapper.lastValidSampleIndex();
                trace.header().putInt(index, last);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void findFirstValidSample(Ensemble ensemble) {
        try {
            int indexTraceCode = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "TraceCode")) {
                indexTraceCode = ensemble.dictionary().addEntry("Trace", "TraceCode", DataType.Int);
            }
            int index = ensemble.dictionary().addEntry("Trace", "FirstValidSample", DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                trace.header().putInt(index, -9999);
                if (indexTraceCode >= 0) {
                    int traceCode = trace.header().getInt(indexTraceCode);
                    if (traceCode != 1) continue;
                    int first = wrapper.firstValidSampleIndex();
                    trace.header().putInt(index, first);
                    continue;
                }
                int first = wrapper.firstValidSampleIndex();
                trace.header().putInt(index, first);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeMaximumAmplitude(Ensemble ensemble, String colName) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", colName, DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float sum = 0.0f;
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                float max = wrapper.absoluteMax();
                ensemble.trace(n).header().putFloat(index, max);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeMaximumAmplitude_Buffer(Ensemble ensemble, String colName, int buff) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", colName, DataType.Float);
            float[] data = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float max = 0.0f;
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                if (wrapper.length() > buff) {
                    if (data.length != wrapper.length()) {
                        data = new float[wrapper.length()];
                    }
                    wrapper.copyToArray(data);
                    for (int s = buff; s < data.length - buff; ++s) {
                        max = Math.max(max, Math.abs(data[s]));
                    }
                }
                ensemble.trace(n).header().putFloat(index, max);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static boolean setTracePolarity(Ensemble ensemble, long traceIndex, boolean polarity) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Flags")) {
                return false;
            }
            int headerIndexFlag = ensemble.dictionary().getEntryIndex("Trace", "Flags");
            int headerIndexTrace = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                long tempTraceIndex = trace.header().getLong(headerIndexTrace);
                if (tempTraceIndex != traceIndex) continue;
                Tools_Ensemble.setFlag(trace, headerIndexFlag, 1, polarity);
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static void setFlag(EnsembleTrace trace, int headerIndex, int flagBit, boolean setFlagOn) throws Exception {
        try {
            int current = trace.header().getInt(headerIndex);
            current = setFlagOn ? (current |= flagBit) : (current &= ~flagBit);
            trace.header().putInt(headerIndex, current);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static boolean getFlag(EnsembleTrace trace, int headerIndex, int flagBit) throws Exception {
        try {
            int current = trace.header().getInt(headerIndex);
            return (current &= flagBit) != 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static boolean toggleFlag(EnsembleTrace trace, int headerIndex, int flagBit) throws Exception {
        try {
            if (Tools_Ensemble.getFlag(trace, headerIndex, flagBit)) {
                Tools_Ensemble.setFlag(trace, headerIndex, flagBit, false);
            } else {
                Tools_Ensemble.setFlag(trace, headerIndex, flagBit, true);
            }
            return Tools_Ensemble.getFlag(trace, headerIndex, flagBit);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static float fanAmplitude(Ensemble ensemble, double minVel, double maxVel, double maxOffset, double timeBuffer) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Offset")) {
                return 0.0f;
            }
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            float sum = 0.0f;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double offset = ensemble.trace(n).header().getDouble(indexOffset);
                if (!(offset <= maxOffset)) continue;
                double minTime = 1000.0 * offset / maxVel - timeBuffer;
                double maxTime = 1000.0 * offset / minVel + timeBuffer;
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                float amp = wrapper.amplitudeSum((float)minTime, (float)maxTime);
                sum += amp;
            }
            return sum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public static void computeEnergy(Ensemble ensemble, String colName, float maxTime) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", colName, DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float sum = 0.0f;
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                float amp = wrapper.energy(maxTime);
                ensemble.trace(n).header().putFloat(index, amp);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void removeAverageValue(Ensemble e) {
        try {
            for (int n = 0; n < e.traceCount(); ++n) {
                e.trace(n).data().removeAverageValue();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeAverageAmplitude(Ensemble ensemble, String colName) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", colName, DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float sum = 0.0f;
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                float amp = wrapper.averageAbsoluteAmplitude();
                ensemble.trace(n).header().putFloat(index, amp);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Table_Abstract createEmptyTable(Ensemble ensemble, String tableName) {
        try {
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName(tableName);
            ArrayList<String> columnNames = ensemble.dictionary().getListOfColumnNames(tableName);
            for (String columnName : columnNames) {
                DataType type = ensemble.dictionary().getPreferredType(tableName, columnName);
                ((Table_Abstract)table).column_append(columnName, type);
            }
            return table;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static Table_Abstract createPopulatedTable(Ensemble ensemble, String tableName) {
        try {
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName(tableName);
            ArrayList<String> columnNames = ensemble.dictionary().getListOfColumnNames(tableName);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ((Table_Abstract)table).row_increment();
            }
            for (String columnName : columnNames) {
                DataType type = ensemble.dictionary().getPreferredType(tableName, columnName);
                ((Table_Abstract)table).column_append(columnName, DataType.Int);
                int index1 = ensemble.dictionary().getEntryIndex(tableName, columnName);
                int index2 = ((Table_Abstract)table).column_indexOfColumn(columnName);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    ((Table_Abstract)table).putInt(n, index2, ensemble.trace(n).header().getInt(index1));
                }
            }
            return table;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static void copyHeaderValue(Ensemble ensemble, String tableNameFrom, String columnNameFrom, String tableNameTo, String columnNameTo) {
        try {
            if (ensemble == null) {
                return;
            }
            if (!ensemble.dictionary().containsEntry(tableNameFrom, columnNameFrom)) {
                return;
            }
            int indexFrom = ensemble.dictionary().getEntryIndex(tableNameFrom, columnNameFrom);
            DataType type = ensemble.dictionary().getPreferredType(tableNameFrom, columnNameFrom);
            int indexTo = ensemble.dictionary().addEntry(tableNameTo, columnNameTo, type);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                if (type == DataType.Bool) {
                    header.putBool(indexTo, header.getBool(indexFrom));
                    continue;
                }
                if (type == DataType.Short || type == DataType.Int) {
                    header.putInt(indexTo, header.getInt(indexFrom));
                    continue;
                }
                header.putDouble(indexTo, header.getDouble(indexFrom));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int copyHeaderValue(Ensemble sourceEnsemble, Ensemble targetEnsemble, String tableName, String columnName) {
        try {
            if (sourceEnsemble == null || targetEnsemble == null) {
                return 0;
            }
            if (!sourceEnsemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                return 0;
            }
            if (!sourceEnsemble.dictionary().containsEntry("Shot", "ShotID")) {
                return 0;
            }
            if (!sourceEnsemble.dictionary().containsEntry(tableName, columnName)) {
                return 0;
            }
            if (!targetEnsemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                return 0;
            }
            if (!targetEnsemble.dictionary().containsEntry("Shot", "ShotID")) {
                return 0;
            }
            if (!targetEnsemble.dictionary().containsEntry(tableName, columnName)) {
                return 0;
            }
            HashMap_Integers<Double> hash = new HashMap_Integers<Double>();
            int indexSource_ShotID = sourceEnsemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexSource_RecID = sourceEnsemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexSource_Col = sourceEnsemble.dictionary().getEntryIndex(tableName, columnName);
            for (int s = 0; s < sourceEnsemble.traceCount(); ++s) {
                int source_ShotID = sourceEnsemble.trace(s).header().getInt(indexSource_ShotID);
                int source_RecID = sourceEnsemble.trace(s).header().getInt(indexSource_RecID);
                double v = sourceEnsemble.trace(s).header().getDouble(indexSource_Col);
                hash.put(v, source_ShotID, source_RecID);
            }
            int indexTarget_ShotID = targetEnsemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexTarget_RecID = targetEnsemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexTarget_Col = targetEnsemble.dictionary().getEntryIndex(tableName, columnName);
            int numModified = 0;
            for (int t = 0; t < targetEnsemble.traceCount(); ++t) {
                int target_RecID;
                int target_ShotID = targetEnsemble.trace(t).header().getInt(indexTarget_ShotID);
                if (!hash.containsKey(target_ShotID, target_RecID = targetEnsemble.trace(t).header().getInt(indexTarget_RecID))) continue;
                double v = (Double)hash.get(target_ShotID, target_RecID);
                targetEnsemble.trace(t).header().putDouble(indexTarget_Col, v);
                ++numModified;
            }
            return numModified;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public static boolean isBin3DEnsemble(Ensemble ensemble, int inline, int xline) throws Exception {
        try {
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Inline")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Crossline")) {
                return false;
            }
            int indexInline = ensemble.dictionary().getEntryIndex("Trace", "Inline");
            int indexCrossline = ensemble.dictionary().getEntryIndex("Trace", "Crossline");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                if (inline != ensemble.trace(n).header().getInt(indexInline)) {
                    return false;
                }
                if (xline == ensemble.trace(n).header().getInt(indexCrossline)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static void flipShotPolarity(Ensemble ensemble, int id) throws Exception {
        try {
            int indexID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexPol = ensemble.dictionary().getEntryIndex("Shot", "Polarity");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (trace.header().getInt(indexID) != id) continue;
                double polarity = trace.header().getDouble(indexPol);
                if (polarity > 0.0) {
                    trace.header().putDouble(indexPol, -1.0);
                } else {
                    trace.header().putDouble(indexPol, 1.0);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void flipReceiverPolarity(Ensemble ensemble, int id) throws Exception {
        try {
            int indexID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexPol = ensemble.dictionary().getEntryIndex("Receiver", "Polarity");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (trace.header().getInt(indexID) != id) continue;
                double polarity = trace.header().getDouble(indexPol);
                if (polarity > 0.0) {
                    trace.header().putDouble(indexPol, -1.0);
                } else {
                    trace.header().putDouble(indexPol, 1.0);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int isReceiverEnsemble(Ensemble ensemble) throws Exception {
        try {
            if (ensemble == null) {
                return -9999;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                return -9999;
            }
            if (ensemble.traceCount() < 1) {
                return -9999;
            }
            int indexElemID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int id = ensemble.trace(0).header().getInt(indexElemID);
            for (int n = 1; n < ensemble.traceCount(); ++n) {
                if (id == ensemble.trace(n).header().getInt(indexElemID)) continue;
                return -9999;
            }
            return id;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static int isShotEnsemble(Ensemble ensemble) throws Exception {
        try {
            if (ensemble == null) {
                return -9999;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "ShotID")) {
                return -9999;
            }
            if (ensemble.traceCount() < 1) {
                return -9999;
            }
            int indexElemID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int id = ensemble.trace(0).header().getInt(indexElemID);
            for (int n = 1; n < ensemble.traceCount(); ++n) {
                if (id == ensemble.trace(n).header().getInt(indexElemID)) continue;
                return -9999;
            }
            return id;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static boolean hasReceiverID(Ensemble ensemble, int id) throws Exception {
        try {
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                return false;
            }
            if (ensemble.traceCount() < 1) {
                return false;
            }
            int indexElemID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                if (id != ensemble.trace(n).header().getInt(indexElemID)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean hasShotID(Ensemble ensemble, int id) throws Exception {
        try {
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "ShotID")) {
                return false;
            }
            if (ensemble.traceCount() < 1) {
                return false;
            }
            int indexElemID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                if (id != ensemble.trace(n).header().getInt(indexElemID)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static void makeSureSameShot(Ensemble ensemble) throws Exception {
        try {
            int indexTraceID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexElemID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexLine = ensemble.dictionary().getEntryIndex("Shot", "LineNumber");
            int indexPoint = ensemble.dictionary().getEntryIndex("Shot", "PointNumber");
            int indexIndex = ensemble.dictionary().getEntryIndex("Shot", "PointIndex");
            int firstTraceID = ensemble.trace(0).header().getInt(indexTraceID);
            int firstElemID = ensemble.trace(0).header().getInt(indexElemID);
            int firstLine = ensemble.trace(0).header().getInt(indexLine);
            int firstPoint = ensemble.trace(0).header().getInt(indexPoint);
            int firstIndex = ensemble.trace(0).header().getInt(indexIndex);
            if (firstTraceID != firstElemID) {
                throw new Exception("firstTraceID != firstElemID");
            }
            for (int n = 1; n < ensemble.traceCount(); ++n) {
                int traceID = ensemble.trace(n).header().getInt(indexTraceID);
                int elemID = ensemble.trace(n).header().getInt(indexElemID);
                int line = ensemble.trace(n).header().getInt(indexLine);
                int point = ensemble.trace(n).header().getInt(indexPoint);
                long index = ensemble.trace(n).header().getLong(indexIndex);
                if (firstTraceID != traceID) {
                    throw new Exception("firstTraceID != traceID");
                }
                if (firstElemID != elemID) {
                    throw new Exception("firstElemID != elemID");
                }
                if (firstLine != line) {
                    throw new Exception("firstLine != line");
                }
                if (firstPoint != point) {
                    throw new Exception("firstPoint != point");
                }
                if ((long)firstIndex == index) continue;
                throw new Exception("firstIndex != index");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void makeSureSameReceiver(Ensemble ensemble) throws Exception {
        try {
            int indexTraceID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexElemID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexLine = ensemble.dictionary().getEntryIndex("Receiver", "LineNumber");
            int indexPoint = ensemble.dictionary().getEntryIndex("Receiver", "PointNumber");
            int indexIndex = ensemble.dictionary().getEntryIndex("Receiver", "PointIndex");
            int firstTraceID = ensemble.trace(0).header().getInt(indexTraceID);
            int firstElemID = ensemble.trace(0).header().getInt(indexElemID);
            int firstLine = ensemble.trace(0).header().getInt(indexLine);
            int firstPoint = ensemble.trace(0).header().getInt(indexPoint);
            int firstIndex = ensemble.trace(0).header().getInt(indexIndex);
            if (firstTraceID != firstElemID) {
                throw new Exception("firstTraceID != firstElemID");
            }
            for (int n = 1; n < ensemble.traceCount(); ++n) {
                int traceID = ensemble.trace(n).header().getInt(indexTraceID);
                int elemID = ensemble.trace(n).header().getInt(indexElemID);
                int line = ensemble.trace(n).header().getInt(indexLine);
                int point = ensemble.trace(n).header().getInt(indexPoint);
                int index = ensemble.trace(n).header().getInt(indexIndex);
                if (firstTraceID != traceID) {
                    throw new Exception("firstTraceID != traceID");
                }
                if (firstElemID != elemID) {
                    throw new Exception("firstElemID != elemID");
                }
                if (firstLine != line) {
                    throw new Exception("firstLine != line");
                }
                if (firstPoint != point) {
                    throw new Exception("firstPoint != point");
                }
                if (firstIndex == index) continue;
                throw new Exception("firstIndex != index");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static int getMaximumHeaderValue(Ensemble ensemble, String table, String column) {
        try {
            int index = ensemble.dictionary().getEntryIndex(table, column);
            int max = Integer.MIN_VALUE;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int v = trace.header().getInt(index);
                max = Math.max(max, v);
            }
            return max;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Integer.MIN_VALUE;
        }
    }

    public static void setHeaderFloat(Ensemble ensemble, String table, String column, float v) {
        try {
            int index = ensemble.dictionary().addEntry(table, column, DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putFloat(index, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void setHeaderValue(Ensemble ensemble, String table, String column, int startIndex, int startvalue, int increment) {
        try {
            int index = ensemble.dictionary().addEntry(table, column, DataType.Int);
            int v = startvalue;
            for (int n = startIndex; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putInt(index, v);
                v += increment;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void setHeaderLong(Ensemble ensemble, String table, String column, int startIndex, long startValue, long increment) {
        try {
            int index = ensemble.dictionary().addEntry(table, column, DataType.Long);
            long v = startValue;
            for (int n = startIndex; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putLong(index, v);
                v += increment;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static boolean applyNormalMoveout(Ensemble ensemble, double velocity, double time) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Offset") && !Tools_Ensemble.computeAzimuthAndOffset(ensemble)) {
                return false;
            }
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            time *= 0.001;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double tnmo = Math.sqrt(time * time + offset * offset / (velocity * velocity));
                double shift = 1000.0 * (time - tnmo);
                trace.data().addShiftToFirstSampleCoord((float)shift);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean applyLinearMoveout_ZeroMean(Ensemble ensemble, double velocity) {
        try {
            return Tools_Ensemble.applyLinearMoveout_ZeroMean(ensemble, velocity, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean applyLinearMoveout_ZeroMean(Ensemble ensemble, double velocity, boolean undo) {
        try {
            if (ensemble.traceCount() < 2) {
                return true;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Offset") && !Tools_Ensemble.computeAzimuthAndOffset(ensemble)) {
                return false;
            }
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            double sum = 0.0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double shift = 1000.0 * offset / velocity;
                if (undo) {
                    shift = -shift;
                }
                sum += shift;
            }
            double avg = sum / (double)ensemble.traceCount();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double shift = 1000.0 * offset / velocity;
                if (undo) {
                    shift = -shift;
                }
                trace.data().addShiftToFirstSampleCoord(-((float)(shift -= avg)));
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static double maximumOffset(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Offset") && !Tools_Ensemble.computeAzimuthAndOffset(ensemble)) {
                return 0.0;
            }
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            double maxOff = 0.0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                maxOff = Math.max(maxOff, offset);
            }
            return maxOff;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public static void writeHeaderstoAscii(Ensemble ensemble, String fileName) {
        try {
            EnsembleHeaderDictionary.Entry e;
            int n;
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int num = dict.size();
            for (n = 0; n < num; ++n) {
                e = dict.getEntry(n);
                writer.write(e.Table);
                if (n >= num - 1) continue;
                writer.write(",");
            }
            writer.newLine();
            for (n = 0; n < num; ++n) {
                e = dict.getEntry(n);
                writer.write(e.Column);
                if (n >= num - 1) continue;
                writer.write(",");
            }
            writer.newLine();
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                EnsembleTrace trace = ensemble.trace(t);
                for (int n2 = 0; n2 < num; ++n2) {
                    EnsembleHeaderDictionary.Entry e2 = dict.getEntry(n2);
                    String s = trace.header().getString(e2.Index);
                    writer.write(s);
                    if (n2 >= num - 1) continue;
                    writer.write(",");
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static boolean applyLinearMoveout(Ensemble ensemble, double velocity) {
        try {
            return Tools_Ensemble.applyLinearMoveout(ensemble, velocity, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean applyLinearMoveout(Ensemble ensemble, double velocity, boolean undo) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Offset") && !Tools_Ensemble.computeAzimuthAndOffset(ensemble)) {
                return false;
            }
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double shift = 1000.0 * offset / velocity;
                if (undo) {
                    shift = -shift;
                }
                trace.data().addShiftToFirstSampleCoord(-((float)shift));
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean computeInlineCrossline(Ensemble ensemble, Grid3D_Conversion grid3D) {
        try {
            boolean ok;
            boolean bl = ok = ensemble.dictionary().containsEntry("Shot", "Easting") && ensemble.dictionary().containsEntry("Shot", "Northing") && ensemble.dictionary().containsEntry("Receiver", "Easting") && ensemble.dictionary().containsEntry("Receiver", "Northing");
            if (!ok) {
                return false;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexReceiverX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexReceiverY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
            int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double shotX = trace.header().getDouble(indexShotX);
                double shotY = trace.header().getDouble(indexShotY);
                double receiverX = trace.header().getDouble(indexReceiverX);
                double receiverY = trace.header().getDouble(indexReceiverY);
                double offX = receiverX - shotX;
                double offY = receiverY - shotY;
                grid3D.setWorldLocation(0.5 * (receiverX + shotX), 0.5 * (receiverY + shotY));
                trace.header().putDouble(indexInline, grid3D.Inline);
                trace.header().putDouble(indexCrossline, grid3D.Crossline);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean setReceiverCoords(Ensemble ensemble, double x, double y) {
        try {
            boolean ok;
            boolean bl = ok = ensemble.dictionary().containsEntry("Receiver", "Easting") && ensemble.dictionary().containsEntry("Receiver", "Northing");
            if (!ok) {
                return false;
            }
            int indexReceiverX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexReceiverY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putDouble(indexReceiverX, x);
                trace.header().putDouble(indexReceiverY, y);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean setShotCoords(Ensemble ensemble, double x, double y) {
        try {
            boolean ok;
            boolean bl = ok = ensemble.dictionary().containsEntry("Shot", "Easting") && ensemble.dictionary().containsEntry("Shot", "Northing");
            if (!ok) {
                return false;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.header().putDouble(indexShotX, x);
                trace.header().putDouble(indexShotY, y);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean computeAzimuthAndOffset(Ensemble ensemble) {
        try {
            boolean ok;
            boolean bl = ok = ensemble.dictionary().containsEntry("Shot", "Easting") && ensemble.dictionary().containsEntry("Shot", "Northing") && ensemble.dictionary().containsEntry("Receiver", "Easting") && ensemble.dictionary().containsEntry("Receiver", "Northing");
            if (!ok) {
                return false;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexReceiverX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexReceiverY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Double);
            int indexAzimuth = ensemble.dictionary().addEntry("Trace", "Azimuth", DataType.Double);
            int indexMidX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexMidY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double shotX = trace.header().getDouble(indexShotX);
                double shotY = trace.header().getDouble(indexShotY);
                double receiverX = trace.header().getDouble(indexReceiverX);
                double receiverY = trace.header().getDouble(indexReceiverY);
                double offX = receiverX - shotX;
                double offY = receiverY - shotY;
                double offset = Math.sqrt(offX * offX + offY * offY);
                double azimuth = Math.atan2(offY, offX);
                trace.header().putDouble(indexOffset, offset);
                trace.header().putDouble(indexAzimuth, azimuth);
                trace.header().putDouble(indexMidX, 0.5 * (receiverX + shotX));
                trace.header().putDouble(indexMidY, 0.5 * (receiverY + shotY));
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static void deleteTracesOutsideRange(Ensemble ensemble, double min, double max, String table, String column) throws Exception {
        try {
            if (!ensemble.dictionary().containsEntry(table, column)) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex(table, column);
            for (int n = ensemble.traceCount() - 1; n >= 0; --n) {
                double v = ensemble.trace(n).header().getDouble(index);
                if (!(v < min) && !(v > max)) continue;
                ensemble.removeTrace(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static boolean computeTraceHeaderRange(Range_Double range, Ensemble ensemble, String table, String column) throws Exception {
        try {
            range.clearRange();
            if (!ensemble.dictionary().containsEntry(table, column)) {
                return false;
            }
            int index = ensemble.dictionary().getEntryIndex(table, column);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double v = ensemble.trace(n).header().getDouble(index);
                range.expandRange(v);
            }
            return range.rangeValid();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static Ensemble createChildEnsemble(Ensemble ensemble, int start, int count) throws Exception {
        try {
            ArrayList<EnsembleTrace> list = new ArrayList<EnsembleTrace>();
            for (int n = 0; n < count; ++n) {
                int index = n + start;
                if (index < 0 || index >= ensemble.traceCount()) continue;
                list.add(ensemble.trace(index));
            }
            return new Ensemble(ensemble.dictionary(), list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void killDC(Ensemble ensemble) throws Exception {
        try {
            if (ensemble == null) {
                return;
            }
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.PureDC = trace.data().isDC();
                if (indexTraceKilled >= 0) {
                    trace.TraceKilled = trace.header().getBool(indexTraceKilled);
                }
                boolean bl = trace.TraceKilled = trace.TraceKilled || trace.PureDC;
                if (indexTraceKilled < 0) continue;
                trace.header().putBool(indexTraceKilled, trace.TraceKilled);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void killTraces(Ensemble ensemble) throws Exception {
        try {
            int indexShotKilled = -9999;
            int indexRecKilled = -9999;
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "Killed")) {
                indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            }
            if (ensemble.dictionary().containsEntry("Receiver", "Killed")) {
                indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            }
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                boolean killed = false;
                if (indexShotKilled >= 0) {
                    trace.ShotKilled = trace.header().getBool(indexShotKilled);
                }
                if (indexRecKilled >= 0) {
                    trace.ReceiverKilled = trace.header().getBool(indexRecKilled);
                }
                if (indexTraceKilled < 0) continue;
                trace.TraceKilled = trace.header().getBool(indexTraceKilled);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static Ensemble createChildEnsemble(Ensemble ensemble, String table, String column, int val) throws Exception {
        try {
            ArrayList<EnsembleTrace> list = new ArrayList<EnsembleTrace>();
            if (!ensemble.dictionary().containsEntry(table, column)) {
                return new Ensemble(ensemble.dictionary(), list);
            }
            int index = ensemble.dictionary().getEntryIndex(table, column);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                if (ensemble.trace(n).header().getInt(index) != val) continue;
                list.add(ensemble.trace(n));
            }
            return new Ensemble(ensemble.dictionary(), list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static ArrayList<Integer> getUniqueHeaderArray(Ensemble ensemble, String table, String column) throws Exception {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (!ensemble.dictionary().containsEntry(table, column)) {
                return list;
            }
            HashMap<HashKey_Integer, Integer> map = new HashMap<HashKey_Integer, Integer>();
            int index = ensemble.dictionary().getEntryIndex(table, column);
            HashKey_Integer key = new HashKey_Integer(1);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                key.Key = ensemble.trace(n).header().getInt(index);
                if (map.containsKey(key)) continue;
                list.add(new Integer(key.Key));
                map.put(new HashKey_Integer(key.Key), new Integer(key.Key));
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

