/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class EnsembleHeaderDictionary
implements Serializable {
    protected ArrayList<Entry> m_list = new ArrayList();
    protected ArrayList<Entry> m_dummyList = new ArrayList();

    public EnsembleHeaderDictionary() {
    }

    protected EnsembleHeaderDictionary(EnsembleHeaderDictionary dict, ArrayList<Entry> list) throws Exception {
        try {
            for (Entry e : list) {
                this.addEntry(e.Table, e.Column, e.PreferredType, e.ArrayLength);
            }
            for (Entry e : this.m_list) {
                e.Index = dict.getEntryIndex(e.Table, e.Column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int size() {
        return this.m_list.size();
    }

    public void print() {
        try {
            for (int n = 0; n < this.m_list.size(); ++n) {
                Entry e = this.getEntry(n);
                System.out.println("Dictionary entry: " + n + ", " + e.Table + ", " + e.Column + ", " + String.valueOf((Object)e.PreferredType));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            error.printStackTrace();
        }
    }

    public Entry getEntry(int index) throws Exception {
        try {
            return this.m_list.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clear() {
        try {
            this.m_dummyList.clear();
            for (Entry e : this.m_list) {
                this.m_dummyList.add(e);
            }
            this.m_list.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public EnsembleHeaderDictionary createExactCopy() throws Exception {
        try {
            return new EnsembleHeaderDictionary(this, this.m_list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean compare(EnsembleHeaderDictionary dict) {
        try {
            if (dict == null) {
                return false;
            }
            for (Entry e : this.m_list) {
                if (!dict.containsEntry(e.Table, e.Column)) {
                    return false;
                }
                if (dict.getEntryIndex(e.Table, e.Column) == this.getEntryIndex(e.Table, e.Column)) continue;
                return false;
            }
            ArrayList<Entry> list = dict.getList();
            for (Entry e : list) {
                if (!this.containsEntry(e.Table, e.Column)) {
                    return false;
                }
                if (dict.getEntryIndex(e.Table, e.Column) == this.getEntryIndex(e.Table, e.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected ArrayList<Entry> getList() {
        return this.m_list;
    }

    public ArrayList<Entry> getListOfColumns(String table) throws Exception {
        try {
            ArrayList<Entry> columns = new ArrayList<Entry>();
            for (Entry e : this.m_list) {
                if (!table.equals(e.Table)) continue;
                columns.add(e);
            }
            return columns;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ArrayList<String> getListOfColumnNames(String table, String prefix) throws Exception {
        try {
            ArrayList<String> columns = new ArrayList<String>();
            String upper = prefix.toUpperCase();
            for (Entry e : this.m_list) {
                if (!table.equals(e.Table) || !e.Column.toUpperCase().startsWith(upper)) continue;
                columns.add(e.Column);
            }
            Collections.sort(columns);
            return columns;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ArrayList<String> getListOfColumnNames(String table) throws Exception {
        try {
            ArrayList<String> columns = new ArrayList<String>();
            for (Entry e : this.m_list) {
                if (!table.equals(e.Table)) continue;
                columns.add(e.Column);
            }
            Collections.sort(columns);
            return columns;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ArrayList<String> getListOfFirstBreakNames() throws Exception {
        try {
            ArrayList<String> columns = new ArrayList<String>();
            for (Entry e : this.m_list) {
                if (!e.Table.equalsIgnoreCase("Trace") || !e.Column.startsWith("FBP_")) continue;
                columns.add(e.Column);
            }
            Collections.sort(columns);
            return columns;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ArrayList<String> getListOfTableNames() throws Exception {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            HashMap<String, String> tempHash = new HashMap<String, String>();
            for (Entry e : this.m_list) {
                if (e.Table.equalsIgnoreCase("Kill") || tempHash.containsKey(e.Table)) continue;
                tempHash.put(e.Table, e.Table);
                tables.add(e.Table);
            }
            Collections.sort(tables);
            return tables;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean containsEntry(String table, String column) throws Exception {
        try {
            if (table == null || column == null) {
                return false;
            }
            for (Entry e : this.m_list) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int addEntry(String table, String column, DataType preferredType) throws Exception {
        return this.addEntry(table, column, preferredType, 1);
    }

    public int addEntry(String table, String column, DataType preferredType, int iArrayLength) throws Exception {
        try {
            if (preferredType == DataType.Long) {
                int kkk = 0;
                ++kkk;
            }
            if (table.length() < 1 || column.length() < 1) {
                throw new Exception("Invalid names");
            }
            for (Entry e : this.m_list) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return e.Index;
            }
            for (Entry e : this.m_dummyList) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column) || preferredType != e.PreferredType) continue;
                e.Index = this.m_list.size();
                this.m_list.add(e);
                this.m_dummyList.remove(e);
                return e.Index;
            }
            Entry e = new Entry(table, column, preferredType, this.m_list.size(), iArrayLength);
            this.m_list.add(e);
            return e.Index;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public DataType getPreferredType(String table, String column) throws Exception {
        try {
            for (Entry e : this.m_list) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return e.PreferredType;
            }
            throw new Exception("entry does not exist");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getEntryIndex(String table, String column) throws Exception {
        try {
            for (Entry e : this.m_list) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return e.Index;
            }
            throw new Exception("entry does not exist");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getIndexInListArray(String table, String column) throws Exception {
        try {
            for (int n = 0; n < this.m_list.size(); ++n) {
                Entry e = this.m_list.get(n);
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return n;
            }
            throw new Exception("entry does not exist");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getEntryIndex_ReturnInvalid(String table, String column) throws Exception {
        try {
            for (Entry e : this.m_list) {
                if (!table.equalsIgnoreCase(e.Table) || !column.equalsIgnoreCase(e.Column)) continue;
                return e.Index;
            }
            return -9999;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static class Entry
    implements Serializable {
        public String Table;
        public String Column;
        public DataType PreferredType;
        public int Index = -999999;
        public DataType ConnectedColumnType;
        public int ConnectedColumnIndex = -999;
        public int ArrayLength = 1;

        public Entry(String table, String column, DataType preferredType, int index) {
            this.Table = table;
            this.Column = column;
            this.PreferredType = preferredType;
            this.Index = index;
            int ii = 0;
            if (this.Column.equals("3DM_YCORD") || this.Column.equals("NN_NORM_CONST")) {
                ++ii;
            }
            if (ii == 0) {
                ++ii;
            }
        }

        public Entry(String table, String column, DataType preferredType, int index, int iArrayLength) {
            this.Table = table;
            this.Column = column;
            this.PreferredType = preferredType;
            this.Index = index;
            this.ArrayLength = iArrayLength;
            int ii = 0;
            if (this.Column.equals("3DM_YCORD") || this.Column.equals("NN_NORM_CONST")) {
                ++ii;
            }
            if (ii == 0) {
                ++ii;
            }
        }

        public Entry createExactCopy() {
            return new Entry(this.Table, this.Column, this.PreferredType, this.Index, this.ArrayLength);
        }
    }
}

