/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import java.awt.Color;
import java.util.ArrayList;

public class EnsembleFirstBreakPickPlotData {
    protected ArrayList<Entry> m_entryList = new ArrayList();
    protected ArrayList<String> m_requiredPicks = new ArrayList();

    public boolean isPickRequired(String pick) {
        try {
            for (String p : this.m_requiredPicks) {
                if (!p.equalsIgnoreCase(pick)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void removeRequiredPick(String pick) {
        try {
            if (!pick.startsWith("FBP_")) {
                return;
            }
            for (int n = this.m_requiredPicks.size() - 1; n >= 0; --n) {
                String s = this.m_requiredPicks.get(n);
                if (!s.equalsIgnoreCase(pick)) continue;
                this.m_requiredPicks.remove(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addRequiredPick(String pick) {
        try {
            if (!pick.startsWith("FBP_")) {
                return;
            }
            for (String p : this.m_requiredPicks) {
                if (!p.equalsIgnoreCase(pick)) continue;
                return;
            }
            this.m_requiredPicks.add(pick);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearRequiredList() {
        this.m_requiredPicks.clear();
    }

    public Entry getEntry(String column) {
        try {
            for (Entry entry : this.m_entryList) {
                if (!entry.Column.equalsIgnoreCase(column)) continue;
                return entry;
            }
            Entry e = new Entry();
            this.m_entryList.add(e);
            e.Column = column;
            return e;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void add(String column, Color c, int size, Java2D_PointSymbol sym) {
        try {
            Entry e = this.getEntry(column);
            e.Symbol = sym;
            e.PickColor = c;
            e.SymbolSize = size;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clear() {
        this.m_entryList.clear();
    }

    public int size() {
        return this.m_entryList.size();
    }

    public Entry getEntry(int index) {
        return this.m_entryList.get(index);
    }

    public static class Entry {
        public String Column = "";
        public Color PickColor = Color.RED;
        public int SymbolSize = 9;
        public Java2D_PointSymbol Symbol = Java2D_PointSymbol.X;
    }
}

