/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable.Huge;

import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_SingleColumnIndexer;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;

public class TraceTable_Huge_Wrapper
implements ITraceTable_Wrapper {
    protected TraceTable_Huge_SingleColumnIndexer m_receiverIndexer;
    protected TraceTable_Huge_SingleColumnIndexer m_shotIndexer;
    protected TraceTable_Huge m_traceTable;
    protected Column_Long m_indexColumn = new Column_Long();
    protected int m_indexCount = 0;

    public TraceTable_Huge_SingleColumnIndexer receiverIndexer() {
        return this.m_receiverIndexer;
    }

    public TraceTable_Huge_SingleColumnIndexer shotIndexer() {
        return this.m_shotIndexer;
    }

    public TraceTable_Huge_Wrapper(String path) {
        try {
            this.m_traceTable = new TraceTable_Huge(path, "Trace");
            this.m_receiverIndexer = new TraceTable_Huge_SingleColumnIndexer(path, "ReceiverID");
            if (!this.m_receiverIndexer.valid() && this.m_traceTable.column_exists("ReceiverID")) {
                this.createIndex(this.m_receiverIndexer, "ReceiverID");
            }
            this.m_shotIndexer = new TraceTable_Huge_SingleColumnIndexer(path, "ShotID");
            if (!this.m_shotIndexer.valid() && this.m_traceTable.column_exists("ShotID")) {
                this.createIndex(this.m_shotIndexer, "ShotID");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void recreateReceiverIndex() {
        try {
            this.createIndex(this.m_receiverIndexer, "ReceiverID");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void recreateIndexers() {
        try {
            this.createIndex(this.m_shotIndexer, "ShotID");
            this.createIndex(this.m_receiverIndexer, "ReceiverID");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void exportColumn(String columnName, boolean forceInt) {
        try {
            if (!this.m_traceTable.column_exists(columnName)) {
                return;
            }
            int indexCol = this.m_traceTable.column_indexOfColumn(columnName);
            DataType type = this.m_traceTable.column_type(indexCol);
            boolean isInt = type == DataType.Int || type == DataType.Short;
            String fileName = this.m_traceTable.path() + "/" + columnName + "_export.txt";
            boolean numWritten = false;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            for (long row = 0L; row < this.m_traceTable.rowCount(); ++row) {
                if (isInt) {
                    out.println(Integer.toString(this.m_traceTable.getInt(row, indexCol)));
                } else {
                    float v = this.m_traceTable.getFloat(row, indexCol);
                    if (forceInt) {
                        out.println(Integer.toString(Math.round(v)));
                    } else {
                        out.println(Float.toString(v));
                    }
                }
                if (row % 100000L != 0L) continue;
                System.out.println(" " + row);
            }
            out.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, String columnName1, int min1, int max1, String columnName2, int min2, int max2) throws Exception {
        try {
            long start = System.currentTimeMillis();
            this.m_traceTable.populateEnsemble(ensemble, columnName1, min1, max1, columnName2, min2, max2);
            long l = System.currentTimeMillis();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void prepareIndexColumn(String columnName, int min, int max) throws Exception {
        try {
            int v;
            this.m_indexCount = 0;
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                for (v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    return;
                }
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                for (v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    return;
                }
            }
            int colIndex = this.m_traceTable.column_indexOfColumn(columnName);
            for (long row = 0L; row < this.m_traceTable.rowCount(); ++row) {
                int v2 = this.m_traceTable.getInt(row, colIndex);
                if (v2 < min || v2 > max) continue;
                this.m_indexColumn.putLong(this.m_indexCount, row);
                ++this.m_indexCount;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void setIntValueUsingPreparedIndices(String columnName, int v) throws Exception {
        try {
            if (!this.m_traceTable.column_exists(columnName)) {
                return;
            }
            int colIndex = this.m_traceTable.column_indexOfColumn(columnName);
            for (int n = 0; n < this.m_indexCount; ++n) {
                long row = this.m_indexColumn.getLong(n);
                this.m_traceTable.putInt(row, colIndex, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, String columnName, int min, int max) throws Exception {
        try {
            int v;
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                this.m_indexCount = 0;
                for (v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                    return;
                }
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                this.m_indexCount = 0;
                for (v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                    return;
                }
            }
            this.m_traceTable.populateEnsemble(ensemble, columnName, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void populateEnsemble(Ensemble ensemble, String columnName, List<Integer> values) throws Exception {
        try {
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                this.m_indexCount = 0;
                for (Integer v : values) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                    return;
                }
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                this.m_indexCount = 0;
                for (Integer v : values) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                if (this.m_indexCount > 0) {
                    this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                    return;
                }
            }
            this.m_traceTable.populateEnsemble(ensemble, columnName, values);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createIndex(TraceTable_Huge_SingleColumnIndexer indexer, String colName) throws Exception {
        try {
            indexer.clear();
            if (!this.m_traceTable.column_exists(colName)) {
                return;
            }
            indexer.prepare_new();
            int index = this.m_traceTable.column_indexOfColumn(colName);
            long rowCount = this.m_traceTable.rowCount();
            for (long row = 0L; row < rowCount; ++row) {
                int id = this.m_traceTable.getInt(row, index);
                indexer.add_new(id, row);
            }
            indexer.finish_new();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public String path() {
        return this.m_traceTable.path();
    }

    @Override
    public ITraceTable traceTable() {
        return this.m_traceTable;
    }
}

