/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Column_Bool;
import com.PecosCore.Data.Column_Double;
import com.PecosCore.Data.Column_Float;
import com.PecosCore.Data.Column_Int;
import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.Column_Text;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class Table_Memory
extends Table_Abstract
implements Serializable {
    protected int m_rowCount = 0;
    protected String m_name = "";
    protected ArrayList<Column_Abstract> m_columns = new ArrayList();
    protected ArrayList<Column_Abstract> m_columns_Unused = new ArrayList();

    public static Table_Abstract readCSV(String fileName) throws Exception {
        try {
            Table_Memory table = new Table_Memory();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            ArrayList<String> originalColumnNames = Tools_Strings.tokenizer_comma(line, true);
            for (String col : originalColumnNames) {
                ((Table_Abstract)table).column_append(col, DataType.Double);
            }
            line = br.readLine();
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_improved(line, ',');
                int r = ((Table_Abstract)table).row_increment();
                for (int c = 0; c < tokens.size(); ++c) {
                    double v = Double.parseDouble(tokens.get(c));
                    ((Table_Abstract)table).putDouble(r, c, v);
                }
                line = br.readLine();
            }
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Table_Abstract readBinaryTable(String fileName) throws Exception {
        try {
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).readBinary(fileName);
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Table_Abstract readTable(String path, String name) throws Exception {
        try {
            Table_Memory table = new Table_Memory();
            String fileNameXML = path + "/" + name + ".xml";
            if (Tools_FileSystem.exists_file(fileNameXML)) {
                table.importXML(fileNameXML);
                return table;
            }
            String fileName = path + "/" + name + Table_Abstract.FileSuffix;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return null;
            }
            ((Table_Abstract)table).readBinary(fileName);
            table.saveToPath(path);
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void saveBinary(String fileName) throws Exception {
        block6: {
            try {
                RandomAccessFile writer = new RandomAccessFile(fileName, "rw");
                int magic = 1009455;
                int version = 1001;
                writer.writeInt(magic);
                writer.writeInt(version);
                if (version == 1000) {
                    writer.writeUTF(this.m_name);
                    writer.writeInt(this.m_rowCount);
                    writer.writeInt(this.m_columns.size());
                    for (Column_Abstract column : this.m_columns) {
                        writer.writeUTF(column.getClass().getName());
                        column.save(writer);
                    }
                    this.m_bModifiedSinceLastSave = false;
                    break block6;
                }
                if (version == 1001) {
                    writer.writeUTF(this.m_name);
                    writer.writeInt(this.m_rowCount);
                    writer.writeInt(this.m_columns.size());
                    for (Column_Abstract column : this.m_columns) {
                        writer.writeUTF(column.uniqueID());
                        column.save(writer);
                    }
                    this.m_bModifiedSinceLastSave = false;
                    break block6;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    protected Class loadClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void readBinary(String fileName) throws Exception {
        block7: {
            try {
                this.m_bModifiedSinceLastSave = false;
                this.m_columns.clear();
                RandomAccessFile reader = new RandomAccessFile(fileName, "r");
                int magic = reader.readInt();
                if (magic != 1009455) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    this.m_rowCount = reader.readInt();
                    int columnCount = reader.readInt();
                    for (int n = 0; n < columnCount; ++n) {
                        String className = reader.readUTF();
                        Column_Abstract column = Column_Abstract.getColumnFromClassname(className);
                        if (column == null) continue;
                        column.read(reader);
                        this.m_columns.add(column);
                    }
                    break block7;
                }
                if (version == 1001) {
                    this.m_name = reader.readUTF();
                    this.m_rowCount = reader.readInt();
                    int columnCount = reader.readInt();
                    for (int n = 0; n < columnCount; ++n) {
                        String uniqueID = reader.readUTF();
                        Column_Abstract column = Column_Abstract.getColumnFromID(uniqueID);
                        if (column == null) continue;
                        column.read(reader);
                        this.m_columns.add(column);
                    }
                    break block7;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public HashMap_Integer createMapID() throws Exception {
        try {
            String colNameID = this.m_name + "ID";
            if (!this.column_exists(colNameID)) {
                throw new Exception("Must have ID column");
            }
            int index = this.column_indexOfColumn(colNameID);
            HashMap_Integer map = new HashMap_Integer();
            for (int n = 0; n < this.row_count(); ++n) {
                int id = this.getInt(n, index);
                if (map.containsKey(id)) {
                    throw new Exception("ID not unique");
                }
                map.put(id, n);
            }
            return map;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public HashMap_Integer createMapTwoColumn(String columnKey, String columnValue) throws Exception {
        if (!this.column_exists(columnKey)) {
            throw new Exception("Key column does not exist: " + columnKey);
        }
        if (!this.column_exists(columnValue)) {
            throw new Exception("Value column does not exists: " + columnValue);
        }
        int indexKey = this.column_indexOfColumn(columnKey);
        int indexValue = this.column_indexOfColumn(columnValue);
        HashMap_Integer map = new HashMap_Integer();
        for (int n = 0; n < this.row_count(); ++n) {
            int key = this.getInt(n, indexKey);
            int value = this.getInt(n, indexValue);
            if (map.containsKey(key)) {
                throw new Exception("Key not unique");
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public String name() throws Exception {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
        this.m_bModifiedSinceLastSave = true;
    }

    @Override
    public int traceHeader_getIndex(int col) throws Exception {
        try {
            return this.m_columns.get(col).traceHeader_getIndex();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void traceHeader_setIndex(int col, int headerIndex) throws Exception {
        try {
            this.m_columns.get(col).traceHeader_setIndex(headerIndex);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putBool(int row, int col, boolean value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putBool(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized boolean getBool(int row, int col) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getBool(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putInt(int row, int col, int value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putInt(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized int getInt(int row, int col) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getInt(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putLong(int row, int col, long value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putLong(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized long getLong(int row, int col) throws Exception {
        try {
            return this.m_columns.get(col).getLong(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putFloat(int row, int col, float value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putFloat(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized float getFloat(int row, int col) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getFloat(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putDouble(int row, int col, double value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putDouble(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized double getDouble(int row, int col) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getDouble(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void putString(int row, int col, String value) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            this.m_bModifiedSinceLastSave = true;
            this.m_columns.get(col).putString(row, value);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized String getString(int row, int col, int numDecimals) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getString(row, numDecimals);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized String getString(int row, int col) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            return this.m_columns.get(col).getString(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void row_delete(int row) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                return;
            }
            for (Column_Abstract col : this.m_columns) {
                try {
                    col.remove(row);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            --this.m_rowCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void row_clearRowValues(int row) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("Bad row number");
            }
            for (int col = 0; col < this.column_count(); ++col) {
                this.putInt(row, col, -9999);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void moveColumnsToUnusedStorage() {
        try {
            this.m_columns_Unused.clear();
            for (Column_Abstract col : this.m_columns) {
                this.m_columns_Unused.add(col);
            }
            this.m_columns.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void deleteColumnsInUnusedStorage() {
        try {
            this.m_columns_Unused.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public synchronized void column_setToValue(int index, double value) throws Exception {
        try {
            for (int n = 0; n < this.row_count(); ++n) {
                this.putDouble(n, index, value);
            }
            this.m_bModifiedSinceLastSave = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void column_removeAll() throws Exception {
        try {
            this.m_columns.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public synchronized void column_range(String columnName, Range_Double range) throws Exception {
        try {
            if (!this.column_exists(columnName)) {
                throw new Exception("Column does not exist");
            }
            int index = this.column_indexOfColumn(columnName);
            if (this.column_exists("Killed")) {
                int indexKilled = this.column_indexOfColumn("Killed");
                for (int n = 0; n < this.row_count(); ++n) {
                    boolean killed = this.getBool(n, indexKilled);
                    if (killed) continue;
                    double v = this.getDouble(n, index);
                    range.expandRange(v);
                }
                return;
            }
            for (int n = 0; n < this.row_count(); ++n) {
                double v = this.getDouble(n, index);
                range.expandRange(v);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void column_copy_double(String fromCol, String toCol) throws Exception {
        try {
            int indexFrom = this.column_indexOfColumn(fromCol);
            int indexTo = this.column_append(toCol, DataType.Double);
            for (int r = 0; r < this.row_count(); ++r) {
                this.putDouble(r, indexTo, this.getDouble(r, indexFrom));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized int column_count() {
        try {
            return this.m_columns.size();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public synchronized boolean column_exists(String columnName) throws Exception {
        try {
            for (Column_Abstract column : this.m_columns) {
                if (!column.name().equalsIgnoreCase(columnName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized int column_append(String columnName, DataType type) throws Exception {
        try {
            Column_Abstract column;
            block14: {
                block13: {
                    if (this.column_exists(columnName)) {
                        return this.column_indexOfColumn(columnName);
                    }
                    for (Column_Abstract col : this.m_columns_Unused) {
                        if (!columnName.equalsIgnoreCase(col.name()) || col.type() != type) continue;
                        this.m_columns.add(col);
                        this.m_columns_Unused.remove(col);
                        return this.m_columns.size() - 1;
                    }
                    column = null;
                    if (type == DataType.Short) break block13;
                    if (type != DataType.Int) break block14;
                }
                column = new Column_Int(columnName);
            }
            if (type == DataType.Float) {
                column = new Column_Float(columnName);
            }
            if (type == DataType.Double) {
                column = new Column_Double(columnName);
            }
            if (type == DataType.Bool) {
                column = new Column_Bool(columnName);
            }
            if (type == DataType.Long) {
                column = new Column_Long(columnName);
            }
            if (type == DataType.Text) {
                column = new Column_Text(columnName);
            }
            if (column == null) {
                throw new Exception("Unhandled type");
            }
            this.m_columns.add(column);
            this.m_bModifiedSinceLastSave = true;
            return this.m_columns.size() - 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized ArrayList<String> column_listOfNames() throws Exception {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Column_Abstract column : this.m_columns) {
                list.add(column.name());
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized String column_name(int index) throws Exception {
        try {
            return this.m_columns.get(index).name();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized DataType column_type(int index) throws Exception {
        try {
            return this.m_columns.get(index).type();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized int column_indexOfColumn(String columnName) throws Exception {
        try {
            for (int n = 0; n < this.m_columns.size(); ++n) {
                String sTmpName = this.m_columns.get(n).name();
                if (!sTmpName.equalsIgnoreCase(columnName)) continue;
                return n;
            }
            String sTable = this.m_name;
            if (sTable == null) {
                sTable = "";
            }
            throw new Exception("Column name not found : " + columnName + " for table " + sTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void row_countset(int count) throws Exception {
        try {
            if (this.column_count() > 0) {
                throw new Exception("Column count must be zero");
            }
            this.m_rowCount = count;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized int row_count() {
        try {
            return this.m_rowCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public synchronized int row_increment() throws Exception {
        try {
            ++this.m_rowCount;
            this.m_bModifiedSinceLastSave = true;
            return this.m_rowCount - 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public synchronized void row_clear(boolean bDeleteData) throws Exception {
        try {
            this.m_rowCount = 0;
            this.m_bModifiedSinceLastSave = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

