/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;

public class HistoryData
implements Serializable {
    protected ArrayList<String> m_list = new ArrayList();
    protected long m_startTime = System.currentTimeMillis();

    public List<String> getHistoryAsList() {
        return this.m_list;
    }

    public long getStartTimeInMS() {
        return this.m_startTime;
    }

    public void resetStartTime() {
        this.m_startTime = System.currentTimeMillis();
    }

    public void fillDefaultListModel(DefaultListModel<String> model) {
        try {
            model.clear();
            for (String s : this.m_list) {
                model.addElement(s);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add(String s) {
        try {
            this.m_list.add(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithTimeNoSpace(String s) {
        try {
            Date date = new Date();
            String dateCreated = date.toString();
            this.m_list.add(dateCreated + "    " + s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithElapsedTimeNoSpace(String s) {
        try {
            long time = System.currentTimeMillis() - this.m_startTime;
            String ts = Tools_Strings.runTimeMessage((int)(time / 1000L));
            this.m_list.add(ts + " elapsed:    " + s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithElapsedTime(String s) {
        try {
            long time = System.currentTimeMillis() - this.m_startTime;
            String ts = Tools_Strings.runTimeMessage((int)(time / 1000L));
            String line = ts + " elapsed:    " + s;
            this.m_list.add("   ");
            this.m_list.add(line);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithTime(String s) {
        try {
            Date date = new Date();
            String dateCreated = date.toString();
            String line = dateCreated + "    " + s;
            this.m_list.add("   ");
            this.m_list.add(line);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

