/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultListModel;

public class History {
    protected String m_fileName;
    protected ArrayList<String> m_list = new ArrayList();
    protected long m_startTime = System.currentTimeMillis();

    public void resetStartTime() {
        this.m_startTime = System.currentTimeMillis();
    }

    public History(String fileName) {
        try {
            this.m_fileName = fileName;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(this.m_fileName));
            String line = br.readLine();
            while (line != null) {
                this.m_list.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void fillDefaultListModel(DefaultListModel<String> model) {
        try {
            model.clear();
            for (String s : this.m_list) {
                model.addElement(s);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void add(String s) {
        try {
            this.m_list.add(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithTimeNoSpace(String s) {
        try {
            Date date = new Date();
            String dateCreated = date.toString();
            this.m_list.add(dateCreated + "    " + s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithElapsedTimeNoSpace(String s) {
        try {
            long time = System.currentTimeMillis() - this.m_startTime;
            String ts = Tools_Strings.runTimeMessage((int)(time / 1000L));
            this.m_list.add(ts + " elapsed:    " + s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithElapsedTime(String s) {
        try {
            long time = System.currentTimeMillis() - this.m_startTime;
            String ts = Tools_Strings.runTimeMessage((int)(time / 1000L));
            String line = ts + " elapsed:    " + s;
            this.m_list.add("   ");
            this.m_list.add(line);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addWithTime(String s) {
        try {
            Date date = new Date();
            String dateCreated = date.toString();
            String line = dateCreated + "    " + s;
            this.m_list.add("   ");
            this.m_list.add(line);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_fileName));
            for (String s : this.m_list) {
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

