/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Column_FloatArray
extends Column_Abstract
implements Serializable {
    protected float[][] m_data = new float[100][];
    int m_arrayLength;

    public Column_FloatArray() {
    }

    @Override
    public String uniqueID() {
        return "Column_IntArray";
    }

    public Column_FloatArray(String name, int arrayLength) throws Exception {
        try {
            this.m_arrayLength = arrayLength;
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            this.m_data = new float[100][arrayLength];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Column_FloatArray(String name, int minLength, int arrayLength) throws Exception {
        try {
            this.m_arrayLength = arrayLength;
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            int len = Math.max(100, minLength + 100);
            this.m_data = new float[len][arrayLength];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void remove(int row) {
        try {
            for (int n = row; n < this.m_data.length - 1; ++n) {
                this.m_data[n] = this.m_data[n + 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void sort(int count) {
        try {
            count = Math.min(this.m_data.length, count);
            boolean swapMade = true;
            while (swapMade) {
                swapMade = false;
                for (int n = 0; n < count - 1; ++n) {
                    float[] v1 = this.m_data[n];
                    float[] fArray = this.m_data[n + 1];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void save(RandomAccessFile writer) throws Exception {
        try {
            writer.writeInt(92876464);
            writer.writeInt(1000);
            writer.writeUTF(this.m_name);
            writer.writeInt(this.m_data.length);
            writer.writeInt(this.m_arrayLength);
            int numBytes = 4 * this.m_data.length * this.m_arrayLength;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            for (int n = 0; n < this.m_data.length; ++n) {
                float[] rowData = this.m_data[n];
                for (int i = 0; i < this.m_arrayLength; ++i) {
                    buff.putFloat(this.m_data[n][i]);
                }
            }
            writer.write(buff.array(), 0, numBytes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void read(RandomAccessFile reader) throws Exception {
        block6: {
            try {
                int magic = reader.readInt();
                if (magic != 92876464) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    int len = reader.readInt();
                    this.m_arrayLength = reader.readInt();
                    this.m_data = new float[len][this.m_arrayLength];
                    int numBytes = 4 * len * this.m_arrayLength;
                    ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < this.m_data.length; ++n) {
                        for (int i = 0; i < this.m_arrayLength; ++i) {
                            this.m_data[n][i] = buff.getInt();
                        }
                    }
                    break block6;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public Column_Abstract createExactCopy() {
        try {
            Column_FloatArray col = new Column_FloatArray(this.m_name, this.m_data.length, this.m_arrayLength);
            for (int n = 0; n < this.m_data.length; ++n) {
                col.putFloatArray(n, this.m_data[n]);
            }
            col.clearModificationFlag();
            return col;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public DataType type() {
        return DataType.Int;
    }

    protected void resize(int row) throws Exception {
        try {
            int n;
            if (row < this.m_data.length) {
                return;
            }
            int newLength = row + this.m_data.length / 2;
            float[][] tempArray = new float[newLength][];
            for (n = 0; n < this.m_data.length; ++n) {
                tempArray[n] = Arrays.copyOf(this.m_data[n], this.m_arrayLength);
            }
            for (n = this.m_data.length; n < newLength; ++n) {
                tempArray[n] = new float[this.m_arrayLength];
                for (int j = 0; j < this.m_arrayLength; ++j) {
                    tempArray[n][j] = -999999.0f;
                }
            }
            this.m_data = null;
            this.m_data = tempArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putBool(int row, boolean value) throws Exception {
    }

    @Override
    public boolean getBool(int row) throws Exception {
        return false;
    }

    @Override
    public void putLong(int row, long value) throws Exception {
    }

    @Override
    public long getLong(int row) throws Exception {
        return 0L;
    }

    @Override
    public void putInt(int row, int value) throws Exception {
    }

    @Override
    public int getInt(int row) throws Exception {
        return 0;
    }

    @Override
    public void putFloat(int row, float value) throws Exception {
    }

    @Override
    public float getFloat(int row) throws Exception {
        return 0.0f;
    }

    @Override
    public void putDouble(int row, double value) throws Exception {
    }

    @Override
    public double getDouble(int row) throws Exception {
        return 0.0;
    }

    @Override
    public void putString(int row, String value) throws Exception {
    }

    @Override
    public String getString(int row, int numDecimals) throws Exception {
        return "";
    }

    @Override
    public String getString(int row) throws Exception {
        return "";
    }

    @Override
    public void putIntArray(int row, int[] iVals) {
    }

    @Override
    public int[] getIntArray(int row) {
        return null;
    }

    @Override
    public void putFloatArray(int row, float[] fVals) {
        if (row >= 0 && row < this.m_data.length && fVals.length == this.m_arrayLength) {
            System.arraycopy(fVals, 0, this.m_data[row], 0, this.m_arrayLength);
        }
    }

    @Override
    public float[] getFloatArray(int row) {
        if (row >= 0 && row < this.m_data.length) {
            return this.m_data[row];
        }
        return null;
    }

    public int getArrayLength() {
        return this.m_arrayLength;
    }
}

