/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Shared.ExceptionMonitor;

public class ArrayRenormalization {
    protected float[] m_inputWeight = null;
    protected float[] m_inputWeightSum = null;
    protected float[] m_temp1 = null;
    protected float[] m_temp2 = null;
    protected float[] m_temp3 = null;

    public void rms(float[] input) {
        try {
            if (input == null) {
                return;
            }
            if (input.length <= 3) {
                return;
            }
            float max = 0.0f;
            for (int n = 0; n < input.length; ++n) {
                max = Math.max(max, input[n]);
            }
            if (max < 1.0E-10f) {
                return;
            }
            float sumSq = 0.0f;
            for (int n = 0; n < input.length; ++n) {
                sumSq += input[n] * input[n];
            }
            float b = 1.0f / (float)Math.sqrt(sumSq /= (float)input.length);
            int n = 0;
            while (n < input.length) {
                int n2 = n++;
                input[n2] = input[n2] * b;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float computeNoiseLevel(float[] input, int totalWindowLength) {
        try {
            totalWindowLength = Math.max(totalWindowLength, 3);
            if (input == null) {
                return 0.0f;
            }
            if (input.length <= totalWindowLength) {
                return 0.0f;
            }
            float sum = 0.0f;
            for (int n = 0; n < totalWindowLength; ++n) {
                sum += Math.abs(input[n]);
            }
            float sumMin = sum;
            float sumMax = sum;
            for (int n = totalWindowLength; n < input.length; ++n) {
                sum -= Math.abs(input[n - totalWindowLength]);
                sumMin = Math.min(sumMin, sum += Math.abs(input[n]));
                sumMax = Math.max(sumMax, sum);
            }
            return sumMin / (sumMax + 1.0E-30f);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public void applyLogAmp(float[] input, double peakFraction, int totalWindowLength) {
        try {
            int n;
            int n2;
            peakFraction = Math.max(peakFraction, 0.01);
            peakFraction = Math.min(peakFraction, 0.99);
            double alpha = (peakFraction - 1.0) / (peakFraction - peakFraction * peakFraction);
            double beta = 1.0 - alpha;
            double coeff2 = 3.0 / (peakFraction * peakFraction * peakFraction);
            double coeff3 = 2.0 / (peakFraction * peakFraction * peakFraction * peakFraction);
            totalWindowLength = Math.max(totalWindowLength, 3);
            int halfLength = totalWindowLength / 2;
            totalWindowLength = 1 + 2 * halfLength;
            if (input == null) {
                return;
            }
            int inputLength = input.length;
            if (inputLength <= totalWindowLength) {
                return;
            }
            int minInternalLength = input.length + 2 * halfLength;
            if (this.m_inputWeight == null) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            if (this.m_inputWeight.length < minInternalLength) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            int edgeIndex = inputLength + halfLength;
            for (n2 = 0; n2 < halfLength; ++n2) {
                this.m_inputWeight[n2] = 0.0f;
                this.m_inputWeight[n2 + edgeIndex] = 0.0f;
            }
            for (n2 = 0; n2 < inputLength; ++n2) {
                this.m_inputWeight[n2 + halfLength] = Math.abs(input[n2]);
            }
            float weightSum = 0.0f;
            float weightMax = 0.0f;
            for (n = 0; n < halfLength; ++n) {
                weightSum += this.m_inputWeight[n + halfLength];
            }
            for (n = halfLength; n < edgeIndex; ++n) {
                weightSum -= this.m_inputWeight[n - halfLength];
                weightMax = Math.max(weightMax, weightSum += this.m_inputWeight[n + halfLength]);
                this.m_inputWeightSum[n] = weightSum;
            }
            if (weightMax < 1.0E-9f) {
                return;
            }
            for (n = 0; n < inputLength; ++n) {
                double ratio = this.m_inputWeightSum[n + halfLength] / weightMax;
                double scalar = 1.0;
                scalar = ratio >= peakFraction ? alpha * ratio + beta : coeff2 * ratio * ratio - coeff3 * ratio * ratio * ratio;
                input[n] = input[n] * (float)scalar;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void applyPrePost(float[] input, float bias, int totalWindowLength, boolean applyToInput, boolean nonlinear) {
        try {
            int n;
            totalWindowLength = Math.max(totalWindowLength, 3);
            if (input == null) {
                return;
            }
            int inputLength = input.length;
            if (inputLength <= totalWindowLength) {
                return;
            }
            int minInternalLength = input.length + 5 + totalWindowLength;
            if (this.m_temp1 == null) {
                this.m_temp1 = new float[minInternalLength + 100];
                this.m_temp2 = new float[minInternalLength + 100];
                this.m_temp3 = new float[minInternalLength + 100];
            }
            if (this.m_temp1.length < minInternalLength) {
                this.m_temp1 = new float[minInternalLength + 100];
                this.m_temp2 = new float[minInternalLength + 100];
                this.m_temp3 = new float[minInternalLength + 100];
            }
            float average = 0.0f;
            for (int n2 = 0; n2 < inputLength; ++n2) {
                average += Math.abs(input[n2]);
            }
            if (average < 1.0E-6f) {
                return;
            }
            float shift = bias * average / (float)inputLength;
            if (shift < 1.0E-6f) {
                return;
            }
            for (n = 0; n < inputLength; ++n) {
                float s = shift + Math.abs(input[n]);
                this.m_temp1[n] = nonlinear ? s * s : s;
            }
            for (int iter = 1; iter <= 2; ++iter) {
                int n3;
                for (n3 = 0; n3 < inputLength; ++n3) {
                    this.m_temp2[n3] = this.m_temp1[n3];
                }
                for (n3 = 1; n3 < inputLength - 1; ++n3) {
                    this.m_temp1[n3] = 0.25f * this.m_temp2[n3 - 1] + 0.5f * this.m_temp2[n3] + 0.25f * this.m_temp2[n3 + 1];
                }
            }
            for (n = 0; n < inputLength; ++n) {
                float sum = 0.0f;
                if (n == 100) {
                    sum = 1.0E-4f;
                }
                for (int s = n - totalWindowLength; s < n; ++s) {
                    if (s < 0 || s >= inputLength) continue;
                    sum += this.m_temp1[s];
                }
                this.m_temp2[n] = sum;
            }
            for (n = 0; n < totalWindowLength; ++n) {
                input[n] = 0.0f;
            }
            for (n = inputLength - totalWindowLength - 2; n < inputLength; ++n) {
                input[n] = 0.0f;
            }
            for (n = totalWindowLength; n < inputLength - totalWindowLength - 2; ++n) {
                float pre = this.m_temp2[n];
                float post = this.m_temp2[n + totalWindowLength + 1];
                float ratio = post / pre;
                if (n == 100) {
                    ratio *= 1.00001f;
                }
                if (applyToInput) {
                    int n4 = n;
                    input[n4] = input[n4] * ratio;
                    continue;
                }
                input[n] = ratio;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void applyAGC(float[] input, float percent, int totalWindowLength) {
        try {
            this.applyAGC(input, percent, totalWindowLength, AgcMethod.Center);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void applyAGC(float[] input, float percent, int totalWindowLength, AgcMethod method) {
        try {
            float cutoff = 0.01f * percent;
            cutoff = Math.max(0.0f, cutoff);
            cutoff = Math.min(1.0f, cutoff);
            totalWindowLength = Math.max(totalWindowLength, 3);
            int halfLength = totalWindowLength / 2;
            totalWindowLength = 1 + 2 * halfLength;
            if (input == null) {
                return;
            }
            int inputLength = input.length;
            if (inputLength <= totalWindowLength) {
                return;
            }
            int minInternalLength = input.length + 2 * halfLength;
            if (this.m_inputWeight == null) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            if (this.m_inputWeight.length < minInternalLength) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            if (AgcMethod.Bottom == method) {
                int n;
                float weightMax = 0.0f;
                float weightSum = 0.0f;
                for (int n2 = 0; n2 < inputLength; ++n2) {
                    this.m_inputWeight[n2] = Math.abs(input[n2]);
                    weightSum += this.m_inputWeight[n2];
                    if (n2 >= totalWindowLength) {
                        weightSum -= this.m_inputWeight[n2 - totalWindowLength];
                    }
                    this.m_inputWeightSum[n2] = weightSum;
                    weightMax = Math.max(weightMax, weightSum);
                }
                float minValidSum = weightMax * cutoff;
                for (n = 0; n < halfLength; ++n) {
                    input[n] = 0.0f;
                }
                for (n = halfLength; n < inputLength; ++n) {
                    input[n] = this.m_inputWeightSum[n] > minValidSum ? input[n] * weightMax / this.m_inputWeightSum[n] : 0.0f;
                }
                return;
            }
            if (AgcMethod.Center == method) {
                int n;
                int n3;
                int edgeIndex = inputLength + halfLength;
                for (n3 = 0; n3 < halfLength; ++n3) {
                    this.m_inputWeight[n3] = 0.0f;
                    this.m_inputWeight[n3 + edgeIndex] = 0.0f;
                }
                for (n3 = 0; n3 < inputLength; ++n3) {
                    this.m_inputWeight[n3 + halfLength] = Math.abs(input[n3]);
                }
                float weightSum = 0.0f;
                float weightMax = 0.0f;
                for (n = 0; n < halfLength; ++n) {
                    weightSum += this.m_inputWeight[n + halfLength];
                }
                for (n = halfLength; n < edgeIndex; ++n) {
                    weightSum -= this.m_inputWeight[n - halfLength];
                    weightMax = Math.max(weightMax, weightSum += this.m_inputWeight[n + halfLength]);
                    this.m_inputWeightSum[n] = weightSum;
                }
                if (weightMax < 1.0E-9f) {
                    return;
                }
                float minValidSum = weightMax * cutoff;
                for (int n4 = 0; n4 < inputLength; ++n4) {
                    input[n4] = this.m_inputWeightSum[n4 + halfLength] > minValidSum ? input[n4] * weightMax / this.m_inputWeightSum[n4 + halfLength] : 0.0f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void applyAGC(float[] input, int totalWindowLength) {
        try {
            int n;
            int n2;
            totalWindowLength = Math.max(totalWindowLength, 3);
            int halfLength = totalWindowLength / 2;
            totalWindowLength = 1 + 2 * halfLength;
            if (input == null) {
                return;
            }
            int inputLength = input.length;
            if (inputLength <= totalWindowLength) {
                return;
            }
            int minInternalLength = input.length + 2 * halfLength;
            if (this.m_inputWeight == null) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            if (this.m_inputWeight.length < minInternalLength) {
                this.m_inputWeight = new float[minInternalLength + 100];
                this.m_inputWeightSum = new float[minInternalLength + 100];
            }
            int edgeIndex = inputLength + halfLength;
            for (n2 = 0; n2 < halfLength; ++n2) {
                this.m_inputWeight[n2] = 0.0f;
                this.m_inputWeight[n2 + edgeIndex] = 0.0f;
            }
            for (n2 = 0; n2 < inputLength; ++n2) {
                this.m_inputWeight[n2 + halfLength] = Math.abs(input[n2]);
            }
            float weightSum = 0.0f;
            float weightMax = 0.0f;
            for (n = 0; n < halfLength; ++n) {
                weightSum += this.m_inputWeight[n + halfLength];
            }
            for (n = halfLength; n < edgeIndex; ++n) {
                weightSum -= this.m_inputWeight[n - halfLength];
                weightMax = Math.max(weightMax, weightSum += this.m_inputWeight[n + halfLength]);
                this.m_inputWeightSum[n] = weightSum;
            }
            if (weightMax < 1.0E-9f) {
                return;
            }
            for (n = 0; n < inputLength; ++n) {
                if (!(this.m_inputWeightSum[n + halfLength] > 0.0f)) continue;
                input[n] = input[n] * weightMax / this.m_inputWeightSum[n + halfLength];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static enum AgcMethod {
        Center,
        Bottom;

    }
}

