/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Application;

import com.PecosCore.Application.InfoCookie;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class RegistrationDlg
extends JPanel {
    private InfoCookie m_ic = null;
    private final Color BAD_INPUT_COLOR = Color.pink;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;
    private JButton m_btnCancel;
    private JButton m_btnEULA;
    private JButton m_btnOK;
    private JCheckBox m_chkUseFlatironsRefraction;
    private JTextField m_txtAddress1;
    private JTextField m_txtAddress2;
    private JTextField m_txtAddress3;
    private JTextField m_txtCompanyName;
    private JTextField m_txtContactName;
    private JTextField m_txtEmailAddress;
    private JTextField m_txtPhone;

    public RegistrationDlg(InfoCookie ic) {
        this.initComponents();
        this.m_ic = ic;
    }

    private void initComponents() {
        this.m_btnCancel = new JButton();
        this.m_btnOK = new JButton();
        this.jLabel17 = new JLabel();
        this.m_txtContactName = new JTextField();
        this.jLabel18 = new JLabel();
        this.m_txtEmailAddress = new JTextField();
        this.jLabel19 = new JLabel();
        this.m_txtPhone = new JTextField();
        this.jLabel20 = new JLabel();
        this.m_txtCompanyName = new JTextField();
        this.m_txtAddress1 = new JTextField();
        this.jLabel21 = new JLabel();
        this.m_txtAddress2 = new JTextField();
        this.m_txtAddress3 = new JTextField();
        this.jLabel22 = new JLabel();
        this.m_chkUseFlatironsRefraction = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jLabel1 = new JLabel();
        this.m_btnEULA = new JButton();
        this.m_btnCancel.setText("Cancel");
        this.m_btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RegistrationDlg.this.m_btnCancelMouseClicked(evt);
            }
        });
        this.m_btnOK.setText("OK");
        this.m_btnOK.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RegistrationDlg.this.m_btnOKMouseClicked(evt);
            }
        });
        this.jLabel17.setText("Contact Name*");
        this.jLabel18.setText("Email Address*");
        this.jLabel19.setText("Phone Number*");
        this.jLabel20.setText("Company Name*");
        this.jLabel21.setText("Company Address*");
        this.jLabel22.setText("Do you currently use any products from Xtreme Geo, LLC ?");
        this.m_chkUseFlatironsRefraction.setText("Flatirons Refraction Statics");
        this.jTextPane1.setText("Please take a moment to tell us about yourself before connecting to our public license server.  Any fields marked with an (*) are required.  Please fix fields marked in red before submitting.");
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jLabel1.setForeground(new Color(250, 25, 14));
        this.jLabel1.setText("BY CLICKING OK, YOU AGREE TO OUR END USER LICENSE AGREEMENT (EULA)");
        this.m_btnEULA.setText("View EULA");
        this.m_btnEULA.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RegistrationDlg.this.m_btnEULAMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addComponent(this.jLabel22).addComponent(this.m_chkUseFlatironsRefraction)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabel1, -1, 533, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.m_btnEULA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_btnCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.m_txtContactName, GroupLayout.Alignment.LEADING).addComponent(this.jLabel18, GroupLayout.Alignment.LEADING).addComponent(this.m_txtEmailAddress, GroupLayout.Alignment.LEADING, -2, 243, -2)).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel19).addComponent(this.jLabel20)).addGap(134, 134, 134)).addComponent(this.m_txtCompanyName).addComponent(this.m_txtPhone, GroupLayout.Alignment.TRAILING))).addComponent(this.m_txtAddress1).addComponent(this.m_txtAddress2).addComponent(this.m_txtAddress3, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtContactName, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtCompanyName, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtEmailAddress, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtPhone, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtAddress1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtAddress2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtAddress3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_chkUseFlatironsRefraction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -1, 24, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_btnCancel).addComponent(this.m_btnOK).addComponent(this.m_btnEULA)).addContainerGap()));
    }

    private void m_btnCancelMouseClicked(MouseEvent evt) {
        System.exit(2);
    }

    private void m_btnOKMouseClicked(MouseEvent evt) {
        try {
            Boolean valid = this.checkFieldStatus();
            if (valid.booleanValue()) {
                this.saveToCookie();
                Window w = SwingUtilities.getWindowAncestor(this);
                w.setVisible(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void m_btnEULAMouseClicked(MouseEvent evt) {
        if (Desktop.isDesktopSupported()) {
            try {
                File eula = Tools_FileSystem.createTempFileFromResource("XTG_EULA_2015.pdf");
                if (eula != null) {
                    Desktop.getDesktop().open(eula);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    private void saveToCookie() throws Exception {
        this.m_ic.Address = this.m_txtAddress1.getText() + ", " + this.m_txtAddress2.getText() + ", " + this.m_txtAddress3.getText();
        this.m_ic.CompanyName = this.m_txtCompanyName.getText();
        this.m_ic.ContactName = this.m_txtContactName.getText();
        this.m_ic.EmailAddress = this.m_txtEmailAddress.getText();
        this.m_ic.Phone = this.m_txtPhone.getText();
        this.m_ic.UseFlatirons = this.m_chkUseFlatironsRefraction.isSelected();
    }

    private Boolean checkFieldStatus() {
        if (this.m_txtCompanyName.getText().isEmpty() || this.m_txtCompanyName.getText().length() < 2) {
            this.setFieldStatus(this.m_txtCompanyName, false);
        } else {
            this.setFieldStatus(this.m_txtCompanyName, true);
        }
        if (this.m_txtContactName.getText().isEmpty() || this.m_txtContactName.getText().length() < 2) {
            this.setFieldStatus(this.m_txtContactName, false);
        } else {
            this.setFieldStatus(this.m_txtContactName, true);
        }
        if (this.m_txtEmailAddress.getText().isEmpty() || this.m_txtEmailAddress.getText().length() < 5 || !this.m_txtEmailAddress.getText().contains("@") || !this.m_txtEmailAddress.getText().contains(".")) {
            this.setFieldStatus(this.m_txtEmailAddress, false);
        } else {
            this.setFieldStatus(this.m_txtEmailAddress, true);
        }
        Object s = this.m_txtPhone.getText().replaceAll("[A-Za-z *#()-]+", "");
        if (((String)s).isEmpty() || ((String)s).length() < 6 || !((String)s).matches("[0-9]+")) {
            this.setFieldStatus(this.m_txtPhone, false);
        } else {
            this.setFieldStatus(this.m_txtPhone, true);
        }
        s = this.m_txtAddress1.getText() + this.m_txtAddress2.getText() + this.m_txtAddress3.getText();
        if (((String)s).isEmpty() || ((String)s).length() < 16 || !((String)s).matches(".*[0-9].*")) {
            this.setFieldStatus(this.m_txtAddress1, false);
            this.setFieldStatus(this.m_txtAddress2, false);
            this.setFieldStatus(this.m_txtAddress3, false);
        } else {
            this.setFieldStatus(this.m_txtAddress1, true);
            this.setFieldStatus(this.m_txtAddress2, true);
            this.setFieldStatus(this.m_txtAddress3, true);
        }
        if (this.m_txtCompanyName.getBackground() == this.BAD_INPUT_COLOR || this.m_txtContactName.getBackground() == this.BAD_INPUT_COLOR || this.m_txtEmailAddress.getBackground() == this.BAD_INPUT_COLOR || this.m_txtPhone.getBackground() == this.BAD_INPUT_COLOR || this.m_txtAddress1.getBackground() == this.BAD_INPUT_COLOR) {
            return false;
        }
        return true;
    }

    private void setFieldStatus(JTextField txtf, Boolean valid) {
        if (txtf == null) {
            return;
        }
        Color col = Color.WHITE;
        if (!valid.booleanValue()) {
            col = this.BAD_INPUT_COLOR;
        }
        txtf.setBackground(col);
    }
}

