/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Application;

import com.PecosCore.Application.Environment;
import com.PecosCore.Application.RegistrationDlg;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class InfoCookie {
    public String CompanyName = "";
    public String ContactName = "";
    public String EmailAddress = "";
    public String Phone = "";
    public String Address = "";
    public String CompanyType = "Processing";
    public Boolean UseFlatirons = false;
    public ArrayList<Date> Usage = new ArrayList();
    private final String CookieLocation;
    private final String CookieLocation_Backup;
    private static final Charset COOKIE_ENCODING = StandardCharsets.UTF_8;
    private Boolean valid = false;

    public InfoCookie() {
        SharedApplicationData sd = SharedApplicationData.singleton();
        this.CookieLocation = sd.homeDirectory() + "/.infoc.pecos";
        this.CookieLocation_Backup = this.CookieLocation + ".bak";
        this.getInternalInfo();
        if (this.Usage.isEmpty()) {
            this.appendCurrentDate();
        }
    }

    public final void getInternalInfo() {
        this.read();
    }

    public void fillWithJunk() {
        this.CompanyName = "sassdsddd";
        this.ContactName = "asdgsfdag";
        this.EmailAddress = "sad@dfg.com";
        this.Phone = "425566";
        this.Address = "dfg";
        this.UseFlatirons = false;
    }

    public String toString() {
        Object s = "";
        try {
            s = (String)s + "\n";
            s = (String)s + this.CompanyName + "\n";
            s = (String)s + this.ContactName + "\n";
            s = (String)s + this.EmailAddress + "\n";
            s = (String)s + this.Phone + "\n";
            s = (String)s + "\n";
            s = (String)s + this.Address + "\n";
            s = (String)s + this.CompanyType + "\n";
            s = (String)s + this.UseFlatirons.toString() + "\n";
            s = (String)s + "\n";
            s = (String)s + Environment.EXT_IP_ADDRESS + "\n";
            s = (String)s + Environment.LOCAL_IP_ADDRESS + "\n";
            s = (String)s + this.getEncryptedMAC() + "\n";
            s = (String)s + String.valueOf((Object)Environment.OS_TYPE) + "\n";
            s = (String)s + Environment.LOCAL_USER_NAME + "\n";
            s = (String)s + Environment.LOCAL_HOST_NAME + "\n";
            s = (String)s + "\n";
            for (Date Usage1 : this.Usage) {
                s = (String)s + Usage1.toString() + "\n";
            }
            s = (String)s + "\n";
            s = (String)s + "\n";
            s = (String)s + "\n";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        return s;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(OutputStream os) {
        try {
            if (os != null) {
                os.write(this.toString().getBytes());
            }
        }
        catch (IOException ioe) {
            ExceptionMonitor.add(ioe);
        }
    }

    public void save() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.CookieLocation);
            this.print(fos);
            fos.close();
            fos = new FileOutputStream(this.CookieLocation_Backup);
            this.print(fos);
            fos.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void read() {
        Path path = Paths.get(this.CookieLocation, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            this.valid = false;
            return;
        }
        BufferedReader br = null;
        this.valid = true;
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public Boolean isValid() {
        return this.valid;
    }

    private Boolean testMAC() {
        return this.testMAC(null);
    }

    private Boolean testMAC(String smac) {
        String s = "";
        try {
            s = smac == null ? Environment.LOCAL_MAC_ADDRESS : smac;
            s = s.replaceAll(":", "");
            if (!s.equalsIgnoreCase(Environment.LOCAL_MAC_ADDRESS.replaceAll(":", ""))) {
                throw new Exception("Saved MAC Address does not match system");
            }
            if (s == null) {
                throw new Exception("MAC address null");
            }
            if (s.length() != 12) {
                throw new Exception("Malformed MAC address: " + s);
            }
            if (!s.matches("^[0-9a-fA-F]+$")) {
                throw new Exception("MAC Address is not hex format: " + s);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    private String decryptMAC(long dmac) {
        String s = "";
        try {
            return Long.toHexString(dmac /= 6L);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return s;
        }
    }

    private long getEncryptedMAC() {
        long base10s = 0L;
        try {
            if (!this.testMAC().booleanValue()) {
                return 0L;
            }
            String s = Environment.LOCAL_MAC_ADDRESS;
            s = s.replaceAll(":", "");
            base10s = Long.parseLong(s, 16);
            base10s *= 6L;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        return base10s;
    }

    public void deleteCookieFile() {
        Path path = Paths.get(this.CookieLocation, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
        this.valid = false;
    }

    private void appendCurrentDate() {
        Date rightNow = new Date();
        this.Usage.add(rightNow);
    }

    public void showRegDlg() {
        try {
            RegistrationDlg rd = new RegistrationDlg(this);
            JDialog dlg = new JDialog((Frame)new JFrame(), true);
            dlg.add(rd);
            dlg.setTitle("Please enter some information to register");
            dlg.pack();
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public long getMAC() {
        return this.getEncryptedMAC();
    }

    public String getCookieLocation() {
        return this.CookieLocation;
    }

    public String getCookieFileName() {
        String s = this.getMAC() + this.CookieLocation.substring(this.CookieLocation.lastIndexOf("/") + 1);
        return s;
    }
}

