/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.JDBC.ImportColumnDelimitedTableDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class VolumeWellTopManagerWidget
extends LinearLayoutWidget
implements ListSelectionListener,
ActionListener,
GenericObjectListener.Listener,
ISaveableFrame {
    protected JButton m_importCSVButton;
    protected JTable m_selectedTable = new JTable();
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboX = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboY = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboZ = new ComboStringListWrapper();
    protected JButton m_exportButton = new JButton("Export");
    protected double[] m_tempX;
    protected double[] m_tempY;
    protected double[] m_tempZ;
    protected int m_tempCount;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Volume.VolumeWellTopManagerWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Well tops";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Well tops";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public VolumeWellTopManagerWidget() {
        super(LinearLayoutWidget.Direction.Horizontal, 3, null);
        try {
            LinearLayoutWidget left = this.createVertical(3, null, 0);
            LinearLayoutWidget sub = left.createVertical(0, "Create new well top table", 0);
            this.m_importCSVButton = sub.createButton("Import CSV file", this, 10);
            sub = left.createVertical(0, "Select active well top table", 0);
            sub.addComponent(this.m_combo, 2);
            this.m_combo.listener().addListener(this);
            GridLayoutWidget grid = left.createGridLayoutWidget(0, "Export to shot/receiver", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("X Axis"), this.m_comboX);
            grid.addSimple(row++, new JLabel("Y Axis"), this.m_comboY);
            grid.addSimple(row++, new JLabel("Value"), this.m_comboZ);
            grid.addSimple(row++, new JLabel(" "), this.m_exportButton);
            this.m_exportButton.addActionListener(this);
            left.addStretch(10);
            this.m_selectedTable.setGridColor(Color.LIGHT_GRAY);
            this.m_selectedTable.setShowGrid(true);
            this.addComponent(new JScrollPane(this.m_selectedTable), 10);
            this.m_selectedTable.getSelectionModel().addListSelectionListener(this);
            this.m_selectedTable.getSelectionModel().setSelectionMode(0);
            this.reloadTableCombo();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection getWellTopDatabase() {
        return VolumeProject.singleton().getWellTopDatabase();
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.reloadSelected();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadSelected() {
        try {
            this.m_selectedTable.setModel(new DefaultTableModel());
            String name = this.m_combo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            String sql = "SELECT * FROM " + name;
            Table_Abstract table = this.getWellTopDatabase().extractTableDataUsingQuery(name, sql, Pecos.MaxQueryRowCount);
            this.m_selectedTable.setModel(new Table_SimpleModel(table));
            ArrayList<String> cols = this.getWellTopDatabase().listOfColumnNames(name);
            this.m_comboX.setStringArray(cols);
            this.m_comboY.setStringArray(cols);
            this.m_comboZ.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadTableCombo() {
        try {
            ArrayList<String> table = this.getWellTopDatabase().getTableNames();
            this.m_combo.setStringArray(table);
            this.reloadSelected();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    protected void export() {
        try {
            String name = this.m_combo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            String sql = "SELECT * FROM " + name;
            Table_Abstract wellTable = this.getWellTopDatabase().extractTableDataUsingQuery(name, sql, Pecos.MaxQueryRowCount);
            if (wellTable.row_count() < 1) {
                return;
            }
            this.m_tempCount = 0;
            this.m_tempX = new double[wellTable.row_count()];
            this.m_tempY = new double[wellTable.row_count()];
            this.m_tempZ = new double[wellTable.row_count()];
            int indexX = wellTable.column_indexOfColumn(this.m_comboX.getSelectedString());
            int indexY = wellTable.column_indexOfColumn(this.m_comboY.getSelectedString());
            int indexZ = wellTable.column_indexOfColumn(this.m_comboZ.getSelectedString());
            for (int r = 0; r < wellTable.row_count(); ++r) {
                String sx = wellTable.getString(r, indexX);
                String sy = wellTable.getString(r, indexY);
                String sz = wellTable.getString(r, indexZ);
                if (!Tools_Strings.canConvertToDouble(sx) || !Tools_Strings.canConvertToDouble(sy) || !Tools_Strings.canConvertToDouble(sz)) continue;
                this.m_tempX[this.m_tempCount] = Double.parseDouble(sx);
                this.m_tempY[this.m_tempCount] = Double.parseDouble(sy);
                this.m_tempZ[this.m_tempCount] = Double.parseDouble(sz);
                ++this.m_tempCount;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.export(project.shotTable());
            this.export(project.receiverTable());
            project.geometryDatabase().writeColumnContentsToDatabase(project.shotTable(), this.m_comboZ.getSelectedString());
            project.geometryDatabase().writeColumnContentsToDatabase(project.receiverTable(), this.m_comboZ.getSelectedString());
            project.reloadAllData();
            this.m_tempX = null;
            this.m_tempY = null;
            this.m_tempZ = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void export(Table_Abstract geomTable) {
        try {
            int colX = geomTable.column_indexOfColumn("Easting");
            int colY = geomTable.column_indexOfColumn("Northing");
            int colZ = geomTable.column_append(this.m_comboZ.getSelectedString(), DataType.Double);
            for (int row = 0; row < geomTable.row_count(); ++row) {
                double sum1 = 0.0;
                double sum2 = 1.0E-60;
                double x = geomTable.getDouble(row, colX);
                double y = geomTable.getDouble(row, colY);
                for (int r = 0; r < this.m_tempCount; ++r) {
                    double dx = x - this.m_tempX[r];
                    double dy = y - this.m_tempY[r];
                    double w = 1000.0 / (1000.0 + dx * dx + dy * dy);
                    w *= w;
                    sum1 += w * this.m_tempZ[r];
                    sum2 += w;
                }
                geomTable.putDouble(row, colZ, sum1 / sum2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_exportButton) {
                this.export();
                return;
            }
            if (e.getSource() == this.m_importCSVButton) {
                ImportColumnDelimitedTableDialog dlg = new ImportColumnDelimitedTableDialog(null, "Import column-delimited table", this.getWellTopDatabase(), true);
                this.reloadTableCombo();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

