/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Stack;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.AxisGrid_Interpolator;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Well.Tools_WellTop;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VolumeStack_InterpolatedWellTopWidget
extends LinearLayoutWidget
implements ListSelectionListener,
ActionListener,
GenericObjectListener.Listener,
IParameterWidgetListener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_overlayCheck = new JCheckBox("Overlay interpolated well tops");
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper();
    protected JButton m_reloadTableButton = new JButton("Reload tables");
    protected ComboStringListWrapper m_xCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_yCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected SliderWidget m_timeSlider;
    protected SliderWidget m_velocitySlider;
    protected RadioPanel m_velMethod;
    protected JButton m_applyButton;
    protected Table_Abstract m_surfaceTable;
    protected String m_horizonName;
    protected AxisGrid_Interpolator m_axisGrid;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public VolumeStack_InterpolatedWellTopWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            String s = "<HTML>The well-top database tables are found by selecting the menu  item \"QC ==> View volumes\", then select the \"Well top tables\" tab page.</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            this.createGapLabel(12);
            this.addComponent(this.m_overlayCheck, 0);
            this.m_overlayCheck.addActionListener(this);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Select table and columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Table"), this.m_tableCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadTableButton);
            this.m_reloadTableButton.addActionListener(this);
            grid.addSimple(row++, new JLabel("Easting"), this.m_xCombo);
            grid.addSimple(row++, new JLabel("Northing"), this.m_yCombo);
            grid.addSimple(row++, new JLabel("Well top"), this.m_cCombo);
            this.m_tableCombo.listener().addListener(this);
            this.m_xCombo.listener().addListener(this);
            this.m_yCombo.listener().addListener(this);
            this.m_cCombo.listener().addListener(this);
            this.m_xCombo.setPreferredSelected("Easting");
            this.m_yCombo.setPreferredSelected("Northing");
            this.m_cCombo.setPreferredSelected("KCTYGRP");
            this.m_timeSlider = new SliderWidget(this, null, "Two-way travel time", 0, 500.0, 0.0, 4000.0);
            this.addComponent(this.m_timeSlider, 0);
            this.m_velMethod = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Velocity selection", "Use a constant velocity selected below", "Use velocity interpolated from stacking velocity field", "Treat the selected column as a time surface");
            this.m_velMethod.setSelectedIndex(1);
            this.addComponent(this.m_velMethod, 0);
            this.m_velMethod.listener().addListener(this);
            this.m_velocitySlider = new SliderWidget(this, null, "Interval velocity", 0, 10000.0, 100.0, 15000.0);
            this.addComponent(this.m_velocitySlider, 0);
            this.m_applyButton = this.createButton("Apply options", this, 0);
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.reloadTables();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection getWellTopDatabase() {
        return VolumeProject.singleton().getWellTopDatabase();
    }

    public void addPick(Ensemble ensemble, String pickName) {
        try {
            if (!this.m_overlayCheck.isSelected()) {
                return;
            }
            if (ensemble == null) {
                return;
            }
            if (this.m_axisGrid == null) {
                this.reloadSurface();
            }
            if (this.m_axisGrid == null) {
                return;
            }
            boolean useVelField = false;
            VelocityLocationCollection velField = RefractionStaticsProject.singleton().getVelocityManager().getVelocityLocationCollection();
            if (this.m_velMethod.getSelectedIndex() == 1 && velField != null && velField.size() > 0) {
                useVelField = true;
            }
            boolean treatAsTime = this.m_velMethod.getSelectedIndex() == 2;
            EnsembleFirstBreakPickPlotData ppd = ensemble.pickPlotData();
            ppd.clear();
            ppd.add(pickName, Color.black, 3, Java2D_PointSymbol.FilledSquare);
            int headerPick = ensemble.dictionary().addEntry("Trace", pickName, DataType.Float);
            int headerSurface = ensemble.dictionary().addEntry("Trace", "ZeroMeanSurface", DataType.Float);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                ensemble.trace(t).header().putFloat(headerPick, -9999.0f);
                ensemble.trace(t).header().putFloat(headerSurface, -9999.0f);
            }
            int indexSurfaceX = this.m_surfaceTable.column_indexOfColumn("X");
            int indexSurfaceY = this.m_surfaceTable.column_indexOfColumn("Y");
            int indexSurfaceZ = this.m_surfaceTable.column_indexOfColumn("Z");
            if (!ensemble.dictionary().containsEntry("Trace", "CdpX")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "CdpY")) {
                return;
            }
            int indexX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            double twoWayTime = this.m_timeSlider.getDoubleValue();
            double velocity = this.m_velocitySlider.getDoubleValue();
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                double x = header.getDouble(indexX);
                double y = header.getDouble(indexY);
                if (useVelField) {
                    velocity = velField.getVelocityAtTime(x, y, twoWayTime);
                }
                float z = this.m_axisGrid.getValue(x, y);
                double time = twoWayTime - 2000.0 * (double)z / velocity;
                if (treatAsTime) {
                    time = twoWayTime + (double)z;
                }
                header.putDouble(headerSurface, z);
                header.putDouble(headerPick, time);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addPick_ISQ(Ensemble ensemble, String pickName) {
        try {
            if (ensemble == null) {
                return;
            }
            EnsembleFirstBreakPickPlotData ppd = ensemble.pickPlotData();
            ppd.clear();
            ppd.add(pickName, Color.black, 3, Java2D_PointSymbol.FilledSquare);
            int headerPick = ensemble.dictionary().addEntry("Trace", pickName, DataType.Float);
            int headerSurface = ensemble.dictionary().addEntry("Trace", "ZeroMeanSurface", DataType.Float);
            int headerHorizon = ensemble.dictionary().addEntry("Trace", this.m_horizonName, DataType.Float);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                ensemble.trace(t).header().putFloat(headerPick, -9999.0f);
                ensemble.trace(t).header().putFloat(headerSurface, -9999.0f);
                ensemble.trace(t).header().putFloat(headerHorizon, -9999.0f);
            }
            if (!this.m_overlayCheck.isSelected()) {
                return;
            }
            if (this.m_surfaceTable == null) {
                return;
            }
            if (this.m_surfaceTable.row_count() < 1) {
                return;
            }
            int indexSurfaceX = this.m_surfaceTable.column_indexOfColumn("X");
            int indexSurfaceY = this.m_surfaceTable.column_indexOfColumn("Y");
            int indexSurfaceZ = this.m_surfaceTable.column_indexOfColumn("Z");
            int indexSurfaceH = this.m_surfaceTable.column_indexOfColumn(this.m_horizonName);
            if (!ensemble.dictionary().containsEntry("Trace", "CdpX")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "CdpY")) {
                return;
            }
            int indexX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            double twoWayTime = this.m_timeSlider.getDoubleValue();
            double velocity = this.m_velocitySlider.getDoubleValue();
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                double x = header.getDouble(indexX);
                double y = header.getDouble(indexY);
                double sumZ = 0.0;
                double sumH = 0.0;
                double sum2 = 1.0E-60;
                for (int row = 0; row < this.m_surfaceTable.row_count(); ++row) {
                    double dx = x - this.m_surfaceTable.getDouble(row, indexSurfaceX);
                    double dy = y - this.m_surfaceTable.getDouble(row, indexSurfaceY);
                    double z = this.m_surfaceTable.getDouble(row, indexSurfaceZ);
                    double h = this.m_surfaceTable.getDouble(row, indexSurfaceH);
                    double w = 1.0 / (1.0 + dx * dx + dy * dy);
                    w *= w;
                    sumH += h * w;
                    sumZ += z * w;
                    sum2 += w;
                }
                double horizon = sumH / sum2;
                double surface = sumZ / sum2;
                double time = twoWayTime - 2000.0 * surface / velocity;
                header.putDouble(headerHorizon, horizon);
                header.putDouble(headerSurface, surface);
                header.putDouble(headerPick, time);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadSurface() {
        try {
            this.m_axisGrid = null;
            this.m_surfaceTable = null;
            String tableName = this.m_tableCombo.getSelectedString();
            String xName = this.m_xCombo.getSelectedString();
            String yName = this.m_yCombo.getSelectedString();
            this.m_horizonName = this.m_cCombo.getSelectedString();
            this.m_surfaceTable = Tools_WellTop.loadSurfaceTable(tableName, xName, yName, this.m_horizonName);
            if (this.m_surfaceTable == null) {
                return;
            }
            int len = this.m_surfaceTable.row_count();
            if (len < 1) {
                return;
            }
            int indexSurfaceX = this.m_surfaceTable.column_indexOfColumn("X");
            int indexSurfaceY = this.m_surfaceTable.column_indexOfColumn("Y");
            int indexSurfaceZ = this.m_surfaceTable.column_indexOfColumn("Z");
            double[] x = new double[len];
            double[] y = new double[len];
            double[] z = new double[len];
            for (int n = 0; n < len; ++n) {
                x[n] = this.m_surfaceTable.getDouble(n, indexSurfaceX);
                y[n] = this.m_surfaceTable.getDouble(n, indexSurfaceY);
                z[n] = this.m_surfaceTable.getDouble(n, indexSurfaceZ);
            }
            this.m_axisGrid = new AxisGrid_Interpolator();
            this.m_axisGrid.setInputData(x, y, z);
            double gridSize = 200.0;
            if (RefractionStaticsProject.singleton().units_feet()) {
                gridSize = 500.0;
            }
            this.m_axisGrid.ApplyPlane = true;
            this.m_axisGrid.createGrid(2000.0, gridSize, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadTables() {
        try {
            this.m_axisGrid = null;
            ArrayList<String> table = this.getWellTopDatabase().getTableNames();
            this.m_tableCombo.setStringArray(table);
            this.reloadColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadColumns() {
        try {
            String name = this.m_tableCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            ArrayList<String> cols = this.getWellTopDatabase().listOfColumnNames(name);
            this.m_xCombo.setStringArray(cols);
            this.m_yCombo.setStringArray(cols);
            this.m_cCombo.setStringArray(cols);
            this.m_axisGrid = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadTableButton) {
                this.reloadTables();
                return;
            }
            if (e.getSource() == this.m_overlayCheck) {
                this.m_listener.broadcast(this, null);
                return;
            }
            if (e.getSource() == this.m_applyButton) {
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_tableCombo) {
                this.reloadColumns();
                this.m_axisGrid = null;
                return;
            }
            if (sender == this.m_xCombo || sender == this.m_yCombo || sender == this.m_cCombo) {
                this.m_axisGrid = null;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

