/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Stack.Attributes;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.FFT.FFT_Interpolator;
import com.PecosCore.FFT.FFT_ShortWindowAnalysis;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Volume.VolumeStackController;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Attribute_FrequencyWidget
extends LinearLayoutWidget
implements ActionListener,
DocumentListener {
    protected VolumeStackController m_stackController;
    protected EnsembleWorker_Sequence m_sequence;
    protected JCheckBox m_checkApplySequence = new JCheckBox("Apply processing sequence");
    protected JCheckBox m_chkApplyTaper = new JCheckBox("Apply taper zone");
    protected JTextField m_textTaperZone = new JTextField("12");
    protected JTextField m_textWindowLength = new JTextField("64");
    protected JLabel m_lblWindowInfo = new JLabel("128", 0);
    protected JLabel m_lblTaperInfo = new JLabel("128", 0);
    protected float m_window;
    protected float m_taper;
    protected JTextField m_textAbsName = new JTextField("EA1");
    protected JTextField m_textAbsMinFreq = new JTextField("40");
    protected JTextField m_textAbsMaxFreq = new JTextField("80");
    protected JLabel m_lblAbsInfo = new JLabel("", 0);
    protected JButton m_btnRun;
    protected JLabel m_lblRun;
    protected JProgressBar m_progress = new JProgressBar();
    protected FFT_Interpolator m_fft = new FFT_Interpolator();
    protected int m_upTick = 4;
    protected float m_sampleInterval = 4.0f;

    public Attribute_FrequencyWidget(VolumeStackController sc, EnsembleWorker_Sequence sequence) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_stackController = sc;
            this.m_sampleInterval = sc.sampleInterval();
            this.m_sequence = sequence;
            this.addComponent(this.m_checkApplySequence, 0);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Window and taper lengths", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Window (ms)"), this.m_textWindowLength);
            grid.addSimple(row++, new JLabel("Taper (ms)"), this.m_textTaperZone);
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyTaper);
            grid.addComponent(this.m_lblWindowInfo, row++, 0, 1.0, 1.0, 1, 2);
            grid.addComponent(this.m_lblTaperInfo, row++, 0, 1.0, 1.0, 1, 2);
            this.m_textTaperZone.getDocument().addDocumentListener(this);
            this.m_textWindowLength.getDocument().addDocumentListener(this);
            this.m_chkApplyTaper.addActionListener(this);
            grid = this.createGridLayoutWidget(0, "Energy Absorption options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Name"), this.m_textAbsName);
            grid.addSimple(row++, new JLabel("Start frequency"), this.m_textAbsMinFreq);
            grid.addSimple(row++, new JLabel("End frequency"), this.m_textAbsMaxFreq);
            grid.addComponent(this.m_lblAbsInfo, row++, 0, 1.0, 1.0, 1, 2);
            this.m_textAbsName.getDocument().addDocumentListener(this);
            this.createGapLabel(20);
            LinearLayoutWidget w = this.createVertical(0, "Create attributes", 0);
            this.m_btnRun = w.createButton("Create attributes", this, 0);
            this.m_lblRun = w.createLabel(" ", 0, 0);
            w.addComponent(this.m_progress, 0);
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_upTick = 4;
            this.m_fft.setNumUptick(this.m_upTick);
            this.checkAbsText();
            this.checkWindow();
            this.checkTaper();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleEnsemble(Ensemble ensemble) {
    }

    public boolean run2() {
        try {
            FFT_ShortWindowAnalysis analyzer = new FFT_ShortWindowAnalysis();
            this.m_progress.setMinimum(0);
            this.m_progress.setMaximum(this.m_stackController.traceCount());
            this.m_progress.setValue(0);
            this.m_progress.paintImmediately(0, 0, 1000, 40);
            int numPerChunk = 10;
            Ensemble e = new Ensemble();
            int inputSamplesPerTrace = this.m_stackController.sampleCount();
            float[] inputData = new float[inputSamplesPerTrace];
            boolean done = false;
            long startTraceID = 0L;
            long numRead = 0L;
            long qcIndexInFile = 0L;
            while (!done) {
                String sql = String.format(" WHERE TraceID >= %d AND TraceID < %d", startTraceID, startTraceID + (long)numPerChunk);
                this.m_stackController.ensemble_Sql(e, sql);
                int indexIndexInFile = e.dictionary().getEntryIndex("Trace", "IndexInFile");
                for (int n = 0; n < e.traceCount(); ++n) {
                    EnsembleTrace trace = e.trace(n);
                    if (trace.header().getLong(indexIndexInFile) != qcIndexInFile) {
                        throw new Exception("trace.header().getLong(indexIndexInFile) != qcIndexInFile");
                    }
                    FloatArrayWrapper data = trace.data();
                    data.copyToArray(inputData);
                    analyzer.insertTraceData(inputData, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
                    analyzer.computeResampledTrace();
                    analyzer.computeAllData(this.m_window, this.m_taper, this.m_chkApplyTaper.isSelected());
                    if (qcIndexInFile == 1000L) {
                        return true;
                    }
                    ++qcIndexInFile;
                }
                long maxTraceID = Tools_Ensemble.getMaximumHeaderValue(e, "Trace", "TraceID");
                this.m_progress.setValue((int)(numRead += (long)e.traceCount()));
                this.m_progress.paintImmediately(0, 0, 1000, 40);
                done = e.traceCount() < 1;
                startTraceID = maxTraceID + 1L;
            }
            this.m_progress.setValue(0);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public void run() {
        try {
            if (this.run2()) {
                return;
            }
            this.m_upTick = 4;
            this.m_fft.setNumUptick(this.m_upTick);
            this.m_fft.prepareWindowAndTaper((int)(0.5f + this.m_window / this.m_sampleInterval), (int)(0.5f + this.m_taper / this.m_sampleInterval), this.m_chkApplyTaper.isSelected());
            float sampleIntervalUp = this.m_sampleInterval / (float)this.m_upTick;
            int inputSamplesPerTrace = this.m_stackController.sampleCount();
            float[] inputData = new float[inputSamplesPerTrace];
            float[] alpha = new float[inputSamplesPerTrace];
            float[] amp = new float[inputSamplesPerTrace];
            float[] sumX = new float[inputSamplesPerTrace];
            float[] sumY = new float[inputSamplesPerTrace];
            float[] sumXY = new float[inputSamplesPerTrace];
            float[] sumXX = new float[inputSamplesPerTrace];
            int[] count = new int[inputSamplesPerTrace];
            boolean useWindow = true;
            double minFreq = Tools_Widget.extractDouble(this.m_textAbsMinFreq, 30.0, 5.0, 80.0);
            double maxFreq = Tools_Widget.extractDouble(this.m_textAbsMaxFreq, 70.0, minFreq + 1.0, 120.0);
            double frequencyConst = 1.0 / (0.001 * (double)sampleIntervalUp * (double)this.m_fft.bufferedWindowArray().length);
            int startSampleFreq = (int)(0.5 + minFreq / frequencyConst);
            int endSampleFreq = (int)(0.5 + maxFreq / frequencyConst);
            startSampleFreq = Math.max(1, startSampleFreq);
            endSampleFreq = Math.min(endSampleFreq, this.m_fft.bufferedWindowArray().length / 2 - 1);
            this.m_progress.setMinimum(0);
            this.m_progress.setMaximum(this.m_stackController.traceCount());
            this.m_progress.setValue(0);
            this.m_progress.paintImmediately(0, 0, 1000, 40);
            int numPerChunk = 10;
            Ensemble e = new Ensemble();
            boolean done = false;
            long startTraceID = 0L;
            long numRead = 0L;
            long qcIndexInFile = 0L;
            while (!done) {
                String sql = String.format(" WHERE TraceID >= %d AND TraceID < %d", startTraceID, startTraceID + (long)numPerChunk);
                this.m_stackController.ensemble_Sql(e, sql);
                int indexIndexInFile = e.dictionary().getEntryIndex("Trace", "IndexInFile");
                for (int n = 0; n < e.traceCount(); ++n) {
                    int s;
                    for (int s2 = 0; s2 < sumX.length; ++s2) {
                        count[s2] = 0;
                        sumX[s2] = 0.0f;
                        sumY[s2] = 0.0f;
                        sumXY[s2] = 0.0f;
                        sumXX[s2] = 0.0f;
                    }
                    EnsembleTrace trace = e.trace(n);
                    if (trace.header().getLong(indexIndexInFile) != qcIndexInFile) {
                        throw new Exception("trace.header().getLong(indexIndexInFile) != qcIndexInFile");
                    }
                    FloatArrayWrapper data = trace.data();
                    data.copyToArray(inputData);
                    this.m_fft.setInputTrace(inputData);
                    for (s = 0; s < inputData.length; ++s) {
                        float max;
                        int sumrad = 1;
                        if (s < 10 || s >= inputData.length - 10) {
                            sumrad = 1;
                        }
                        int mid = s * this.m_upTick;
                        if (s == inputData.length / 2) {
                            done = false;
                        }
                        if (!((max = this.m_fft.prepareCenteredWindow(mid, true)) > 1.0E-10f)) continue;
                        float[] windowAmplitude = this.m_fft.windowAmplitude();
                        for (int f = startSampleFreq; f <= endSampleFreq; ++f) {
                            double freq = (double)f * frequencyConst;
                            for (int p = s - sumrad; p <= s + sumrad; ++p) {
                                if (p < 0 || p >= inputData.length) continue;
                                int n2 = p;
                                count[n2] = count[n2] + 1;
                                int n3 = p;
                                sumX[n3] = (float)((double)sumX[n3] + freq);
                                int n4 = p;
                                sumY[n4] = sumY[n4] + windowAmplitude[f];
                                int n5 = p;
                                sumXY[n5] = (float)((double)sumXY[n5] + freq * (double)windowAmplitude[f]);
                                int n6 = p;
                                sumXX[n6] = (float)((double)sumXX[n6] + freq * freq);
                            }
                        }
                    }
                    for (s = 0; s < inputData.length; ++s) {
                        double sumBottom = (float)count[s] * sumXX[s] - sumX[s] * sumX[s];
                        double sumTop = (float)count[s] * sumXY[s] - sumX[s] * sumY[s];
                        alpha[s] = 0.0f;
                        amp[s] = 0.0f;
                        if (Math.abs(sumBottom) > (double)1.0E-10f) {
                            double a = sumTop / sumBottom;
                            double b = ((double)sumY[s] - a * (double)sumX[s]) / (double)count[s];
                            alpha[s] = (float)a;
                            amp[s] = (float)b;
                        }
                        if (qcIndexInFile != 100L) continue;
                        System.out.println(String.format("%d  %f  %f  %f  %f", s, Float.valueOf(inputData[s]), Float.valueOf(alpha[s]), Float.valueOf(amp[s]), Float.valueOf(alpha[s] * amp[s])));
                    }
                    if (qcIndexInFile == 100L) {
                        return;
                    }
                    ++qcIndexInFile;
                }
                long maxTraceID = Tools_Ensemble.getMaximumHeaderValue(e, "Trace", "TraceID");
                this.m_progress.setValue((int)(numRead += (long)e.traceCount()));
                this.m_progress.paintImmediately(0, 0, 1000, 40);
                done = e.traceCount() < 1;
                startTraceID = maxTraceID + 1L;
            }
            this.m_progress.setValue(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnRun) {
                this.run();
                return;
            }
            if (e.getSource() == this.m_chkApplyTaper) {
                this.checkTaper();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void checkAbsText() {
        try {
            String name = this.m_textAbsName.getText();
            String path = this.m_stackController.attributePath();
            String fileName = path + "/" + name + ".sgy";
            this.m_lblAbsInfo.setText(fileName);
            this.m_lblAbsInfo.setForeground(Color.BLUE);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void checkWindow() {
        try {
            this.m_window = Float.parseFloat(this.m_textWindowLength.getText());
            int num = (int)(0.5f + this.m_window / this.m_sampleInterval);
            num = Math.max(num, 4);
            num = Math.min(num, 500);
            this.m_window = (float)num * this.m_sampleInterval;
            this.m_lblWindowInfo.setText("Actual window length: " + Float.toString(this.m_window));
            this.m_lblWindowInfo.setForeground(Color.blue);
            return;
        }
        catch (Exception num) {
            try {
                this.m_lblWindowInfo.setText("Failed to interpret window length");
                this.m_lblWindowInfo.setForeground(Color.red);
                this.m_window = -9999.0f;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
            return;
        }
    }

    protected void checkTaper() {
        try {
            if (!this.m_chkApplyTaper.isSelected()) {
                this.m_lblTaperInfo.setText("Taper zone not applied");
                this.m_lblTaperInfo.setForeground(Color.red);
                this.m_taper = -9999.0f;
                return;
            }
            this.m_taper = Float.parseFloat(this.m_textTaperZone.getText());
            int num = (int)(0.5f + this.m_taper / this.m_sampleInterval);
            num = Math.max(num, 0);
            num = Math.min(num, 500);
            this.m_taper = (float)num * this.m_sampleInterval;
            this.m_lblTaperInfo.setText("Actual taper length: " + Float.toString(this.m_taper));
            this.m_lblTaperInfo.setForeground(Color.blue);
            return;
        }
        catch (Exception num) {
            try {
                this.m_lblTaperInfo.setText("Failed to interpret taper zone length");
                this.m_lblTaperInfo.setForeground(Color.red);
                this.m_taper = -9999.0f;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
            return;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_textAbsName.getDocument()) {
                this.checkAbsText();
                return;
            }
            if (e.getDocument() == this.m_textTaperZone.getDocument() || e.getDocument() == this.m_textWindowLength.getDocument()) {
                this.checkWindow();
                this.checkTaper();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_textAbsName.getDocument()) {
                this.checkAbsText();
                return;
            }
            if (e.getDocument() == this.m_textTaperZone.getDocument() || e.getDocument() == this.m_textWindowLength.getDocument()) {
                this.checkWindow();
                this.checkTaper();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_textAbsName.getDocument()) {
                this.checkAbsText();
                return;
            }
            if (e.getDocument() == this.m_textTaperZone.getDocument() || e.getDocument() == this.m_textWindowLength.getDocument()) {
                this.checkWindow();
                this.checkTaper();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

