/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Import;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Import.Action_ImportSegyStack;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Volume.Import.VolumeStackNameSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImportVolumeSegyDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Launch import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected VolumeStackNameSelectionWidget m_nameWidget = new VolumeStackNameSelectionWidget(3);
    protected FileWidget m_segyFileWidget;
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected JTextField m_dictText;
    protected JButton m_dictButton;
    protected JLabel m_dictLabel = new JLabel(" ");

    public ImportVolumeSegyDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_nameWidget, 0);
            middle.addComponent(this.m_dimWidget, 0);
            this.m_dimWidget.listener().addListener(this);
            middle.addComponent(this.createDictWidget(), 0);
            this.m_segyFileWidget = new FileWidget(false, 3, "Select SEG-Y stack file", this);
            middle.addComponent(this.m_segyFileWidget, 10);
            this.m_nameWidget.getListenerController().addListener(this);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.dataOK();
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(650, this.getSize().height);
            this.setTitle("Create a refraction project using SEG-Y files");
            this.setLocationRelativeTo(null);
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createDictWidget() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Select SEG-Y dictionary");
            LinearLayoutWidget sub = w.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_dictText = sub.createTextField("", null, 10);
            this.m_dictText.setEditable(false);
            this.m_dictButton = Tools_Bitmap.makeButton(sub, BitmapEnum.FileOpen, "", (ActionListener)this);
            sub = w.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            sub.addComponent(this.m_dictLabel, 10);
            return w;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean checkDict() {
        try {
            String fileName = this.m_dictText.getText();
            this.m_dictLabel.setText(" ");
            if (fileName.isEmpty()) {
                this.m_dictLabel.setForeground(Color.red);
                this.m_dictLabel.setText("Please select a  SEG-Y dictionary file");
                return false;
            }
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.m_dictLabel.setForeground(Color.red);
                this.m_dictLabel.setText("File does not exist");
                return false;
            }
            Segy_Dictionary dict = new Segy_Dictionary();
            dict.setOpenFileName(fileName);
            if (!dict.isFileNameValid()) {
                this.m_dictLabel.setForeground(Color.red);
                this.m_dictLabel.setText("Not a valid dictionary file");
                return false;
            }
            boolean is3D = this.m_dimWidget.dimension().equalsIgnoreCase("3D");
            if (!dict.isValidPostStack(is3D)) {
                this.m_dictLabel.setForeground(Color.red);
                this.m_dictLabel.setText(dict.ReasonNotValidPostStack);
                return false;
            }
            this.m_dictLabel.setForeground(Color.blue);
            this.m_dictLabel.setText("Dictionary appears to be okay");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            this.m_dictLabel.setText(" ");
            this.m_btnOK.setEnabled(false);
            boolean groovy = true;
            if (!this.m_nameWidget.checkName()) {
                groovy = false;
            }
            if (!this.checkDict()) {
                groovy = false;
            }
            Segy segy = new Segy();
            String fileName = this.m_segyFileWidget.getText();
            segy.setFileName(fileName);
            if (!segy.isFileOK()) {
                groovy = false;
            }
            this.m_btnOK.setEnabled(groovy);
            return groovy;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_dictButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter(" Segy dictionary", Segy_Dictionary.FileSuffix);
                String fileName = Tools_Chooser.getFileName("Select Segy dictionary file", filter);
                if (fileName == null) {
                    return;
                }
                this.m_dictText.setText(fileName);
                this.dataOK();
            }
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                Action_ImportSegyStack action = new Action_ImportSegyStack();
                String parentPath = VolumeProject.singleton().stackContainerPath();
                action.Hasher.string_put("Dimension", this.m_dimWidget.dimension());
                action.Hasher.string_put("ParentPath", parentPath);
                action.Hasher.string_put("StackName", this.m_nameWidget.name());
                action.Hasher.string_put("DictionaryFile", this.m_dictText.getText());
                action.Hasher.string_put("SEGY", this.m_segyFileWidget.getText());
                VolumeProject.singleton().executeSingleAction(action);
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

