/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Synthetic;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Export.Action_ExportGLI;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Syn3DDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Create file");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JTextField m_txtV0 = new JTextField("3000");
    protected JTextField m_txtV1 = new JTextField("6000");
    protected JTextField m_txtV2 = new JTextField("8000");
    protected JTextField m_txtZ1 = new JTextField("4500");
    protected JTextField m_txtZ2 = new JTextField("3800");
    protected JTextField m_txtFile = new JTextField("");
    protected FileWidget m_fileWidget;
    protected JButton m_btnOpen;
    protected Range_Double m_rangeElev;

    public Syn3DDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_rangeElev = Tools_RefractionStaticsProject.getRange("Elevation", true, true);
            double minZ = this.m_rangeElev.rangeMin();
            String s = Integer.toString((int)this.m_rangeElev.rangeMin()) + " - " + Integer.toString((int)this.m_rangeElev.rangeMax());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            JLabel lbl = middle.createLabel("This does not modify the existing picks", 0, 0);
            lbl.setForeground(Color.blue);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "Refractor model", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Weathering velocity"), this.m_txtV0);
            grid.addSimple(row++, new JLabel("Surface elevation range"), new JLabel(s));
            grid.addSimple(row++, new JLabel("First refractor elevation"), this.m_txtZ1);
            grid.addSimple(row++, new JLabel("First refractor velocity"), this.m_txtV1);
            grid.addSimple(row++, new JLabel("Second refractor elevation"), this.m_txtZ2);
            grid.addSimple(row++, new JLabel("Second refractor velocity"), this.m_txtV2);
            this.m_txtZ1.setText(Double.toString(minZ - 200.0));
            this.m_txtZ2.setText(Double.toString(minZ - 800.0));
            LinearLayoutWidget file = middle.createHorizontal(3, "Output file name", 0);
            file.addComponent(this.m_txtFile, 10);
            this.m_txtFile.setEnabled(false);
            this.m_btnOpen = file.createButton("Select", this, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            Tools_FontChanger.changeSizeOfFont(bottom, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(middle, -2, null, true);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(400, this.getSize().height);
            this.setTitle("Synthetic 3D GLI file");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOpen) {
                String fileName = Tools_Chooser.getSaveFileName("gli");
                if (fileName == null) {
                    return;
                }
                this.m_txtFile.setText(fileName);
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                double minZ = this.m_rangeElev.rangeMin();
                Action_ExportGLI action = new Action_ExportGLI();
                action.V0 = Tools_Widget.extractDouble(this.m_txtV0, 3000.0, 300.0, 10000.0);
                action.V1 = Tools_Widget.extractDouble(this.m_txtV1, 6000.0, action.V0 + 300.0, action.V0 + 10000.0);
                action.V2 = Tools_Widget.extractDouble(this.m_txtV2, 8000.0, action.V1 + 300.0, action.V1 + 10000.0);
                action.Z1 = Tools_Widget.extractDouble(this.m_txtZ1, -2000.0, minZ - 2000.0, minZ - 100.0);
                action.Z2 = Tools_Widget.extractDouble(this.m_txtZ2, -4000.0, action.Z1 - 2000.0, action.Z1 - 100.0);
                action.FileName = this.m_txtFile.getText();
                if (action.FileName.isEmpty()) {
                    return;
                }
                project.executeSingleAction(action);
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

